#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include <asm/segment.h>
#include "StJude_lkm.h"


extern SJ_PRIV *sj_priv_hash[SJ_PRIV_HASH];
extern SJ_MEMORY *sj_argv_memory_hash[SJ_MEMORY_HASH];

extern int sjexecve;

extern SJ_RULEBASE sj_rulebase[];

/*
 * This is it, what we have been watiing for, the grand show.
 *
 * First, check if we are a privlaged process. If no, then let
 * them pass.
 *
 * If we are a privlaged process, then we need to make shure that
 * what we want to execute is ok. We do this by calling check_priv_record.
 * If it is ok, then we will let them pass, but we have to do some
 * record keeping first.
 * 
 *    We need to modify the current privlage record to reflect the new
 *    command we are executing. We do this by changing the restriction
 *    list associated with the current process. The quickest way to do
 *    this is 
 *    modify_priv_record_restriction(pid,get_restriction_index(pid,argv)))
 *
 */

int
sj_do_execve (struct pt_regs regs)
{
  long sj_res;

  char * filename = (char *) regs.ebx;
  char ** argv = (char **) regs.ecx;
  char ** envp = (char **) regs.edx;
  struct sj_argv_memory *memory;
  struct sj_priv *priv;
  int sj_i,sj_j,sj_argc;
  char sj_argv[MAX_KEY_ELEMENTS][BUFFSIZE];

#ifdef __SMP__
read_lock(&sj_running);
read_lock(&tasklist_lock);
#endif
#ifdef DEBUG
printk(" -----------------------------SYSCALL BY %d------------------------\n",current->pid);
#endif

#ifdef DEBUG
       printk("  (StJude) sj_execve: Entered sj_do_execve()\n");
#endif
 
   
  sj_argc = count(argv,MAX_KEY_ELEMENTS);
  sj_argc = (sj_argc == -E2BIG) ? MAX_KEY_ELEMENTS : sj_argc;
  
   for (sj_i = 0; sj_i < MAX_KEY_ELEMENTS; sj_i++)
	for (sj_j = 0; sj_j < BUFFSIZE; sj_j++)
	      sj_argv[sj_i][sj_j] = '\0';

   for (sj_i = 0; sj_i < BUFFSIZE && filename[sj_i] != '\0';
           sj_i++)
            sj_argv[0][sj_i] = filename[sj_i];
 
   sj_argv[0][sj_i] = '\0';

   
   for (sj_i = 1; sj_i < sj_argc; sj_i++)
     {
        for (sj_j = 0; sj_j < BUFFSIZE && argv[sj_i][sj_j] != '\0';
             sj_j++)
          {
              sj_argv[sj_i][sj_j] = argv[sj_i][sj_j];
          } 
          sj_argv[sj_i][sj_j] = '\0';
     } 

#ifdef __SMP__
write_lock(&priv_lock); 
write_lock(&argv_memory_lock); 
#endif

   memory = get_argv_memory(current->pid);
   priv = get_priv_record(current->pid);

 
   if (!(current->uid && current->euid && current->suid) )
   {
      int r_index = 0;

    
      if (!priv) {
      suid_hack(current);
      } 

     

    if (!check_priv_record(current->pid,sj_argv))
       {
          char *argv_string;
          char *parent_string;
          struct sj_argv_memory *p_memory;

          int i,j,k;
      

          argv_string = kmalloc( sizeof(char) * ( ( (BUFFSIZE+2) * 
                                     MAX_KEY_ELEMENTS)), GFP_KERNEL);  
          parent_string = kmalloc( sizeof(char) * ( ( (BUFFSIZE+2) * 
                                     MAX_KEY_ELEMENTS)), GFP_KERNEL);  

          if ( ! ( argv_string && parent_string ) )
            { 
#ifdef LEARNING

		printk("(STJUDE) LEARN-WARNING: CANT ALLOCATE MEMORY TO GENERATE LEARNING OUTPUT\n"); 	
                goto nomem_for_strings;

#else

		    printk("(STJUDE) NOTICE: Process was PID %d. \n");
		    printk("(STJUDE) NOTICE: NON-FATIL ERROR: UNABLE TO ALLOCATE MEMORY FOR FURTHER INFORMATION. RESPONSE CALLED.\n");
                    goto nomem_for_strings;
#endif
	  }

          for (i = 0; i < BUFFSIZE * MAX_KEY_ELEMENTS; i++)
		{ argv_string[i] = '\0'; parent_string[i] = '\0'; }


          k = 0; 
          for (i = 0; i < MAX_KEY_ELEMENTS && sj_argv[i][0] !='\0'; i++)
          {
              for (j = 0; j < BUFFSIZE && sj_argv[i][j] != '\0'; j++)
                 {
                    argv_string[k++] = sj_argv[i][j];
                    if (k >= ( BUFFSIZE * MAX_KEY_ELEMENTS)-2)
			       break;
                 }
                 
                     
                    if (k >= ( BUFFSIZE * MAX_KEY_ELEMENTS)-2)
			       break;
#ifdef LEARNING
		    argv_string[k++] = ':';
		    argv_string[k++] = ':';
#else

                    argv_string[k++] = ' ';
#endif
           }

#ifdef LEARNING
           argv_string[k-2] = '\0';
#else
           argv_string[k] = '\0';
#endif
    
           p_memory = get_argv_memory(current->pid);
           if (p_memory)
           {

          k = 0; 
          for (i = 0; i < MAX_KEY_ELEMENTS && p_memory->argv[i][0] != '\0'; i++)
          {
              for (j = 0; j < BUFFSIZE && p_memory->argv[i][j] != '\0'; j++)
                 {
                    parent_string[k++] = p_memory->argv[i][j];
                    if (k >= ( BUFFSIZE * MAX_KEY_ELEMENTS)-2)
			       break;
                 }
                     
                    if (k >= ( BUFFSIZE * MAX_KEY_ELEMENTS)-2)
			       break; 
#ifdef LEARNING
		    parent_string[k++] = ':';
		    parent_string[k++] = ':';
#else  

                    parent_string[k++] = ' '; 
#endif 
           }

#ifdef LEARNING
           parent_string[k-2] = '\0';
#else
           parent_string[k] = '\0';
#endif

           }
           
		/* Apparently we dont't have permission to do 
                   what we are wanting to do. First we bitch,
                   then we gripe. */

#ifdef SILENT
		goto silent_no_notice;
#endif

#ifdef LEARNING

		printk("(STJUDE) LEARN: [%s] executed [%s]\n",parent_string,argv_string); 	

#else

		printk("(STJUDE) NOTICE: Execution Request Violates Privlages. Data Follows.\n");
		printk("(STJUDE) NOTICE: UID: %d, EUID %d, Command Line: %s\n",current->uid, current->euid, argv_string);
		if (p_memory)
		    printk("(STJUDE) NOTICE: Process was PID %d. Requestor's Argv: %s\n",current->pid, parent_string);

#endif

#ifdef SILENT
silent_no_notice:
#endif
        /* Free the memory for our strings... */
        if (argv_string) kfree(argv_string);
        if (parent_string) kfree(parent_string);

nomem_for_strings:
#if defined (__SMP__) && ! defined (LEARNING)
         write_unlock(&argv_memory_lock);
         write_unlock(&priv_lock);
         read_unlock(&tasklist_lock); 
         read_unlock(&sj_running);
#endif

#ifndef LEARNING
	return sj_do_response(filename, argv, envp);
#endif
       }
#ifndef LEARNING
       else
#endif
       {

/* 
   If it wasn't illegal, and we are still privlaged, then we need to 
   update our privlage record to the restrictions for our new process. 
   We will do this by figuring out the index to our new restriction, 
   destroying our privlage record and then creating a new privlage 
   record based on the index we have.
 */

            
            r_index =  get_restriction_index(current->pid, memory->argv);
            destroy_priv_record(current->pid); 
            create_priv_record(current->pid,r_index);

       }


		 

   } /* Of privlaged Code */
   else
   {
     if (priv)
        {
	 /* 
          * A privlage record exists for a non-privlaged process..
          * This can occur if a privlaged binary execves a setuid-non-privlaged
          * binary. By our logic, that process will not encounter any problems
          * untill it has successfully executed another setuid root binary and
          * transitions back into a privlaged state. In some circumstances it
          * may occur that the new setuid will not go thru the suid hack and
          * be bound by the restrictions of its distant predicessor. This may
          * be more restrictive or less restrictive, but either way its unintended
          * and thus bad.
	  *
          * This fixes it.
          */

           destroy_priv_record(current->pid);
           priv = NULL;

        } 
   }

    if (memory) 
       {
          int i,j;
          
          for (i = 0; i < MAX_KEY_ELEMENTS; i++)
		{
            for (j = 0; j < BUFFSIZE; j++)
	         {
		    memory->argv[i][j] = sj_argv[i][j]; }
                 }
		 memory->argv[i][BUFFSIZE-1] = '\0';
       }

#ifdef __SMP__
write_unlock(&argv_memory_lock);
write_unlock(&priv_lock);
read_unlock(&tasklist_lock);
read_unlock(&sj_running);
#endif
 

   
			
  __asm__ volatile ("int $0x80":"=a" (sj_res):"0" (sjexecve), "b" ((long) (filename)), "c" ((long) (argv)), "d" ((long) (envp)));
  
  return (int) sj_res;
}

