#define __KERNEL__

/* Saint Jude, Linux Kernel Module.
 * Verions: 0.11
 *
 * Mar 15, 2001
 *
 * Copyright: Tim Lawless <lawless@netdoor.com>, All rights Reserved.
 * 
 * For lisencing use the Current BSD Lisence Date as of the Date above.
 * 
 * Do not modify this Comment.
 */

#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <asm/segment.h>
#include <asm/unistd.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/signal.h>
#include <linux/slab.h>
#include <asm/unistd.h>
#include <asm/current.h>
#include <sys/syscall.h>
#include <asm/errno.h>
#include <asm/ptrace.h>
#include <asm/pgtable.h>
#include "StJude_lkm.h"
#include "StJude_Rulebase.h"

extern void    *sys_call_table[];
extern int             sjexecve;


SJ_PRIV *sj_priv_hash[SJ_PRIV_HASH];


extern asmlinkage unsigned long (*orig_create_module) (const char *name,
						size_t size);
extern int             (*orig_delete_module) (const char *name);
extern int             (*orig_fork) (struct pt_regs regs);
extern int             (*orig_exit) (int error);
extern int             (*orig_vfork) (struct pt_regs regs);
extern int             (*orig_clone) (struct pt_regs regs);
extern int             (*orig_setuid) (uid_t uid);
extern int             (*orig_setreuid) (uid_t ruid, uid_t euid);
extern int             (*orig_do_execve) (struct pt_regs regs);

inline int check_override(char argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE]);


/*
 *
 * Create a privlage record, and add it to the privlage hash.
 * We will not return the structure.  If we need it later
 * on we can get_priv_record() it.
 *
 * Grow the SJ_PRIV_HASH varable to increase the hash size,
 * thus increasing the performance-- at a cost to ram. 
 * If there is a large enough hit (searchign) , we may want to make
 * it a tree.
 *
 */

struct sj_priv *
create_priv_record(pid_t pid, int restriction_index)
{
    struct sj_priv *priv;

    priv = kmalloc(sizeof(struct sj_priv), GFP_KERNEL);

    if (priv) {
	priv->pid = pid;
	priv->restriction = &sj_rulebase[restriction_index];
	priv->next = sj_priv_hash[priv->pid % SJ_PRIV_HASH];
	sj_priv_hash[priv->pid % SJ_PRIV_HASH] = priv;
	return priv;
    } else {
	printk("<1>Unable to allocate privlage structure\n");
    }
    return NULL;

}

/*
 * 
 * Get a priv record based on its pid.  (DUH!)
 * 
 */


struct sj_priv *
get_priv_record(pid_t pid)
{
    struct sj_priv *priv;


    priv = sj_priv_hash[pid % SJ_PRIV_HASH];

    while (priv != NULL) {
	if (priv->pid == pid)
	    break;

	priv = priv->next;

    }

    return priv;
}

/*
 *
 * Lets hope I get this right, or we could be in
 * for some fun. 
 *
 * First, remove the record from our hash, then
 * free the internal structures. 
 * Then (finally) clear up the structure itself.
 * (I wish i could use a profiler to check memory 
 * in the kernel )
 *
 */

int
destroy_priv_record(pid_t pid)
{
    struct sj_priv *priv;
    struct sj_priv *prev;

    prev = NULL;

    priv = sj_priv_hash[pid % SJ_PRIV_HASH];

    while (priv != NULL) {

	if (priv->pid == pid)
	    break;

	prev = priv;
	priv = priv->next;


    }
    /*
     * If priv does not exist, then we can't delete it. 
     */
    if (priv != NULL) {
	/*
	 * There is more then 1 record.  
	 */

	if (prev != NULL)
	    prev->next = priv->next;
	else
	    /*
	     * priv was the only record in that slot. We will see this
	     * occur more when sj_priv_hash gorws large. We should hope
	     * to have at most about 2-3 items in each hash slot --
	     * busier systems shoudl have more slots. 
	     */
	    sj_priv_hash[pid % SJ_PRIV_HASH] = priv->next;
	kfree(priv);
    } else
	return 0;		/*
				 * Tried to delete a record that doesn't exit 
				 */


    return 1;
}


/*
 * Checks argv aginst pid's restrictions. Return 0 if the argv does not
 * fufill the pid's restrictions, and a non-zero integer otherwise. 
 */
int
check_priv_record(pid_t pid, char argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE])
{
    struct sj_priv *priv;

    priv = get_priv_record(pid);

    if (priv) {
	/*
	 * if null command line, then just  return  1  
	 */
	if (!argv)
	    return 1;


	/*
	 * No restrictions on Execution  
	 */
	if (!sj_strncmp
	    ("ALL", priv->restriction->restrictions[0][0], BUFFSIZE)) {
            int override_rule;
            struct sj_argv_memory *memory;

            memory = get_argv_memory(pid);

                                     /* Remember .. Check the ARGV of
                                        the parent (check memory)..
                                        not the locally scoped argv (child)
                                      */ 
	    if ( ( ( override_rule = check_override(memory->argv) ) + 1 ) )  
                { 
                   if ( ! override_rule )
                          return 0; 
                   else
                   {
                      /*  
                       *  We need to replace the current priv record
                       *  with the proper one... and then jump over to
                       *  the main check. 
                       */

                      priv = NULL;
                      destroy_priv_record(pid);
                      create_priv_record(pid,override_rule);
                      priv = get_priv_record(pid);
                      goto override_check_done;   

                   }
               }
            else
                 return 1;
	}
	/*
	 * Can't execute anything with Privlage  
	 */
	if (!sj_strncmp
	    ("NONE", priv->restriction->restrictions[0][0], BUFFSIZE)) {
	    return 0;
	}
	/*
	 * else we need to check to see if the command line matches a
	 * restriction.. 
	 */
override_check_done:
	if (check_restriction(argv, priv->restriction->restrictions)) {
	    return 1;
	}

    }

    return 0;			/*
				 * Either no matching restrictions were
				 * found, or there is no priv record --
				 * either way, we ain't gonna play. 
				 */

}

/*
 * Think on this, should we check word boundry by word boundry or make the 
 * restriction data be followed by a \0 or a space? 
 *
 * A: We need to process our command line like an array of strings, one for 
 * each argv. Otherwise we could be fooled into executing "/usr/bin/false 
 * prog" when the restriction Was on /usr/bin/false.
 *
 * This will require us to modify how we hande restrictions. Insted of  
 * char ** we would end up with char ***. The outter most being the 
 * restrictions themselves, the second being the individual arguments,
 * and the third being the charaters making up the arguments. ouch.
 * God, I loved perl.
 *
 */

/*
 * ReWrite this Function 
 */
int
check_restriction(char argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE],
		  char
		  *restriction[MAX_RESTRICTIONS]
		  [MAX_RESTRICTIONS_ELEMENTS+1])
{

    int             i,
                    j,
                    match;

    /*
     * We will search the restriction given, 
     */

    for (i = 0; restriction[i][0] != '\0'; i++) {
	match = 1;
	/*
	 * For a restriction to match, each argument must match in in both
	 * length and contents. 
	 */
	for (j = 0; restriction[i][j] != NULL; j++) {
	    /*
	     * First, check length 
	     */

	    if (sj_strlen(argv[j], BUFFSIZE) !=
		sj_strlen(restriction[i][j], BUFFSIZE)) {
		match = 0;
		break;
	    }

	    /*
	     * Next to check that the arguments match in contents 
	     */

	    if (sj_strncmp
		(argv[j], restriction[i][j],
		 sj_strlen(argv[j], BUFFSIZE))) {
		match = 0;
		break;
	    }
	}

	/*
	 * If match is 0 at this point, then we did not find a restriction
	 * that matches the argv, and all is ok. We then return 1 to the
	 * calling function. 
	 */
	if (match) {
	    return 1;
	}
    }

    /*
     * If we reach this point, then we have failed to find a match for our
     * argv in all the restriction lists. Return a 0 to our calling function 
     */
    return 0;
}



  /*
   * Our job is multi part:
   * 
   * 1. Given an argument, and our calling process, find the restriction
   * based on its key fitting the argv. The best key will be the longest key
   * that matches the argv.
   * 
   * 2. If the key is good, and is longer then the best_key, check to see if
   * the restrictions associated with that key are a subset of the pid's
   * restrictions. If yes, then this is the new best key.
   * 
   * Note: The default best key is index 0 and has a length of 0.
   * 
   */



int
get_restriction_index(pid_t pid, char argv[MAX_KEY_ELEMENTS][BUFFSIZE])
{


    struct sj_priv *priv;
    int             best_key_index,
                    best_key_length;
    int             i;
    int             size_a,
                    size_b;


    priv = get_priv_record(pid);


    if (priv && priv->restriction) {

	/*
	 * If the calling pid has the special restriction of "ALL" then we
	 * want to allow the child to inherit this priv despite what its
	 * restrictions are. 
	 */
	if (!sj_strncmp("ALL", priv->restriction->restrictions[0][0], 4)) {

             int override_rule;
             if ( ( ( override_rule = check_override(argv) ) + 1 ) )
                 {
		      return override_rule;
                 }
               
	    return 1;
	}

	if (!sj_strncmp("NONE", priv->restriction->restrictions[0][0], 5)) {
	    return 0;
	}

    }

    /*
     * Search through the restriction table to find the best key match. 
     */
    best_key_index = best_key_length = 0;

    for (i = 2; sj_rulebase[i].key[0] != NULL; i++) {
	char          **res_key;
	int             j,
	                match;
	match = 1;
	/*
	 * For each argument in the restriction .. 
	 */
	for (j = 0, res_key = sj_rulebase[i].key;
	     res_key[j] || j < MAX_KEY_ELEMENTS; j++) {

	    /*
	     * If our argv is shorter then our key, then it is NOT a
	     * match. 
	     */
	    if ((argv[j][0] == '\0') && res_key[j]) {
		match = 0;
		break;
	    }
	    /*
	     * But if our restriction key is shorter or equil size then our
	     * argv, then all is ok. 
	     */
	    if (res_key[j] == NULL) {
		break;
	    }

	    /*
	     * For an argument to match it must be of the same length 
	     * and have the same contents as the element of the key   
	     * This may require multiple entries in our restriction   
	     * Entries in our restriction table when arguments could  
	     * be represented by one or two argumetns                
	     */
	    size_a = sj_strlen(argv[j], BUFFSIZE);
	    size_b = sj_strlen(res_key[j], BUFFSIZE);

	    /*
	     * if ((sj_strlen(argv[j], BUFFSIZE)) !=
	     * (sj_strlen(res_key[j],BUFFSIZE)))  
	     */
	    if (size_a != size_b) {

		match = 0;
		break;
	    }

	    if (sj_strncmp
		(argv[j], res_key[j], sj_strlen(argv[j], BUFFSIZE))) {
		match = 0;
		break;
	    }
	}

	/*
	 * Looks like we have a key match. But before we know this
	 * one will work, we need to check the calling pid's
	 * restriction list aginst the one associated with our key.
	 * If the key's list is a subset of the calling pid's list,
	 * then we have a hit. Otherwise we ignore this key match 
	 */

	if (match && j > best_key_length) {
	    int             subset;
	    subset = 1;

	    /*
	     * If the parent was a privlaged process, then we need to
	     * enshure that the parent's privlages are a superset of the
	     * child's privlages, else we could slowly gain privlages.
	     * 
	     * If the parent does not have privlages, and we are called
	     * to get an index, we will have no prior restictions that we 
	     * can base our assumptions on. 
	     */
	    if (priv) {

		int             old_index,
		                new_index,
		                k;

		for (new_index = 0;
		     sj_rulebase[i].restrictions[new_index][0];
		     new_index++) {


		    int             r_match;
		    r_match = 0;

		    for (old_index = 0;
			 priv->restriction->restrictions[old_index][0];
			 old_index++) {
			r_match = 1;

			/*
			 * For each argument, if we find one non-match then the gig
			 * is off -- we have a "new" restriction in the new list that 
			 * was not in the parent's list.
			 * 
			 * The reason we check for this is to prevent the possible
			 * acquisition of new privlages by executing a certin path of 
			 * programs, eventualy gainging sufficient privlage to bypass 
			 * all protections long enough to violate the system. 
			 */
			for (k = 0;
			     sj_rulebase[i].restrictions[new_index][k]
			     || priv->restriction->
			     restrictions[old_index][k]; k++) {


			    /*
			     * Its cool if both are null, or if both are not
			     * null. Since * we are here, we know at least
			     * one is not null. But * We should check to
			     * verfify that both are non-null. 
			     */
			    if (!
				(sj_rulebase[i].
				 restrictions[new_index][k]
				 && priv->restriction->
				 restrictions[old_index][k])) {
				r_match = 0;
				break;
			    }

			    /*
			     * Again for them to match, they must match in both size
			     * and in contents 
			     */
			    if (sj_strlen
				(sj_rulebase[i].
				 restrictions[new_index][k],
				 BUFFSIZE) !=
				sj_strlen(priv->restriction->
					  restrictions[old_index][k],
					  BUFFSIZE)) {
				r_match = 0;
				break;
			    }

			    if (sj_strncmp
				(sj_rulebase[i].
				 restrictions[new_index][k],
				 priv->restriction->
				 restrictions[old_index][k],
				 sj_strlen(sj_rulebase[i].
					   restrictions[new_index][k],
					   BUFFSIZE))) {
				r_match = 0;
				break;
			    }

			}	/*
				 * of the "k" for loop 
				 */

			/*
			 * If this restriction matches, we need not look any
			 * further for this _new_index_ restriction. Lets
			 * work on our next one.  
			 */
			if (r_match)
			    break;
		    }
		    if (!r_match) {
			match = 0;
		    }

		}		/*
				 * * of the Double Foor * loop 
				 */
	    }
	    /*
	     * * * checking to see if key's restrictions is * * subset of
	     * pid's 
	     */
	    if (match) {
		best_key_index = i;
		best_key_length = j;
	    }

	}			/*
				 * * of if (j > max_key_length 
				 */
    }				/*
				 * of the for loop going from
				 * sj_rulebase[2] to the end 
				 */

    return best_key_index;
}

/* Return 0 or an integer for the override, -1 if there is no override */
inline int check_override(char argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE])
{

  int override_i;
  int argv_i;

  /* If we can find an override rule, then we will return the
     index associated with it, otherwise we will return 1.

     Override rules allow us to override the "ALL" statement
     that may be assigned to a process. If that process runs
     an application that may be dangerous and expressly needs 
     to be associated with a restriction, then an override rule
     should be created. If we match the command line to
     a rule in the override rule_base then we override. We
     only test argv[0] to determine match or no match.
   */

   for ( override_i = 0; sj_override[override_i].key[0] != '\0'; 
	override_i++ )
         {    int size;

              if (sj_strlen(argv[0],BUFFSIZE) != 
		sj_strlen(sj_override[override_i].key,
		BUFFSIZE))
			continue;  
                      
              if (!sj_strncmp(argv[0],sj_override[override_i].key,
		BUFFSIZE))
                         { 
				  return sj_override[override_i].rule_index;
                         }
                 }

   return -1;
}
               
