#ifdef __SMP__
#include <asm/spinlock.h>
#endif
#define SJ_PRIV_HASH 10
#define SJ_MEMORY_HASH 10
/* DOH! MAX_KEY_ELEMENTS must Equil MAX_RESTRICTIOS_ELEMENTS */
#define MAX_KEY_ELEMENTS 6
#define MAX_RESTRICTIONS_ELEMENTS 6
#define MAX_RESTRICTIONS 256
#define BUFFSIZE 256
#define NULL_ARGV { "","","","","","","" };
#include <linux/version.h>

#define VERSION "StJude_LKM 0.11"

/* We should verify we can run on this kernel... */

#if (!(((LINUX_VERSION_CODE > KERNEL_VERSION(2,2,0)) &&\
     LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)) ||\
    ((LINUX_VERSION_CODE > KERNEL_VERSION(2,4,0)) &&\
     LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))))
#error "Unable to Handle kernel versions outside the 2.2 and 2.4 serise"
#endif


#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,2,11)) 
#error "Unable to Handle kernel versions lower then the 2.2.11"
#endif

#if (LINUX_VERSION_CODE > KERNEL_VERSION(2,4,2)) 
#warning "Saint Jude Has not Been Tested to Work on this kernel. Proceed with Caution."
#endif

/* Verified.. */

struct sj_priv
{
  int pid;
  struct sj_rulebase *restriction;
  struct sj_priv *next;
  struct sj_priv *prev;
};

struct sj_argv_memory
{
  int pid;
  char argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE];
  struct sj_argv_memory *next;
};


struct sj_rulebase
{
  int r_index;
  char *key[MAX_KEY_ELEMENTS+1];
  char *restrictions[MAX_RESTRICTIONS][MAX_RESTRICTIONS_ELEMENTS+1];
};


struct sj_override
{
  char key[BUFFSIZE];
  int  rule_index;
};

#ifdef __SMP__
rwlock_t argv_memory_lock;
rwlock_t priv_lock;
rwlock_t sj_running;
extern rwlock_t tasklist_lock;
#endif

typedef struct sj_rulebase SJ_RULEBASE;
typedef struct sj_priv SJ_PRIV;
typedef struct sj_argv_memory SJ_MEMORY;
typedef struct sj_override SJ_OVERRIDE;

extern void *sys_call_table[];

asmlinkage unsigned long (*orig_create_module) (const char *name,
						size_t size);
int (*orig_delete_module) (const char *name);
int (*orig_fork) (struct pt_regs regs);
int (*orig_exit) (int error);
int (*orig_vfork) (struct pt_regs regs);
int (*orig_clone) (struct pt_regs regs);
int (*orig_setuid) (uid_t uid);
int (*orig_setreuid) (uid_t ruid, uid_t euid);

int (*orig_do_execve) (struct pt_regs regs);


void suid_hack (struct task_struct *p);

struct sj_priv *create_priv_record (pid_t pid, int restriction_index);
int destroy_priv_record (pid_t pid);
struct sj_priv *get_priv_record (pid_t pid);
int check_priv_record (pid_t pid, char argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE]);
int check_restriction (char
		       argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE],
		       char
		       *restrictions[MAX_RESTRICTIONS]
		       [MAX_RESTRICTIONS_ELEMENTS+1]);
int get_restriction_index (pid_t pid,
			   char argv[MAX_KEY_ELEMENTS + 1][BUFFSIZE]);


struct sj_argv_memory *create_argv_memory (pid_t pid,
					   char argv[MAX_KEY_ELEMENTS +
						     1][BUFFSIZE]);
inline int destroy_argv_memory (pid_t pid);
inline struct sj_argv_memory *get_argv_memory (pid_t pid);

inline int sj_strncmp (char *s1, char *s2, int max_len);
char *sj_substr (char *s, int start, int end);
inline int sj_strlen (char *s1, int max_len);
int count (char **argv, int max);
int sj_fork (struct pt_regs regs);
int sj_vfork (struct pt_regs regs);
int sj_clone (struct pt_regs regs);
int sj_do_execve (struct pt_regs regs);
int sj_landmine (char *filename, char **argv, char **envp, struct pt_regs * regs);
int sj_delete_module (const char *name);
int sj_exit (int error);
int sj_setreuid (uid_t ruid, uid_t euid);
int sj_setuid (uid_t uid);
asmlinkage unsigned long sj_create_module (const char *name,
	size_t size);

/* Prototype for the Responce Functions */
int sj_do_response (char *filename, char **argv, char **envp);
int sj_do_landmine_response (char *filename, char **argv, char **envp);


