#!/usr/bin/perl

#
# Saint Jude Learning Output Parser 1.0 -- The first Cut.
#
#

## GLOBALS

my $VERSION = "1.1 -- Ouch!";
my %seen_runs;	# To record what we've seen..
	        # memory is cheep..

my @res_list;   # The restriction lists..
my %parent_xref;
my %child_xref;
my $Rules_Out = "StJude_Rulebase__WORK.h";
my $VERBOSE;
my @temp; # Tired of fscking with push 

$| = 1;

sub parse_learning_line($)
{
  my $line = shift;
  my %record;

  $line =~ s/\\/\\\\/g; # Double our Escapes..  
  $line =~ s/([\"\{\}])/\\1/g;  # We need to escape our quotes...

  $line =~ s+[^\]]\s*$+\]+g;

  $line =~ m/\[(.*?)\] executed \[(.*?)\]/;

  $record{parent} = $1;
  $record{child} =  $2;
  $record{key} = $1 . "++" . $2;

  return %record;
}


sub add_to_restrictions(%) {
#
#  In order to manage and create our restriction array the following
#  steps are necessary:
#
#  1. Create/Update the Cross Refrence hashes for this record.
#  2. Create this Record
#  3. Propigate the child in this record to all those records
#     that list our parent as a child. This is because for
#     those parents, this child will be an indirect child
#     process.
#
   my %record = @_; 
   my $i;
   my $res_index;
   my @child_xref_list;

   verbose_output("Entering ADD_TO_RES\n\n");
#
#  Step 1.
#
   if (defined $parent_xref{$record{parent}})
	{
           $res_index = $parent_xref{$record{parent}};
	}
   else
	{
	   $res_index = $#res_list + 1;
	   $parent_xref{$record{parent}} = $res_index;
        }


    if ( defined $child_xref{$record{child}} )
        {
          @child_xref_list = @{$child_xref{$record{child}}};
        }

    push @child_xref_list,($res_index);

    

# Step 2. 
   
	    if (!defined $res_list[$res_index]{parent})
             {
               $res_list[$res_index]{parent} = $record{parent} ;
             }

    # It is expected that unique parent+child combinations are verified
    # prior to the call of this function. Hence, the below line is valid
    # and would not result in the case where multiple children of the same
    # value are associated with the parent. If this assumption must change
    # then additional checking will be necessary here.


    if ( defined $res_list[$res_index]{child} )
	   { 
		@temp = @{$res_list[$res_index]{child}};
                         foreach $item (@temp)
				{
				  verbose_output("CHECK ITEM: $item\n");
				}

	   }
    else
	   {
	        undef @temp;
	   }

    push @temp, $record{child}; 

    @{$res_list[$res_index]{child}} = @temp;

#Where ever this parent is mentioned as a child, we need to
#add this new child on -- establishing the chaining of events.

    my @parent_asa_child_list = @{$child_xref{$record{parent}}};

    foreach $parental_instance (@parent_asa_child_list)
    {
        # 1. Add the child to the res_index.

          if ( defined $res_list[$parental_instance]{child} )
	      { 
	 	 @temp = @{$res_list[$parental_instance]{child}};
                 foreach $item (@temp)
			{
                          # To prevent dupes from creeping in.. They
                          # wont necessairly harm the Implementation, but
                          # it will consume unnecessary space.. and could
                          # slow processing.
                          if ( $item eq $record{child} )
                                   { goto NEXT_CHILD; }
			}

	       }
           else
	       {
	          undef @temp;
	       }

           push @temp, $record{child}; 

           @{$res_list[$parental_instance]{child}} = @temp;


        # 2. Add the index to the @child_xref_list

           push @child_xref_list, $parental_instance;
NEXT_CHILD: 
    }



# The End. We return nothing of usefullness, but lets
# return a integer value indicating success. No real
# meaning at this time.

       @{$child_xref{$record{child}}} = @child_xref_list;
  
	return 1;
}


sub write_out_rules()
{

  my $rulebase_output;
  my $sj_index;
  my %record;
# Simply go through the restrictions list and generate a
# restictions list structure for the StJude C module.
#


# *********************** SUDO NOTE *****************************
#   Optionaly, if you use sudo, you will need to add the following
#   line to the end of the rulebase output below.
#
#         { 3, {"/usr/bin/sudo", NULL} , {{"ALL", NULL}, {NULL}}},
#
#   Also, see the comment just above the sj_index assignment below.
#
#  ****************************************************************/

   $rulebase_output .= <<EOL_RO;
SJ_RULEBASE sj_rulebase[] = { 
	{ 0, {NULL}, {{"NONE", NULL}, {NULL}}},
	{ 1, {NULL}, {{\"ALL\", NULL}, {NULL}}},
	{ 2, {\"/bin/su\", NULL}, {{\"ALL\", NULL}, {NULL}}},
EOL_RO

#    /* ******************* SUDO NOTE ***********************************
#      
#        If you add sudo to the above block, increment this varable by one. 
#       
#       ******************************************************************/

    $sj_index = 3;
    my $record_index;

    foreach $record_index (0 .. $#res_list)
	{
	   my @parts;
           my $part;
           my $child;
           my $child_index;


           my %record = %{$res_list[$record_index]};

           $rulebase_output .= "\t{ $sj_index, { ";
           $sj_index += 1;
           @parts = split(/::/,$record{parent});
           foreach $part (@parts)
		{
		  $rulebase_output .= "\"$part\", " 
		}
            $rulebase_output .= " NULL }, \n\t\t{\n\t\t\t";

            my @child_list = @{$record{child}};
            if ( $#child_list eq -1 )
                { $rulebase_output .= " \"NONE\", "; }
            else
             {
                foreach $child_index (0 .. $#child_list)
	    	{
		  my @child_parts;
		  my $child_part;

                  $child = $child_list[$child_index];

		  $rulebase_output .= "{ ";
		  @child_parts = split(/::/,$child);
		  foreach $child_part (@child_parts)
			{
			  $rulebase_output .= " \"$child_part\", ";
                        }
		
                  $rulebase_output .= " NULL }, \n\t\t\t";

		}
             }            
	    $rulebase_output .= "{ NULL }\n\t\t}\n\t},\n";

	}

    $rulebase_output .= "\t{ $sj_index, {NULL}, {NULL} } \n};\n";

    $rulebase_output =~ s/\\\"\,/\\\\\"\,/g;
    print RULES_OUT "$rulebase_output";
    print RULES_OUT "" . <<EOF;




/*

  BELOW THIS POINT COPY THE Original StJude_Rulebase.h file's OVERRIDE
  Structure, modifying the second element of each structure to point
  to the appropriate rule above. 

  Ie, If there were a rule above for named:

  { 4, {"/usr/bin/named", "-u", "bubba", NULL},
            { {"/usr/bin/named-xfer", NULL } }

  and in the override table we refrence named via:

  { "/usr/bin/named", 0 }

  we would change that line to read:

  { "/usr/bin/named", 4 }

  Notice, the only change was the number indicating the rule. This
  is the lead-in to the chain of rules for named.

  After doing this, save this file as StJude_Rulebase.h in the Saint
  Jude source directory, Modify the Make file to comment out the -DLEARNING
  line, and copy the newly built module over the last module.

  ***************************************************************************
  **************************** WARNING **************************************
  ***************************************************************************
  *                                                                         *
  * By Default, trained modules will lock the kernel. If you are not        *
  * running a monolithic kernel, you should use the -DNOSEAL option         *
  * in the Makefile. This will reduce the protection StJude may offer       *
  * significantly.                                                          *
  *                                                                         *
  * It is Strongly Recommended that you use Saint Jude with a Monolithic    *
  * kernel, but have module support and disable the kernel module           *
  * autoloader.                                                             *
  ***************************************************************************
  ***************************************************************************


 */

 
EOF

print "\n\n\nRules saved to file $Rules_Out.\nRead the Comment at the End of the File for Instructions on how to proceed.\n\n\n";


my $Rules_Out = "StJude_lkm_rules.h";

} 
## MAIN 


sub verbose_output($)
{
   ($verbose_output) = @_;

   if (defined $VERBOSE) {
	print $verbose_output . "\n";
   }

}

print("The Saint Jude Learning Parser, $VERSION\n");

if (!defined $ARGV[0]) {
     BAD_COMMAND_LINE:
     print ("Syntax: $0 " . "[-o <output filename>] <filename>\n\n");
     print ("<filename> should be the file where the StJude Learning output is stored.\n"); 
     print ("    -o     output file name, default is $Rules_Out\n\n");
     exit(0);
   } else {
   

     ARGV_LOOP: {
     	  my $arg;

          $arg = shift(@ARGV);

     ARGV_SWITCH: {
        if ( !defined $arg ) { goto BAD_COMMAND_LINE; }
        if ( $arg =~ m/^-v$/ ) { $VERBOSE = 1 ; goto ARGV_LOOP; }
        if ($arg =~ m/^-o$/) { $Rules_Out = shift(@ARGV) ; goto ARGV_LOOP; }
        if ($arg =~ m/^-o(\w+)/) { $Rules_Out = $1 ; goto ARGV_SWITCH; }
        if ($arg =~ m/^-/) { goto BAD_COMMAND_LINE; }
        $Learning_File = $arg; last ARGV_LOOP;

        }
          next ARGV_LOOP;

       }

   }

   if (!defined $Learning_File)
           { goto BAD_COMMAND_LINE; }

   open(LEARNING_FILE,"< $Learning_File") || 
		die "StJude Learning file, $Learning_File, could not be opened.\n";
                
   if ( -x $Rule_Out )
         { 
            die "ABORTING: Output File, $Rule_Out, exists.\nOverwrite not permitted in order to prevent accidental damage to existing Rulebase files.";
         }

   open(RULES_OUT,"> $Rules_Out") || 
		die "StJude output File, $Rules_Out, could not be opened.\n";

   print "Building Rulebase ";
   while ($Learning_Line = <LEARNING_FILE>)
   {
      chop($Learning_Line);

      if ( $Learning_Line =~ m/\(STJUDE\) LEARN:/ ) { 
         
          $Learning_Line =~ m/\(STJUDE\) LEARN: (.*)$/;
          my %learning_record = parse_learning_line($1); 

          
          if (defined $seen_runs{$learning_record{key}})
		{ 
		  goto NEXT_LEARNING_LINE; 
	         }
          verbose_output($1);
          add_to_restrictions(%learning_record);
          $seen_runs{$learning_record{key}} = 1;
          
      }
      
NEXT_LEARNING_LINE:    
   }
   print "\n" ;
# now output the lines....
   write_out_rules();

# END

