/* API for interfacing with the Virtual Server administrator.
   Copyright (c) 1999, 2000 Idaya Ltd.
   Contributed by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef VSD_LIB_H
#define VSD_LIB_H

#ifdef __cplusplus
extern "C" {
#endif

/* These functions are used by vsdadm.c and all modules.  */

extern int vsd_reply_success (void *io_);
extern char *vsd_process_reply (void *io_);
extern char *vsd_raw_reply (void *io_);
extern int vsd_send_line (void *io_, const char *fmt, ...);
extern char *vsd_read_file (void *io_, const char *filename);
extern int vsd_send_command (void *io_, const char *data,
			     const char *fmt, ...);
extern int vsd_send_vcommand (void *io_, const char *data,
			     const char *cmd, int argc, char *argv[]);
extern int vsd_send_command_file (void *io_, const char *fname,
				  const char *fmt, ...);
extern void vsd_set_level (void *io_, int level);

#ifdef __cplusplus
}
#endif

#endif
