/* Module interface header.
   Copyright (c) 1999, 2000 Idaya Ltd.

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef MODULE_H
#define MODULE_H

#ifndef VSD_H
#include "vsd.h"
#endif

/* Values for `level' parameter. These are used to differentiate between
   commands for the virtual server admin user (vsclients and webclients)
   and the system administrator of the host server (webadmclients).  */
#define ADMIN_VS 1
#define ADMIN_HOST 2

struct command_tag
{
  int token;  /* Internally used token.  */
  int level;  /* Access level, whether for a virtual server or <root> vs.  */
  const char *help;  /* Help text describing command.  */
  const char *vsd_tag;  /* Command name used in VSD protocol.  */
  int vsd_args;  /* Number of arguments in VSD protocol for `vsd_tag'.  */
  const char *vsd_syntax;  /* Syntax for `vsd_tag' in VSD protocol.  */
  const char *vsdadm_tag;  /* Command name used by vsdadm client prog.  */
  int vsdadm_args;  /* No. of arguments required in vsdadm client prog.  */
  const char *vsdadm_syntax;  /* Command line syntax for vsdadm.  */
};

typedef int (*check_func)(int level, const char *cmd,
			   int argc, char *argv[],
			   struct command_tag **list);
typedef int (*help_func)(int level, const char *command);

extern struct command_tag *module_lookup_command (struct command_tag *table,
						  int level,
						  const char *command);

extern void module_help (int level, const char *command);
extern int module_check_cmd (int level, const char *cmd,
			     int argc, char *argv[],
			     struct command_tag **list);

#ifndef VSD_LIB
/* Interface for the server process.  */
typedef int (*transaction_func)(struct connection *vs, int level,
				const char *command, int argc, char *argv[],
				const char *data);

typedef struct module
{
  check_func check_cmd_function;
  transaction_func transaction_function;
} module;

extern int module_transaction (struct connection *vs, int level,
			       const char *command, int argc, char *argv[],
			       const char *data);
#endif

#ifdef VSD_LIB
#include "vsd_lib.h"
/* Interface for the client library (vsd_lib).  */
typedef char *(*command_func)(void *io_, int level,
			      const char *cmd, int argc, char **argv);

typedef struct module
{
  check_func check_cmd_function;
  command_func command_function;
} module;

extern char *module_command (void *io_, int level, const char *cmd,
			     int argc, char **argv);

#endif

extern module *static_modules[];

#endif
