/* Virtual server daemon I/O abstraction.
   Copyright (c) 2000 Idaya Ltd.
   Contributed by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef IO_H
#define IO_H

#ifdef HAVE_OPENSSL
#define NO_IDEA
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#endif

struct io_requests
{
  char *vs; /* Virtual server */
  struct req_command
  {
    char **argv; /* Command and arguments for command.  */
    size_t argc; /* Number of arguments.  */
    char *data; /* Buffer for extra data that a command may pass in.  */
  } *actionv;
  size_t actionc;
};

struct io_results
{
  char *vs; /* Virtual server.  */
  struct res_command
  {
    char *cmd; /* Command name.  */
    char *data; /* Result data for command.  */
  } *cmdv;
  size_t cmdc;
};

struct io
{
  /* Buffers for socket i/o.  */

  /* Input buffer. Incoming data is placed in here.  */
  char *input_buffer;
  /* Size of the input buffer.  */
  int input_bufsiz;

  /* Output from VSD can be changed to different formats.  */
  int io_output_format;

  /* Incoming requests are parsed and stored within this data structure.  */
  struct io_requests *requests;
  int requests_count;

  /* Outgoing results are stored within this data structure.  */
  struct io_results *results;
  int results_count;

  /* Pointer to a memory chunk used as a collection point for data to be
     output.  */
  char *io_buffer;
  /* Pointer to the current position within this buffer (moves as data
     is added).  */
  char *io_bufferp;
  /* Size of the buffer.  */
  int io_buffer_size;

  /* Socket i/o primitives.  */

  /* File descriptions for input and output respectively.  */
  int in_fd, out_fd;
#ifdef HAVE_OPENSSL
  /* OpenSSL contexts.  */
  SSL_CTX *ctx;
  SSL *ssl;

  /* In an SSL connection, the client certificate will contain the
     name of the virtual server in the CN field.  We hold the name
     in this variable and then compare later to ensure that operations
     are only done on this virtual server.  */
  char *certificate_vs;
#endif
};

#endif /* IO_H */
