/* Utility functions for the virtual server daemon.
   Copyright (c) 1999 Idaya Ltd.
   Contributed by Nick Burrett <nick@dsvr.net>

   This file is part of the Virtual Server Administrator (FreeVSD)

   FreeVSD is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   FreeVSD is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FreeVSD; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>

#include "libvsd.h"

/* Return the virtual server name.
   This function must be called by a client running in a chrooted
   environment on the virtual server.

   Return 0 upon successful completion, -1 on error.  */
int vsd_getvirtualservername (char *buffer, int size)
{
  int fd;

  if (buffer == NULL)
    {
      errno = EINVAL;
      return -1;
    }

  fd = open ("/etc/FQDN", O_RDONLY);
  if (fd != -1)
    {
      char fqdn[256], *ptr;
      int bytes;

      bytes = read (fd, fqdn, sizeof (fqdn));
      close (fd);
      if (bytes >= 0)
	{
	  /* Terminate the string.  */
	  fqdn[bytes - 1] = '\0';

	  /* Search backwards for the first space or tab.  */
	  for (ptr = fqdn + bytes - 2;
	       *ptr != ' ' && *ptr != '\t' && *ptr != '\0' && ptr != fqdn;
	       ptr--)
	    ;

	  /* Skip past space.  */
	  if (ptr != fqdn)
	    ptr++;

	  bytes = (fqdn + bytes - 1) - ptr;
	  if (bytes > size)
	    {
	      errno = ENAMETOOLONG;
	      return -1;
	    }

	  memcpy (buffer, ptr, bytes);
	  buffer[bytes] = '\0';
	  return 0;
	}

      return -1;
    }

  return -1;
}
