#!/usr/bin/perl
# Script for creating a skel that contains the infrastructure
# for all virtual servers (RedHat GNU/Linux version).
# Copyright (c) 1999, 2000 Idaya Ltd.
#
# This file is part of the Virtual Server Administrator (FreeVSD)
#
# FreeVSD is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# FreeVSD is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with FreeVSD; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

# command syntax:
#   vsd-genskel.pl <mnt point>
#
#   mntpoint - mount point of the disk to contain virtual servers
#
# FIXME: We could probably change this so that the script built the
# skel for all partitions without any manual intervention.
use Sys::Hostname;
use IO::File;
use File::Copy;
use File::Find;
use lib qw(@vsdperllib@);
use VSD;

sub skelcopy {
    my ($temp, $temp1, $mode);
    $temp = $File::Find::name;
    $mode = ((stat ("$temp"))[2]) & 07777;
    ($temp1 = $temp) =~ s/$skelsrc\///;
    if (-d $temp && $temp !~ /CVS/) {
        mkdir ("$skelroot/$temp1", 0755);
    } elsif ($temp !~ /CVS/) {
	`cp -a $temp $skelroot/$temp1`;
	chown 0, 0, "$skelroot/$temp1";
	chmod $mode, "$skelroot/$temp1";
    }
}

if (@ARGV == 0) {
    ($vsconf, $aliasip) = vsd_map_read ("@vsdconf@", $vs);
    $mntpoint = $vsconf->{"Partition"};
}
else {
    $mntpoint = $ARGV[0];
}

if (!-d "$mntpoint") { 
    `/bin/mkdir $mntpoint`;
}

$skelroot = $mntpoint."/skel";
do "@freevsdconf@";

# Create the skel repository.  Copy lots of files from the server
# system disk.
print "-- creating skel, $skelroot\n";
if (-d "$skelroot") {
    print "-- deleting old skel, $skelroot\n";
    `rm -rf $skelroot`;
}
mkdir ("$skelroot", 0755);

# Create top-level directory structure
foreach $dir ("bin", "dev", "etc", "home", "lib", "proc", "tmp",
	      "usr", "sbin") {
    mkdir ("$skelroot/$dir", 0755);
}

print "-- merging /bin programs\n";
foreach $file (@bin_progs) {
    `cp -a /bin/$file $skelroot/bin/$file`;
}

print "-- merging /sbin programs\n";
foreach $file (@sbin_progs) {
    `cp -a /sbin/$file $skelroot/sbin/$file`;
}

print "-- merging /lib\n";
`cp -a /lib $skelroot/`;

print "-- merging /usr\n";
`cp -a /usr $skelroot/`;
`rm -r -f $skelroot/usr/local`;

print "-- merging /usr/sbin programs\n";
`rm -r -f $skelroot/usr/sbin`;
mkdir ("$skelroot/usr/sbin", 0755);
foreach $file (@usr_sbin_progs) {
    `cp -a /usr/sbin/$file $skelroot/usr/sbin/$file`;
}
# FIXME BAD HACK. Do this somewhere else.
`chmod 04755 $skelroot/usr/sbin/atd`;
`chmod 04755 $skelroot/usr/sbin/crond`;
if (-l "$skelroot/usr/info/dir") {
  unlink ("$skelroot/usr/info/dir");
  `cp /etc/info-dir $skelroot/usr/info/dir`;
}

print "-- merging /usr/libexec programs\n";
`rm -r -f $skelroot/usr/libexec`;
mkdir ("$skelroot/usr/libexec", 0755);
foreach $file (@usr_libexec_progs) {
    `cp -a /usr/libexec/$file $skelroot/usr/libexec/$file`;
}

print "-- merging skel repositories\n";
if (! defined ($os_skelrepo)) {
  die "/etc/freevsd.conf requires a os_skelrepo definition";
}
if (-d "$os_skelrepo") {
    $skelsrc = $os_skelrepo;
    find \&skelcopy, $os_skelrepo;
} else {
    die "$os_skelrepo does not exist";
}

# If --enable-addons was set in the FreeVSD build then
# we will install all the RPMs from the specified directory
# into the skel.
if (defined ($add_ons)) {
    print "-- installing third party rpms\n";
    die "add_ons gives a non-directory" if (! -d "$add_ons");
    @rpms = glob ("$add_ons/*.rpm");
    # Create temporary var directory for rpm to do its business
    mkdir ("$skelroot/var", 0755);
    mkdir ("$skelroot/var/lib", 0755);
    mkdir ("$skelroot/var/tmp", 0755);
    `cp -a /var/lib/rpm $skelroot/var/lib`;
    system ("rpm","-ivh", "--force", "--root=$skelroot", @rpms); 
    # Clean up.
    `rm -rf $skelroot/var`;
}

print "-- deleting extra files\n";
foreach $file (@delete_progs) {
    system ("rm -r -f $skelroot/$file");
}

# Do site specific skel installation
if (defined ($site_skel_install)) {
  if (-x "$site_skel_install") {
      do "$site_skel_install";
  }
}
