/*
 * lethe encoding
 *
 *   programmed by fred_ | blasphemy
 *
 *   <email: cornoil@netscape.net>
 *
 *   Copyright (C) 1999 - 2000. All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>

/* base characters */
char base[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789,.-+!@#$%^&*()_ ][|'\"?`~";

/* encoded characters */
char code[] = \
   { 115, 116, 117, 118, 37, 94, 38, 42, 40, 41,
     119, 120, 121, 122, 48, 49, 50, 51, 83, 84,
     85, 86, 87, 88, 89, 90, 106, 107, 108, 109,
     110, 111, 112, 113, 114, 52, 53, 54, 55, 56,
     57, 74, 75, 76, 77, 78, 79, 80, 81, 82, 44,
     46, 45, 43, 33, 64, 35, 36, 97, 98, 99, 100,
     101, 102, 103, 95, 32, 93, 91, 124, 39, 34, 63,
     96, 126, 104, 105, 65, 66, 67, 68, 69, 70,
     71, 72, 73 };

/* identifiers for random encoding numbers */
char ident[] = { 0, 71, 72, 73, 74, 75, 76,
                77, 78, 79, 80, 81, 82, 83 };

/* exit/return values */
#define	SUCCESS	0
#define	FAILER	1

/* maximum buffer size (bytes) */
#define	MAXSIZE	256

int
main(argc, argv)
	int argc;
	char *argv[];
{
   int code_option = 0;
   int x = 0, i = 0, r = 0, c = 0, a = 0, d = 0;
   char *buffer = (char *) malloc(MAXSIZE);

	/* check arguments */
	if (argc != 3) {
		printf("programmed by fred_ | blasphemy\n");
           	printf("usage: %s -[e or d] [text]\n", argv[0]);
		exit(FAILER);	/* exit on error */
	  }

	while (1) {
		/* parse command line arguments */
		i = getopt(argc, argv, "ed");
		if (i == -1)
			break;
		switch(i) {
			case 'e': /* encode */
				code_option = 1;
				break;
			case 'd': /* decode */
				code_option = 2;
				break;
			default: /* default (encode) */
				code_option = 1;
				break;
		  }
	  }

	/* if option 'e' (encode) is selected */
	if (code_option == 1) {
		for (x = 0; x < strlen(argv[2]); x++) {
			/* get random encoding number */
			srand(time(NULL));
			r = 1 + (int)(13.0*rand()/(RAND_MAX+1.0));
			/* find the encoded character we want to use */
                   	for (i = 0; i < strlen(base); i++) {
                           	if (base[i] == argv[2][x])
					/* print encoded character */
                                   	printf("%c%c", ident[r], code[i]+r);
			  }
		  }
	}
	  else {	/* decode (guessing 'd' was selected) */
		c = 1;
         	for (x = 0; x < strlen(argv[2]); x++) {
			if (c == 1) {
				/* find the random decoding number */
                           	for (a = 0; a < 13; a++) {
                                   	if (ident[a] == argv[2][x])
						d = a;
				  }
			  } else {
				/* find the base character we want to use */
                   		for (i = 0; i < strlen(code); i++) {
					if (code[i]+d == argv[2][x])
						/* print decoded character */
						printf("%c", base[i]);
				  }
			}
			/* change character position identifier */
			if (c == 1)
				c = 2;
			  else
				c = 1;
		  }
	  }
   putchar('\n');

   /* return success */
   return(SUCCESS);
}
