#!/usr/bin/perl
# Filter to fix the Jargon file, which since 4.1.0 has come out of ESR's
# scripts in a form which doesn't work with the vh browser.
#
# Copyright (C) 1999,2001 Paul Martin <pm@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use strict;

# Right margin, 75 columns
my $margin = 75;

# $para is the cumulative text of a paragraph.
my $para='';
my $manglemode=0;
my $verbatim=0;

# Flow a paragraph, split into words, then fill each line as close
# to margin as possible.
# This isn't optimal, but it does work.
sub endpara {
 my @words=split ' ', $para;
 my $pos=1;
 if ($manglemode && !(($para =~ /^:/) && ($para =~ / /))) {
  print "   ";
  $pos=4;
 # indent the first line only if it's not the start of an entry
 }
 for (@words) {
  if (($pos+length())<$margin) {
   print "$_ ";
   $pos+=length()+1;
  } else {
   if ($manglemode) {
    # indent subsequent lines
    print "\n   $_ ";
    $pos=length()+3;
   } else {   
    print "\n$_ ";
    $pos=length();
   }
  }
 }
 if ($para =~ / /) { print "\n"; }
 # if the para has only one word, it's not a paragraph (eg. ascii entry)
 print "\n";
 $para='';
}

# Main loop

# The problem that this program tries to fix is that ESR's scripts indent
# all paragraphs, even those of lexicon entries, and in those, the text
# has been reflowed badly, leading to sequences of three spaces within
# paragraphs.

while (<>) {
 chomp;
 while (s/^(\t*)\t/$1        /) {}; # initial tabs,
 if (/^   :/) { # it's the start of an entry
   $manglemode=1;
 } elsif (/^[=:]../) { # don't touch the section markers
  $manglemode=0;
  if (/[:=]$/) {
   $verbatim=1;
  }
 }
 if ($verbatim) {
  print "$_\n";
  $verbatim = 0 if /^$/;
 } elsif ($manglemode) {
  if (/^ [ 1-9][ 0-9][ *.]/) {
   if (/^   \*/) { s/(.)   /$1/g; }
   if ($para ne '') {&endpara;} # spit out the paragraph we've accumulated
   print "$_\n"; # already indented, don't touch
  } elsif (/^$/) {
   &endpara; # blank line, spit out accumulated paragraph
  } else {
   s/   //g; # strip out those triple space sequences
   $para.= (($para eq '') ? '' : ' ').$_; # append to paragraph
  }
 } else {
  if (/^ [ 1-9][ 0-9][ *.]/) {
   if (/^   \*/) { s/(.)   /$1/g; }
   if ($para ne '') {&endpara;} # spit out the paragraph we've accumulated
   print "$_\n"; # already indented, don't touch
  } elsif (/^$/) {
   &endpara;
  } else {
   s/^   (\S)/$1/g; # strip out those triple space sequences
   $para.= (($para eq '') ? '' : ' ').$_; # append to paragraph
  }
 }
}

# That's all folks
