/***********************************************************
slurp.c: serves slurpie.c through generated and pre-made
dictionary comparison cracking.
   Copyright (C) 1999. HaPpY (katami@hotmail.com).
   This source code is protected under the GPL. Read the
   README file for details.
***********************************************************/

/////////////////////////////
#include "node.h"
#include "shared.h"
#ifdef linux
#include <unistd.h>
#define _XOPEN_SOURCE
#endif


/////////////////////////////
const u_char *CL_HELP_MENU =
   "%s\n"	// title
   "syntax: node <options> <port number>\n"
   "\noptions:\n"
   "-h                  display this help screen\n"
   "-v                  turn verbose mode on\n\n";


/////////////////////////////
typedef struct
{
   u_int cl,
      mcl,			// master's command line
      mcl_gdict,
      mcl_gd_cset_size;
   u_int gtask_level, ptask_level;
} Config;

typedef struct
{
   FILE *dictfile;
   float ptask_size;
   char cset[256];
   u_int cset_size;
} WorkLoad;


/////////////////////////////
static Config cfg;
static WorkLoad wl;


/////////////////////////////
void print( const u_char *str, ... );


///////////////////////////// message_handler
char *do_pdict( u_char *master_msg, u_char *sendbuf, u_int *send_len )
{
   u_char testpwd[MAX_STR_LEN],
      encpwd[MAX_STR_LEN],
      user[MAX_STR_LEN],
      salt[3],
      *pstr = master_msg;

   u_int file_loc = *(pstr++) * wl.ptask_size;	// determine range
   u_int end_loc = file_loc + wl.ptask_size;
   pstr += strcpy_len(user,pstr);
   strcpy_len(encpwd,pstr);

   salt[0] = encpwd[0];
   salt[1] = encpwd[1];
   salt[2] = '\0';
   fseek(wl.dictfile,file_loc,SEEK_SET);
   while( ftell(wl.dictfile) && fgetc(wl.dictfile)!='\n' )
      fseek(wl.dictfile,-2,SEEK_CUR);
   while( !feof(wl.dictfile) && ftell(wl.dictfile) <= end_loc )
   {
      fscanf( wl.dictfile, "%s\n", testpwd );
      if( !strcmp((u_char*)crypt(testpwd,salt),encpwd) )
      {
         pstr = sendbuf;
         *(pstr++) = MSG_SUCCESS;
         pstr += strcpy_len(pstr,user);
         pstr += strcpy_len(pstr,testpwd);
         *send_len = pstr-sendbuf;

         return sendbuf;
      }
   }
   sendbuf[0] = MSG_DO_PDICT;
   *send_len = 1;

   return sendbuf;
}

///////
void gen_charset( void )
{
   u_int i, j=0;

   if( cfg.mcl_gdict & CL_GDICT_LCASE )
      for( i='a'; i<='z'; i++, j++ )
         wl.cset[j]=(char)i;
   if( cfg.mcl_gdict & CL_GDICT_UCASE )
      for(i='A'; i<='Z'; i++, j++ )
         wl.cset[j]=(char)i;
   if( cfg.mcl_gdict & CL_GDICT_DIGITS )
      for(i='0'; i<='9'; i++, j++ )
         wl.cset[j]=(char)i;
   if( cfg.mcl_gdict & CL_GDICT_PUNCTUATION )
   {
      for( i=32; i<=47; i++, j++ )
         wl.cset[j]=(char)i;
      for( i=58; i<=64; i++, j++ )
         wl.cset[j]=(char)i;
      for( i=91; i<=96; i++, j++ )
         wl.cset[j]=(char)i;
      for( i=123; i<=126; i++, j++ )
         wl.cset[j]=(char)i;
   }
   if( cfg.mcl_gdict & CL_GDICT_EXTENDED )
   {
      for( i=1; i<=31; i++, j++ )
         wl.cset[j]=(char)i;
      for( i=127; i<=255; i++, j++ )
         wl.cset[j]=(char)i;
   }
   wl.cset_size = j;
   wl.cset[j]=0;
}

char *do_gdict( u_char *master_msg, u_char *sendbuf, u_int *send_len )
{
   u_char state[MAX_STR_LEN],
      testpwd[MAX_STR_LEN],
      encpwd[MAX_STR_LEN],
      user[MAX_STR_LEN],
      salt[3],
      *pstr = master_msg;
   static u_int pwdlen, i, j;

   pwdlen = *(pstr++);
   memcpy(state,pstr,pwdlen);
   pstr += pwdlen;
   pstr += strcpy_len(user,pstr);
   strcpy_len(encpwd,pstr);

   salt[0] = encpwd[0];
   salt[1] = encpwd[1];
   salt[2] = '\0';

// run generated password search
   for( i=0; i<pwdlen; testpwd[i]=wl.cset[state[i++]] );
   if(pwdlen>cfg.gtask_level)
      pwdlen=cfg.gtask_level;
   for( i=0; i<pwdlen; )
   {
      if( !strcmp((u_char*)crypt(testpwd,salt),encpwd) )
      {
         pstr = sendbuf;
         *(pstr++) = MSG_SUCCESS;
         pstr += strcpy_len(pstr,user);
         pstr += strcpy_len(pstr,testpwd);
         *send_len = pstr-sendbuf;

         return sendbuf;
      }
      for( j=i=0; j<=i; j++ )
      {
         if( ++state[j]>=wl.cset_size )
         {
            state[j]=0;
            i++;
         }
         testpwd[j]=wl.cset[state[j]];
      }
   }

   sendbuf[0] = MSG_DO_GDICT;
   *send_len = 1;
   
   return sendbuf;
}

///////
int recv_init( u_char *initmsg )
{
   u_char *pstr=initmsg+1;
   
   cfg.mcl = (u_int)*(pstr++);
   if( cfg.mcl & CL_PDICT )
   {
      cfg.ptask_level = (u_char)*(pstr++);
      if( !(wl.dictfile = fopen(pstr, "r")) )
         return 0;
   // get file size and divide to determine portion of dictionary to process per task
      fseek(wl.dictfile, 0, SEEK_END );
      wl.ptask_size = wl.dictfile->_offset / cfg.ptask_level;
      pstr += strlen(pstr)+1;
   }
   if( cfg.mcl & CL_GDICT )
   {
      cfg.gtask_level = (u_char)*(pstr++);
      cfg.mcl_gdict = (u_char)*(pstr++);
      gen_charset();
   }

   return 1;
}


//////////////
u_char *msg_proc( u_char *master_msg, u_int *send_len )
{
   static u_char sendbuf[MAX_PACKET_SIZE];

   switch(master_msg[0])
   {
   case MSG_INIT:
      if(!recv_init( master_msg ))
         return 0;
      sendbuf[0] = MSG_INIT;	// echo init tag to confirm success
      *send_len = 1;
      return sendbuf;
   case MSG_DO_PDICT:
      return do_pdict ( master_msg+1, sendbuf, send_len );
   case MSG_DO_GDICT:
      return do_gdict ( master_msg+1, sendbuf, send_len );
   }

   return 0;
}


///////////////////////////// commline_handler
int cl_proc( int argc, u_char **argv )
{
   static u_int i;
   cfg.cl = 0;
   
   if(argc>1)
   {
      if( !(*node_port=atoi(argv[--argc])) )
         goto jCOMM_HELP;
         
      for( i=1; i<argc; i++ )
      {
         if( argv[i][0] == '-' )
         {
            switch( argv[i][1] )
            {
               case 'v':
                  cfg.cl |= CL_VERBOSE;
                  break;
               case 'h':
               default:
                  goto jCOMM_HELP;
            }
         }
         else
            goto jCOMM_HELP;
      }
   }
   return 1;
   
jCOMM_HELP:
   printf(CL_HELP_MENU,TITLE);
   return 0;
}


///////////////////////////// exit_handler
int exit_proc( void )
{
   if( cfg.cl & CL_PDICT  )
      fclose( wl.dictfile );
   return 0;
}


///////////////////////////// print_handler
void print( const u_char *str, ... )
{
   static u_char tbuf[MAX_STR_LEN];
   va_list parg;
   
   va_start(parg, str);
   vsprintf(tbuf,str,parg);
   va_end(parg);
   if( cfg.cl & CL_VERBOSE )
      printf( tbuf );
}

