/* crank.h - shared header file
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include <gtk/gtk.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define VERSION "0.0.3"

#define MAXTEXT 1048576

/* Keys are stored as arrays, indexed by uppercase letter. 
 * The parts of the array before 'A' are ignored. 
 */
#define UPPER_KEY_BOUND ((int) ('Z' + 1))

typedef char key[UPPER_KEY_BOUND];

typedef struct {
    int remove_whitespace;
    int remove_punctuation;
    int remove_numbers;
} preprocess_options;

#define PREPRO_WHITESPACE     1
#define PREPRO_PUNCTUATION    2
#define PREPRO_NUMBERS        3

#define TOGGLE(x) (x = ((x) ? FALSE : TRUE))

typedef struct {
    float *slft;
    float *bift;
    float *trift;
    float slft_error;
    float bift_error;
    float trift_error;
    float total_error;
    int letter_count;
} stats;

#define START_TEXT "Crank v" VERSION

#define GLOBAL_TRANSFORMED_TEXT (gtk_editable_get_chars(GTK_EDITABLE(textarea), 0, -1))

#define DEFAULT_SLFT "data/slft.dat"
#define DEFAULT_BIFT "data/bift.dat"
#define DEFAULT_TRIFT "data/trift.dat"

