#ifndef _DKBF_USER_H
#define _DKBF_USER_H

#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

#define USERINFO_NBLOCKS        21
#define USERNAMESIZE            128
#define LMHASHSIZE              32
#define NTHASHSIZE              32
#define LMHASHBSIZE             16
#define NTHASHBSIZE             4
#define FOOSIZE                 4
#define BARSIZE                 4
#define LMPASSWDSIZE            14
#define NTPASSWDSIZE            128
#define LMRESP_BSIZE            24
#define NTRESP_BSIZE            24
#define FIRST_HALFSIZE          7
#define SECOND_HALFSIZE         7
#define LMDONESIZE              1
#define NTDONESIZE              1
#define PWDUMPVALSIZE           1
#define SERVER_CHALLSIZE        8
#define ALREADY_PRINTEDSIZE     1
#define UNDER7SIZE              1
#define PREVIOUSSIZE            1
#define NEXTSIZE                1

#define LMPASSWDLEN             14
#define NTPASSWDLEN             128
#define HALFHASH_SIZE           7

struct user_struct
{
  char username[128];
  char lmhash[32];
  char nthash[32];
  char lmhashb[16];
  unsigned long nthashb[4];
  char foo[4];
  char bar[4];
  char lmpasswd[14];
  char ntpasswd[128];
  char lmresp_b[24];
  char ntresp_b[24];
  char first_half[7];
  char second_half[7];
  int lmdone;
  int ntdone;
  int pwdumpval;
  char server_chall[8];
  int already_printed;
  int under7;
  struct user_struct *previous;
  struct user_struct *next;
};

/* malloc user_struct */
struct user_struct *malloc_user_struct ();

/* Commit the struct UserInfo into an MPI Datatype */
MPI_Datatype *CommitUserInfo ();


#endif
