#include "dkbfschedule.h"

int
set_slavepriority (CONFIG * Config, FILE * slavelog, int rank)
{
  int priority = 0;

  if ((Config->slavepriority >= PRIO_MIN) &&
      (Config->slavepriority <= PRIO_MAX))
    {
      priority = setpriority (PRIO_PROCESS, getpid (), Config->slavepriority);

      if (errno)
	perror ("Process Priority Setting Error");
    }

  priority = getpriority (PRIO_PROCESS, getpid ());

  logger (Config->logginglevel, 0, 1, slavelog,
	  "Slave %d running at priority level %d\n",
	  rank, Config->slavepriority);

  return 0;
}
