#include "dkbfmaster.h"

int
master (CONFIG *Config)
{
  struct user_struct   *head = NULL;	
  struct user_struct   *masterarray;
  struct user_struct   *cracked_acct;		
  struct user_struct   *temp_acct = NULL;

  int                  request;
  int                  current_node; 

  int                  size;
  int                  expired;

  FILE                 *masterlog;
  FILE                 *cracklog;
  FILE                 *pwlist;

  long                 idle_start;	

  char                 timebuffer[256];

  BLOCK                *s_block;

  STATUS               jobstatus;

  MPI_Status           msgstatus;

  BLOCKNODE            *blockq = NULL;

  MPI_Datatype         *pBlock;
  MPI_Datatype         *pUserInfo;

  MPI_Comm_size (MPI_COMM_WORLD, &size);

  /* open up log files */
  masterlog = jobfopen (Config->jobname, Config->masterlog, "w");
  cracklog = jobfopen (Config->jobname, Config->cracklog, "w");

  /* get accounts */
  if ((pwlist = fopen (Config->pwlist, "r")) == NULL)
    {
      printf ("fatal error: failed to open %s\n", Config->pwlist);
      MPI_Abort (MPI_COMM_WORLD, 1);
    }
  head = setup_linked_list (Config->pwdump, pwlist, stdout);
  fclose (pwlist);

  /* initialize every thing */ 
  s_block = malloc_block ();
  temp_acct = malloc_user_struct ();

  initialize_status (&jobstatus, Config, size);

  jobstatus.usercount = count_users (head);
  masterarray = cp_list_to_array (head, jobstatus.usercount);

  /* logging */
  log_job_configurations (Config, masterlog, &jobstatus);

  pUserInfo = CommitUserInfo ();
  pBlock    = CommitBlock ();

  /* communication loop */
  while (jobstatus.slaves)
    {
      time (&idle_start);
      MPI_Recv (&request, 1, MPI_INT, MPI_ANY_SOURCE, MPI_ANY_TAG,
		MPI_COMM_WORLD, &msgstatus);

      bench (0, idle_start, timebuffer);

      current_node = msgstatus.MPI_SOURCE;

      logger (Config->logginglevel, 3, 1, masterlog,
	      "Master received request:%d from %d\n", request, current_node);

      logger (Config->logginglevel, 3, 1, masterlog,
	      "Master has been idle for %s\n", timebuffer);

      switch (request)
	{
	case REQUEST_BLOCK:
	  /* jobstatus, current_node, masterlog, puserinfo, config
	     blockq, s_block, expired */
	  MPI_Send (&jobstatus.usercount, 1, MPI_INT, current_node,
		    MPI_MSG_TAG, MPI_COMM_WORLD);

	  if (!jobstatus.usercount)
	    {
	      logger (Config->logginglevel, 2, 1, masterlog,
		      "No accounts left - exiting\n");
	      log_job_time(&jobstatus, Config, masterlog);
	      MPI_Abort (MPI_COMM_WORLD, 0);
	    }

	  MPI_Send (masterarray, jobstatus.usercount, *pUserInfo,
		    current_node, MPI_MSG_TAG, MPI_COMM_WORLD);

	  blockq = get_next_block (Config, &jobstatus, s_block,
				   blockq, &expired);

	  /* decrement node count if expired block used */
	  //if(expired)slaves--;

	  MPI_Send (s_block, 1, *pBlock, current_node,
		    MPI_MSG_TAG, MPI_COMM_WORLD);

	  logger (Config->logginglevel, 3, 1, masterlog,
		  "SENT: NODE %d, BLOCK:" \
		  " %.0Lf, SIZE:%.0Lf\n",
		  current_node, s_block->start, s_block->size);
	  break;
	case REPORT_BLOCK:
	  /* s_block, pblock, master log, blockq, */
	  memset (s_block, '\0', sizeof (BLOCK));

	  MPI_Recv (s_block, 1, *pBlock, current_node, MPI_MSG_TAG,
		    MPI_COMM_WORLD, &msgstatus);

	  logger (Config->logginglevel, 2, 1, masterlog,
		  "GOT BLOCK:%.0Lf, NODE:%d, TIME:%d, RATE:%.2f k/s\n",
		  s_block->start, current_node, s_block->elapsed,
		  s_block->rate);

	  track_keyrate (current_node, s_block, &jobstatus, 
			 masterlog, Config);

	  blockq = remove_blocknode (s_block->start, blockq);
	  break;
	case REPORT_ACCOUNT:
	  /* temp_acct, puserinfo, current_node, cracked_acct,
	     head, cracklog, jobstatus, masterarray */
	  MPI_Recv (temp_acct, 1, *pUserInfo, current_node,
		    MPI_MSG_TAG, MPI_COMM_WORLD, &msgstatus);

	  cracked_acct = get_struct (temp_acct->username, head);
	  if(!cracked_acct)break;
	  sync_accounts (cracked_acct, temp_acct);

	  if (cracked_acct->ntdone && cracked_acct->lmdone)
	    {
	      print_cracked_user (cracked_acct, cracklog);
	      head = remove_from_list (cracked_acct);
	    }

	  jobstatus.usercount = count_users (head);
	  free (masterarray);

	  if (jobstatus.usercount > 0)
	    masterarray = cp_list_to_array (head, jobstatus.usercount);

	  logger (Config->logginglevel, 2, 1, masterlog,
		  "REPORT_ACCOUNT:  NODE %d, ACCOUNT: %s\n",
		  current_node, temp_acct->username);
	  break;
	case NODE_SHUTDOWN:
	  /* jobstatus, config, masterlog, current_node */
	  jobstatus.slaves--;
	  logger (Config->logginglevel, 1, 1, masterlog,
		  "Node %d Terminating; %d Nodes left.\n",
		  current_node, jobstatus.slaves);
	  break;
	}

      time(&jobstatus.end);
      bench(jobstatus.end, jobstatus.begin, timebuffer);
      logger (Config->logginglevel, 2, 1, masterlog,
	      "Accounts:%d; Slaves:%d; %s\n", 
	      jobstatus.usercount,jobstatus.slaves,timebuffer);
    }
  logger (Config->logginglevel, 1, 1, masterlog,
	  "Job has %d accounts remaining\n", jobstatus.usercount);

  logger (Config->logginglevel, 1, 1, masterlog, "Master Terminating.\n");

  log_job_time(&jobstatus, Config, masterlog);

  MPI_Type_free(pUserInfo);
  free(pUserInfo);
  pUserInfo = NULL;

  MPI_Type_free(pBlock);
  free(pBlock);
  pBlock = NULL;

  free_rates (jobstatus.noderates);
  jobstatus.noderates = NULL;

  fclose (masterlog); masterlog = NULL;
  fclose (cracklog);  cracklog  = NULL;

  free (masterarray); masterarray = NULL;
  free_struct_list (head); head = NULL;
  free_block_list (blockq); blockq = NULL;

  return (0);
}
void 
log_job_time(STATUS *jobstatus, CONFIG *Config, FILE *masterlog)
{
  char  timebuffer[256];

  time(&jobstatus->end);
  bench(jobstatus->end, jobstatus->begin, timebuffer);
  logger (Config->logginglevel, 2, 1, masterlog,
	  "Job Run Time: %s\n" ,timebuffer);
  return;
}
