#include <stdio.h>
#include <mpi.h>

#include "dkbfincludes.h"
#include "dkbfconfig.h"
#include "dkbfslave.h"
#include "dkbfmaster.h"
#include "dkbflogging.h"
#include "dkbfconfig.h"
#include "dkbffile.h"

void
usage()
{
      fprintf (stderr,
	       "DKBF - A Distributed, Keyboard, Brute-Force password cracker \n"\
	       "\tfor Windows Lanman/NT Hashes\n" \
	       "\tEx Usage: mpirun -pg_file dkbf.pg dkbf -i dkbf.ini\n" \
	       "\t\t-pg_file\tproc group file\n"\
	       "\t\t-i\tdkbf initialization file\n"\
	       "\tMinimum of 2 processes required\n"\
	       "\tVersion: %s by d4b0rg@hotmail.com\n\n",VERSION);
      MPI_Abort (MPI_COMM_WORLD, 1);
}
int
main (int argc, char *argv[])
{
  int                rank;
  int                size;
  CONFIG             Config;

  MPI_Datatype       *pConfig;

  MPI_Init (&argc, &argv);
  MPI_Comm_size (MPI_COMM_WORLD, &size);
  MPI_Comm_rank (MPI_COMM_WORLD, &rank);

  if (size <= 1)
    {
      usage();
    }

  /* commit defined datatypes for MPI passing */
  pConfig = CommitConfig ();

  if (rank == MASTER)
    {
      dkbf_getopts(argc, argv, &Config);
      MPI_Bcast (&Config, 1, *pConfig, 0, MPI_COMM_WORLD);
      master (&Config);
    }
  else				
    {

      MPI_Bcast (&Config, 1, *pConfig, 0, MPI_COMM_WORLD);
      slave (Config, rank);
    }
  MPI_Type_free(pConfig);
  free(pConfig);
  pConfig=NULL;

  MPI_Barrier (MPI_COMM_WORLD);
  MPI_Finalize ();
  return 0;
}

