#include "dkbfkeysbynum.h"

#ifdef TESTKEYSBYNUM
#include "dkbfconfig.h"
#endif

static int
brute_length (long double blocknumber, int base)
{

  int exponent = 1;
  long double offset = 0;

  while (1)
    {

      offset += pow (base, exponent++);
      if (blocknumber - offset < 0)
	{
	  return --exponent;
	}
      if (blocknumber - offset == 0)
	{
	  return exponent;
	}
    }
  return 0;
}
static int
number_to_string (long double blocknumber, long double stringnum,
		  char *brute_str, char *charset, int base)
{
  int x = 0;
  int offsetlen = 0;
  int stringlen = 0;
  unsigned long long quotient;
  unsigned long long remainder;

  if (blocknumber < base)
    {
      int temp;
      temp = stringnum;
      brute_str[0] = charset[temp];
      return 0;
    }

  do
    {
      quotient = stringnum / base;
      remainder = stringnum - (quotient * base);
      if(remainder < 0)remainder = 0;
      brute_str[x++] = charset[remainder];
      stringnum = quotient;
    }

  while (quotient >= base);

  brute_str[x] = charset[quotient];

  stringlen = strlen (brute_str);

  offsetlen = brute_length (blocknumber, base);

  if (offsetlen > stringlen)
    {
      for (x = stringlen; x < offsetlen; x++)
	{
	  brute_str[x] = charset[0];
	}
    }

  return (0);
}
static long double
lbound (int base, int root)
{
  long double lbound = 0;

  if (root == 0)
    return 0;

  while (root)
    {
      lbound += pow (base, root--);
    }

  return lbound;
}
static long double
ubound (int base, int root)
{
  long double ubound = 0;

  root++;

  while (root)
    {
      ubound += pow (base, root--);
    }

  return ubound - 1;
}
static long double
get_offset (int root, int base, long double blocknumber, long double offset)
{
  long double my_lbound = 0;
  long double my_ubound = 0;

  my_lbound = lbound (base, root);
  my_ubound = ubound (base, root);

  if ((blocknumber >= my_lbound) && (blocknumber <= my_ubound))
    {
      return offset;
    }

  my_lbound = lbound (base, root - 1);

  return my_lbound;
}
static long double
get_offset_seed (int root, int base)
{
  long double offset = 0.0;

  while (root > 0)
    {
      offset += pow (base, root--);
    }

  return offset;
}
static int
get_root (long double blocknumber, int base)
{
  int root = 1;

  if (blocknumber < base)
    return 0;

  while (1)
    {
      root++;
      if (blocknumber - pow (base, root) >= 0);
      else
	break;
    }

  return root - 1;
}
int
block_to_string (char *brute_str, long double blocknumber, CONFIG * Config)
{
  long double offset = 0;
  long double stringnum = 0;
  long double seed = 0;
  int root = 0;

  memset (brute_str, '\0', strlen (brute_str));

  root = get_root (blocknumber, Config->charsetlen);

  seed = get_offset_seed (root, Config->charsetlen);

  offset = get_offset (root, Config->charsetlen, blocknumber, seed);

  stringnum = blocknumber - offset;

  number_to_string (blocknumber, stringnum, brute_str, Config->characterset,
		    Config->charsetlen);
  return 0;
}
#ifdef TESTKEYSBYNUM

int
main (void)
{
  char brute_str[32];
  long double blocknumber;
  CONFIG *Config;
  register int c = 0;

  memset (brute_str, '\0', 32);
  blocknumber = 79548387444;
  Config = (CONFIG *) malloc (sizeof (CONFIG));

  Config->blocksize = 1;
  strcpy (Config->characterset,
  "~ `_-+=|\\{[}]\"':;?/.>,<!@#$%^&*()9876543210ZYXWVUTSRQPONMLKJIHGFEDCBAabcdefghijklmnopqrstuvwxyz");

  Config->charsetlen = strlen (Config->characterset);
  printf("Charset length: %d\n", Config->charsetlen);

  while (blocknumber < 80603140212)
    {
      blocknumber = 80603140211;
      blocknumber = 445502494042;
      blocknumber = 10171889243783;
      blocknumber = 65545047154953;
      blocknumber = 70576641626495;
	block_to_string (brute_str, blocknumber, Config);
	    printf ("%.0Lf %s\n", blocknumber, brute_str);
	    exit(0);
	blocknumber += 1;
    }

  return 0;
}


#endif
