#include "dkbfkeygen.h"

long double
get_ttlkeys (CONFIG *Config)
{
  int         x;
  int         i;
  long double temp;
  long double ttl_keys = 0;
  long double skipped_keys = 0;

  for (x = 1; x < Config->maxpasswdlen + 1; x++)
    {
      temp = 1.0;
      for (i = x; i > 0; i--)
	temp *= Config->charsetlen;
      ttl_keys += temp;
    }
  if(Config->minpasswdlen > 1)
    {
      for (x = 1; x < Config->minpasswdlen + 1; x++)
	{
	  temp = 1.0;
	  for (i = x; i > 0; i--)
	    temp *= Config->charsetlen;
	  skipped_keys += temp;
	}
    }

  return ttl_keys-skipped_keys;
}
long double 
get_first_key (CONFIG * Config)
{

  int         x;
  int         i;
  long double temp;
  long double first_key = 0;

  if(Config->minpasswdlen > 1)
    {
      for (x = 1; x < Config->minpasswdlen; x++)
	{
	  temp = 1.0;
	  for (i = x; i > 0; i--)
	    temp *= Config->charsetlen;
	  first_key += temp;
	}
    }
  return first_key;
}

/*
#ifdef _UTILITY_TK

void
usage (char *progname)
{
  printf ("USAGE: %s -u [max length] -l [min length] -s[character set size] \n",
	  progname);
  printf ("\tCalculates number of total keys possible");
  printf (" given the maximum and \n\toptionally the minimum password length"\
	  " and the character set size.\n");
  printf ("\t-u and -s are required; -l is defaulted to 1\n");
  exit (0);
}

int
main (int argc, char **argv)
{
  
  char          c;
  CONFIG *Config;

  Config = (CONFIG *)malloc(sizeof(CONFIG));
  Config->charsetlen = 0;
  Config->maxpasswdlen = 0;
  Config->minpasswdlen = 0;

  while ( (c = getopt(argc, argv, "u:l:s:")) != EOF){
    switch(c) {
    case 'u':
      Config->maxpasswdlen = atoi(optarg);
      break;
    case 'l':
      Config->minpasswdlen = atoi(optarg);
      break;
    case 's':
      Config->charsetlen = atoi(optarg);
      break;
    }
  }
  if (Config->charsetlen == 0 || Config->maxpasswdlen == 0)
    usage (argv[0]);
  else
    {
      fprintf (stderr, "%.0Lf\n", get_ttlkeys (Config));
    }
  return 0;
}

#endif
*/
