#include "dkbfgetaccts.h"

static void
copyuser (struct user_struct *destination, struct user_struct *source)
{
  memcpy (destination->username, source->username, sizeof (source->username));
  memcpy (destination->lmhash, source->lmhash, sizeof (source->lmhash));
  memcpy (destination->nthash, source->nthash, sizeof (source->nthash));

  memcpy (destination->lmhashb, source->lmhashb, sizeof (source->lmhashb));
  memcpy (destination->nthashb, source->nthashb, sizeof (source->nthashb));
  memcpy (destination->foo, source->foo, sizeof (source->foo));
  memcpy (destination->bar, source->bar, sizeof (source->bar));

  memcpy (destination->lmpasswd, source->lmpasswd, sizeof (source->lmpasswd));
  memcpy (destination->ntpasswd, source->ntpasswd, sizeof (source->ntpasswd));

  memcpy (destination->lmresp_b, source->lmresp_b, sizeof (source->lmresp_b));
  memcpy (destination->ntresp_b, source->ntresp_b, sizeof (source->ntresp_b));

  memcpy (destination->first_half, source->first_half,
	  sizeof (source->first_half));
  memcpy (destination->second_half, source->second_half,
	  sizeof (source->second_half));

  destination->lmdone = source->lmdone;
  destination->ntdone = source->ntdone;
  destination->pwdumpval = source->pwdumpval;

  destination->already_printed = source->already_printed;
  destination->under7 = source->under7;

  memcpy (destination->server_chall, source->server_chall,
	  sizeof (source->server_chall));

  destination->previous = source->previous;
  destination->next = source->next;
}

void
cnvt_array_to_list (struct user_struct *head,
		    struct user_struct *masterarray, int usercount)
{
  struct user_struct *ptr;
  struct user_struct *newrecord;
  int                x = 0;

  ptr = head;

  while (x < usercount)
    {
      /* head, first record */
      if (x == 0)
	{
	  copyuser (ptr, &masterarray[x]);
	  ptr->previous = NULL;
	  ptr->next = NULL;	
	  x++;
	}
      /* last record */
      else if (x == usercount - 1)
	{
	  newrecord = init_linked_list ();
	  copyuser (newrecord, &masterarray[x]);
	  newrecord->previous = ptr;
	  newrecord->next = NULL;
	  ptr->next = newrecord;
	  x++;
	}
      /* all middle records */
      else
	{
	  newrecord = init_linked_list ();
	  copyuser (newrecord, &masterarray[x]);
	  newrecord->previous = ptr;
	  newrecord->next = NULL;
	  ptr->next = newrecord;
	  ptr = newrecord;
	  x++;
	}
    }
}
void
print_user (struct user_struct *Ustruct, FILE * file)
{
  int    i = 0;

  {
    fprintf (file, "Username: %s\n", Ustruct->username);

    fprintf (file, " Lanmanhash: ");
    for (i = 0; i < 32; i++)
      fprintf (file, "%c", Ustruct->lmhash[i]);
    fprintf (file, " \n");

    fprintf (file, " NThash: ");
    for (i = 0; i < 32; i++)
      fprintf (file, "%c", Ustruct->nthash[i]);
    fprintf (file, " \n");

    fprintf (file, " LanManHashb: ");
    for (i = 0; i < 16; i++)
      fprintf (file, "%c", Ustruct->lmhashb[i]);
    fprintf (file, " \n");

    fprintf (file, " NTHashb: ");
    for (i = 0; i < 4; i++)
      fprintf (file, "%lX", Ustruct->nthashb[i]);
    fprintf (file, " \n");

    fprintf (file, " under7: %d\n", Ustruct->under7);

    fprintf (file, " lmdone: %d\n", Ustruct->lmdone);
    if (Ustruct->lmdone)
      {
	fprintf (file, " Lanman PW: %s\n", Ustruct->lmpasswd);
	fprintf (file, " lmresp_b: %s\n", Ustruct->lmresp_b);
      }

    fprintf (file, " ntdone: %d\n", Ustruct->ntdone);
    if (Ustruct->ntdone)
      {
	fprintf (file, " NT dialect PW: %s\n", Ustruct->ntpasswd);
	fprintf (file, " ntresp_b: %s\n", Ustruct->ntresp_b);
      }

    fprintf (file, " pwdumpval:%d\n", Ustruct->pwdumpval);
    if (!Ustruct->pwdumpval)
      {
	fprintf (file, " Server_chall: %s\n", Ustruct->server_chall);
      }

    fprintf (file, " already_printed: %d\n", Ustruct->already_printed);

    /*
       fprintf (file, " first_half: %s\n", Ustruct->first_half);
       fprintf (file, " second_half: %s\n", Ustruct->second_half);
     */

    fprintf (file, " \n");
    fflush (file);
  }
}
void
print_cracked_user (struct user_struct *Ustruct, FILE * file)
{

  fprintf (file, "Username: %s ", Ustruct->username);

  if (Ustruct->lmdone)
    fprintf (file, "Lanman: %s ", Ustruct->lmpasswd);

  if (Ustruct->ntdone)
    fprintf (file, "NT: %s\n", Ustruct->ntpasswd);
  fflush (file);
}
int
count_users (struct user_struct *head)
{
  struct user_struct  *ptr;
  int                 i = 0;

  ptr = head;

  if (ptr)			
    {
      while (ptr->next != NULL)
	{
	  ptr = ptr->next;
	  i++;
	}
      i++;
    }

  return i;
}
void
cp_array_to_list (int pwdumpval, struct user_struct *head,
	      struct user_struct *masterarray, int usercount)
{
  int    x = 0;

  /* handle the first node */
  masterarray[0].previous = NULL;

  if (usercount > 1)
    masterarray[0].next = &masterarray[1];
  else
    {
      masterarray[0].next = NULL;
      return;
    }

  /* handle the last node */
  masterarray[usercount - 1].previous = &masterarray[usercount - 2];
  masterarray[usercount - 1].next = NULL;

  for (x = 1; x < usercount - 1; x++)
    {
      masterarray[x].next = &masterarray[x + 1];
      masterarray[x].previous = &masterarray[x - 1];
    }

  return;
}
struct user_struct *
cp_list_to_array (struct user_struct *head, int usercount)
{

  struct user_struct *ptr;
  struct user_struct *tmp;
  int                i = 0;

  if (
      (tmp =
       (struct user_struct *) malloc (sizeof (struct user_struct) *
				      usercount)) == NULL)
    {
      printf ("Could not allocate memory for users\n");
      fflush (stdout);
      MPI_Abort(MPI_COMM_WORLD, 1);			
    }

  ptr = head;
  while (i < usercount)
    {
      memcpy (tmp[i].username, ptr->username, sizeof (ptr->username));
      memcpy (tmp[i].lmhash, ptr->lmhash, sizeof (ptr->lmhash));
      memcpy (tmp[i].nthash, ptr->nthash, sizeof (ptr->nthash));
      memcpy (tmp[i].lmhashb, ptr->lmhashb, sizeof (ptr->lmhashb));
      memcpy (tmp[i].nthashb, ptr->nthashb, sizeof (ptr->nthashb));
      memcpy (tmp[i].ntpasswd, ptr->ntpasswd, sizeof (ptr->ntpasswd));
      memcpy (tmp[i].lmpasswd, ptr->lmpasswd, sizeof (ptr->lmpasswd));
      memcpy (tmp[i].lmresp_b, ptr->lmresp_b, sizeof (ptr->lmresp_b));
      memcpy (tmp[i].ntresp_b, ptr->ntresp_b, sizeof (ptr->ntresp_b));
      memcpy (tmp[i].first_half, ptr->first_half, sizeof (ptr->first_half));
      memcpy (tmp[i].second_half, ptr->second_half,
	      sizeof (ptr->second_half));
      memcpy (tmp[i].server_chall, ptr->server_chall,
	      sizeof (ptr->server_chall));

      tmp[i].lmdone = ptr->lmdone;
      tmp[i].already_printed = 0;
      tmp[i].pwdumpval = ptr->pwdumpval;
      tmp[i].ntdone = ptr->lmdone;
      tmp[i].under7 = ptr->under7;

      ptr = ptr->next;
      i++;
    }
  return tmp;
}
struct user_struct *
get_struct (char *username, struct user_struct *head)
{
  struct user_struct *tmp;

  tmp = head;

  while (tmp)
    {
      if (!(strcmp (tmp->username, username)))
	return (tmp);
      tmp = tmp->next;
    }

  return 0;
}
void
sync_accounts (struct user_struct *cracked, struct user_struct *temp_account)
{

  if (memcmp
      (cracked->lmpasswd, temp_account->lmpasswd,
       sizeof (temp_account->lmpasswd)) != 0)
    memcpy (cracked->lmpasswd, temp_account->lmpasswd,
	    sizeof (temp_account->lmpasswd));

  if (memcmp
      (cracked->ntpasswd, temp_account->ntpasswd,
       sizeof (temp_account->ntpasswd)) != 0)
    memcpy (cracked->ntpasswd, temp_account->ntpasswd,
	    sizeof (temp_account->ntpasswd));

  if (memcmp
      (cracked->first_half, temp_account->first_half,
       sizeof (temp_account->first_half)) != 0)
    memcpy (cracked->first_half, temp_account->first_half,
	    sizeof (temp_account->first_half));

  if (memcmp
      (cracked->second_half, temp_account->second_half,
       sizeof (temp_account->second_half)) != 0)
    memcpy (cracked->second_half, temp_account->second_half,
	    sizeof (temp_account->second_half));

  if (cracked->lmdone != temp_account->lmdone)
    cracked->lmdone = temp_account->lmdone;

  if (cracked->ntdone != temp_account->ntdone)
    cracked->ntdone = temp_account->ntdone;
}


