/* crank.c - Program initialisation and location of main()
 * 
 * This program is part of Crank, a cryptanalysis tool
 * Copyright (C) 2000 Matthew Russell
 *
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License (LICENSE) for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#include "crank.h"

/* Global variables */
char *text;

/* External functions and data */
extern void init_global_key(void);
extern stats *text_stats;
extern float *slft_std;
extern float *bift_std;
extern float *trift_std;
stats *make_stats(char *text);
float *load_slft_std(char *filename);
float *load_bift_std(char *filename);
float *load_trift_std(char *filename);
void build_gui(void);

int main (int argc, char *argv[]) {
    init_global_key();

    /* Load the standard frequency tables */
    slft_std = load_slft_std(DEFAULT_SLFT);
    bift_std = load_bift_std(DEFAULT_BIFT);
    trift_std = load_trift_std(DEFAULT_TRIFT);
    
    gtk_init(&argc, &argv);
    build_gui();
    text_stats = make_stats(text);
    gtk_main();
    
    exit(0);
}
