#ifndef _DKBF_SLAVE_H
#define _DKBF_SLAVE_H

#include <mpi.h>
#include <stdio.h>
#include <memory.h>
#include <time.h>
#include <stdlib.h>
#include <unistd.h>

#include "dkbfincludes.h"
#include "dkbfblock.h"
#include "dkbfconfig.h"
#include "dkbflogging.h"
#include "dkbfkeygen.h"
#include "dkbfuser.h"
#include "dkbfgetaccts.h"
#include "dkbfschedule.h"
#include "dkbfkeysbynum.h"
#include "dkbfkeysbystr.h"
#include "dkbfrulez.h"

extern MPI_Datatype *pUserInfo, *pBlock;

int slave (CONFIG Config, int rank);

struct user_struct *brute(BLOCK *s_block, int usercount, struct user_struct *head,
			  FILE *slavelog, CONFIG *Config);

struct user_struct *lanman_nt_dump (struct user_struct *head, FILE * slavelog, 
				    CONFIG * Config, char *brute_str);

struct user_struct *nt_dump (struct user_struct *head, FILE * slavelog, 
			     CONFIG * Config, char *brute_str);
 
struct user_struct *lanman_nt_sniff(struct user_struct *head, FILE * slavelog, 
				    CONFIG * Config, char *brute_str);

struct user_struct *nt_sniff(struct user_struct *head, FILE * slavelog, 
			     CONFIG * Config, char *brute_str);

int benchmark_block(BLOCK *s_block);
		 		 
int announce_shutdown ();

int compare_nthash(CONFIG *Config, struct user_struct *head, 
		   char *match_nthash, char *match_ntpasswd);

extern void E_P24(uchar *, uchar *, uchar *);
extern void LMword(char *, char *);
extern int lm_check_sniff(struct user_struct *, char *, CONFIG *);

extern struct user_struct *init_linked_list ();
extern void free_struct_list (struct user_struct *index);
extern void half_lanman (char *half_hash, char *brute_str);
extern void full_lanman(char *full_lmhash, char *brute_str);
extern int brute_routine (struct user_struct *head, char *half_hash, 
			  char *, CONFIG *Config);
extern void nt_ify_list (struct user_struct *head);
extern struct user_struct *prune_list (struct user_struct *head);
extern int report_account (struct user_struct *index);
extern int PutUniCode(char *dst,char *src);
extern void md4hash(char *passwd, unsigned char *p16, int len);

#endif


