#ifndef _DKBF_LOGGING_H
#define _DKBF_LOGGING_H

#include <stdio.h>
#include <mpi.h>
#include <memory.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>

#include "dkbfincludes.h"

#define SINGLEOUTPUT     0
#define DUALOUTPUT       1


/* handles the timing routines for benchmarking */
int bench (long end, long begin, char *buffer);

/* opens a file with a name based on the jobname for logging */
FILE *jobfopen (char *jobname, char *basename, char *flags);

/* generates a time/date stamp in buffer which must be 27 chars min */
int timestamp (char *buffer);


/*    
   does the logging; writes to file and/or console 
   each line in log file gets a time/date stamp

   Logginglevel is set by the user in the ini  file.
   The level is set by the programmer.  The higher the level,
   the LESS important the message.  The MOST IMPORTANT messages should be
   set a level of 0. 

   dualoutput - spits out to printf and fprintf

   to output to the console pass in fp, where fp to stdout
   to output to a file pass in fp, where fp is a FILE * set to the file
   to output to both console/file set dualoutput = 1 and pass fp as FILE * set
   to file
 */
int logger (int logginglevel, int level, int dualoutput, FILE * fp, 
	    char *fmt,...);

#endif
