#include "dkbfblockq.h"

BLOCKNODE *
new_blocknode ()
{
  BLOCKNODE   *head;

  head = (BLOCKNODE *) malloc (sizeof (BLOCKNODE));

  memset (head, '\0', sizeof (BLOCKNODE));

  head->block = (BLOCK *) malloc (sizeof (BLOCK));

  memset (head->block, '\0', sizeof (BLOCK));

  head->next = NULL;
  head->filled = 0;

  return head;
}
BLOCKNODE *
add_blocknode (BLOCK s_block, BLOCKNODE * head)
{
  BLOCKNODE   *tmp;
  BLOCKNODE   *new;

  if (!head)
    head = new_blocknode ();

  tmp = head;

  while (tmp->next != NULL)
    {
      tmp = tmp->next;
    }

  if (tmp->filled == 1)
    {
      new = new_blocknode ();
      tmp->next = new;
      new->block->start = s_block.start;
      new->block->size = s_block.size;
      new->block->elapsed = s_block.elapsed;
      new->block->rate = s_block.rate;
      new->block->issued_t = s_block.issued_t;
      new->filled = 1;
    }
  else
    {
      tmp->block->start = s_block.start;
      tmp->block->size = s_block.size;
      tmp->block->elapsed = s_block.elapsed;
      tmp->block->rate = s_block.rate;
      tmp->block->issued_t = s_block.issued_t;
      tmp->filled = 1;
    }
  return head;
}
BLOCKNODE *
remove_blocknode (long double start, BLOCKNODE * head)
{
  BLOCKNODE   *tmp;
  BLOCKNODE   *prev;

  tmp = prev = NULL;
  tmp = head;

  /* remove first node */ 
  if (head->block->start == start)
    {
      head = head->next;
      free (tmp->block);
      tmp->block = NULL;
      free (tmp);
      tmp = NULL;
      return head;
    }
  while (tmp->block->start != start)
    {
      prev = tmp;
      tmp = tmp->next;
      if (!tmp)
	return head;
    }
  prev->next = tmp->next;

  free (tmp->block);
  tmp->block = NULL;

  free (tmp);
  tmp = NULL;

  return head;
}
int
free_block_list (BLOCKNODE * head)
{
  BLOCKNODE   *tmp;
  BLOCKNODE   *del;

  tmp = head;

  if (!tmp)
    return 1;

  while (tmp->next != NULL)
    {
      del = tmp;
      tmp = tmp->next;
      free (del->block);
      del->block = NULL;
      free (del);
      del = NULL;
    }

  free (tmp->block);
  tmp->block = NULL;

  free (tmp);
  tmp = NULL;

  return 0;
}
int
printlist (BLOCKNODE * head)
{
  BLOCKNODE   *tmp;

  tmp = head;

  if (!tmp)
    return 1;

  if (tmp->filled)
    {
      printf ("%.0Lf\t", tmp->block->start);
    }
  else
    {
      return 0;
    }

  while (tmp->next != NULL)
    {
      tmp = tmp->next;
      printf ("%.0Lf\t", tmp->block->start);
    }

  return 0;
}
int
print_block (BLOCK s_block)
{

  printf ("Block Number: %.0Lf\tBlock Size: %.0Lf\n", 
	  s_block.start, s_block.size);

  return 0;
}
static int
isexpired (time_t issued, long maxworkingtime)
{
  time_t    now;

  time (&now);

  return ((now - issued) > maxworkingtime) ? 1 : 0;
}
int
get_expired_block (BLOCKNODE * blockq, long maxworkingtime,
		   BLOCKNODE * expiredblock)
{

  BLOCKNODE  *tmp;
  if (!blockq)
    return 0;

  tmp = blockq;

  if (!tmp->filled)
    return 0;

  /* check first block in queue */
  if (isexpired (tmp->block->issued_t, maxworkingtime))
    {
      time (&tmp->block->issued_t);
      expiredblock = tmp;
      return 1;
    }

  /* check the rest */
  while (tmp->next != NULL)
    {
      tmp = tmp->next;
      if (isexpired (tmp->block->issued_t, maxworkingtime))
	{
	  /* reset the time the  block was issued */
	  time (&tmp->block->issued_t);
	  expiredblock = tmp;
	  return 1;
	}
    }
  return 0;
}
BLOCKNODE *
get_next_block (CONFIG * Config, STATUS * jobstatus,
		BLOCK * s_block, BLOCKNODE * blockq, int *expired)
{
  static long double   current_block  = 0;
  static unsigned int  veryfirstblock = 1;
  BLOCKNODE            *expiredblock;

  *expired = 0;

  /* first block is always 0 */
  if (veryfirstblock)
    {
      veryfirstblock--;
      /* jump to min passwd len size */
      s_block->start = jobstatus->first_key;
      current_block = s_block->start;

      if(Config->blocksize > jobstatus->ttl_keys)
	{
	  s_block->size = jobstatus->ttl_keys;
	}
      else
	{
	  s_block->size = Config->blocksize;
	}

      time (&s_block->issued_t);
      blockq = add_blocknode (*s_block, blockq);
      *expired = 0;
      return blockq;
    }

  /* check for any expired blocks */
  *expired = get_expired_block (blockq, Config->blockexpiration,
				expiredblock);

  /* no expired blocks */
  if (!*expired)
    {
      /* if all  blocks are done */
      if (current_block == -1)
	{
	  s_block->start = -1;
	  return blockq;
	}
      /* compute next block */
      s_block->size = Config->blocksize;
      current_block += Config->blocksize;
      s_block->start = current_block;
      time (&s_block->issued_t);

      /* if block not in range (all blocks done) set to -1 */
      if (s_block->start > jobstatus->last_key)
	{
	  s_block->start = -1;
	  current_block = -1;
	  return blockq;
	}
      /* block in range */
      else
	{
	  /* block too large; adjust size to last key */
	  if (s_block->start + s_block->size > jobstatus->last_key)
	    {
	      s_block->size = jobstatus->last_key - s_block->start;

	      /* set flag to indicate no more blocks */
	      current_block = -1;
	    }

	  /* block is now in range; add to queu */
	  blockq = add_blocknode (*s_block, blockq);
	  return blockq;
	}
    }
  else
    {
      /* reissue expired block */
      s_block = expiredblock->block;
      *expired = 1;
    }
  return blockq;
}

/*
int main()
{
  BLOCK  *s_block;
  BLOCKNODE *head;
  int x, i, expired = 0;
  CONFIG Config;  
  long double last_key = 8353082582;

  s_block = (BLOCK *)malloc(sizeof(BLOCK));
  head    = new_blocknode();

  Config.blockexpiration = 10000;
  Config.blocksize = 2000000;

  for(x=0;x<4;x++)
    {
      get_next_block (&Config, last_key, s_block, head, &expired);
      printf("%.0Lf\n", s_block->start);
      remove_blocknode (s_block->start, head);
    }

  return 0;

  for(x=0;x<10;x++){
    s_block.start=x;
    head = add_blocknode(s_block, head);  
    head = remove_blocknode(x,head);  
  }

  //test for 3 slave run
  for(i=0;i<10;i++){
    for(x=0;x<3;x++){
      s_block.start=x;
      head = add_blocknode(s_block, head);  
    }
    for(x=0;x<3;x++){
      s_block.start=x;
      head = remove_blocknode(x,head);  
    }
  }
  return 0;

}

*/
