#ifndef _DKBF_BLOCK_H
#define _DKBF_BLOCK_H

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <mpi.h>
#include <time.h>

#define WORKUNIT_NBLOCKS        7

#define WORKUNITSTARTSIZE       1
#define WORKUNITSIZESIZE        1
#define WORKUNIT_ELAPSEDSIZE    1
#define WORKUNIT_RATESIZE       1
#define WORKUNIT_BEGINSIZE      1
#define WORKUNIT_ENDSIZE        1
#define WORKUNIT_ISSUEDSIZE     1

struct block
{
  long double start;
  long double size;
  long elapsed;
  float rate;
  time_t begin_t;
  time_t end_t;
  time_t issued_t;
};

typedef struct block BLOCK;

/* globals */
//MPI_Datatype *pBlock;

/* malloc the block with error checking and 
   memset to null */
BLOCK *malloc_block ();

/* Commit the struct Block into an MPI Datatype */
MPI_Datatype *CommitBlock ();

#endif
