#include "dkbfblock.h"

BLOCK *
malloc_block ()
{
  BLOCK *block = NULL;

  block = (BLOCK *) malloc (sizeof (BLOCK));

  if (!block)
    return 0;

  memset (block, '\0', sizeof (BLOCK));

  return block;
}
MPI_Datatype *
CommitBlock ()
{
  MPI_Datatype  *pBlock;
  MPI_Datatype  *lBlock;
  BLOCK         s_block;
  int           base;
  int           x;

  int bl[WORKUNIT_NBLOCKS] = { WORKUNITSTARTSIZE, 
			       WORKUNITSIZESIZE,
			       WORKUNIT_ELAPSEDSIZE, 
			       WORKUNIT_RATESIZE,
			       WORKUNIT_BEGINSIZE,
			       WORKUNIT_ENDSIZE,
			       WORKUNIT_ISSUEDSIZE};

  MPI_Aint disp[WORKUNIT_NBLOCKS];

  MPI_Datatype types[WORKUNIT_NBLOCKS] = { MPI_LONG_DOUBLE, 
					   MPI_LONG_DOUBLE,
					   MPI_LONG, 
					   MPI_FLOAT, 
					   MPI_LONG,
					   MPI_LONG,
					   MPI_LONG};

  lBlock = (MPI_Datatype *) malloc (sizeof (MPI_Datatype));

  MPI_Address (&s_block, disp);
  MPI_Address (&s_block.size, &disp[1]);
  MPI_Address (&s_block.elapsed, &disp[2]);
  MPI_Address (&s_block.rate, &disp[3]);
  MPI_Address (&s_block.begin_t, &disp[4]);
  MPI_Address (&s_block.end_t, &disp[5]);
  MPI_Address (&s_block.issued_t, &disp[6]);

  base = disp[0];

  for (x = 0; x < WORKUNIT_NBLOCKS; x++)
    disp[x] -= base;

  MPI_Type_struct (WORKUNIT_NBLOCKS, bl, disp, types, lBlock);

  MPI_Type_commit (lBlock);

  pBlock = (MPI_Datatype *) malloc (sizeof (MPI_Datatype));

  if (pBlock == NULL)
    {
      printf ("malloc failed in Block commit\n");
      MPI_Abort (MPI_COMM_WORLD, 0);
    }

  pBlock = lBlock;
  return pBlock;
}
