#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <time.h>
#include <getopt.h>
#include <math.h>

#include "des.h"

extern void str_to_key (unsigned char *str, unsigned char *key);

char str_to_crypt[] = "\x4b\x47\x53\x21\x40\x23\x24\x25";

void
half_lanman (char *half_hash, char *brute_str)
{
  unsigned char lanman[8];

  des_cblock deskey1;
  des_key_schedule ks1;

  /* create the first 8byte odd parity des key */
  str_to_key ((unsigned char *) brute_str, deskey1);
  /* setup the key schedule */
  des_set_key ((des_cblock *) deskey1, ks1);

  /* encrypt the known 8byte value against the first des key */
  des_ecb_encrypt ((des_cblock *) str_to_crypt, (des_cblock *) lanman, ks1, 
		   DES_ENCRYPT);

  memcpy (half_hash, lanman, 8);

}
int usage(char *progname)
{
  printf("Usage: %s -[algorithm(s)]\n"
	 "%s   benchmarks the various algorithms in dkbf\n"
	 "     to provide configuration information\n"
	 "-l   Bench the Lanman hash (DES) algorithm\n"
	 "-h   show command line usage\n", progname, progname);
  exit(0);
}
int
lanman_bench()
{
  char   charset[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  char   half_hash[8];
  char   brute_str[8] = { 0x00, 0x00, 0x00, 0x00,
			  0x00, 0x00, 0x00, 0x00 };
  int    i;
  int    exp;
  time_t start, stop;
  float  rate;
  long   iterations = 100;
  long   elapsed = 0;
  long   magnitude = 1;

  memset (half_hash, '\0', 8);
  printf("Benchmarking Lanman");fflush(stdout);
  do
    {
      iterations *= 5;
      time (&start);
      for (i = 0; i < iterations; i++)
	{
	  get_next_brute_string (brute_str, charset);
	  half_lanman (half_hash, brute_str);
	}
      time (&stop);
      elapsed = stop - start;
      if(elapsed)
	{
	rate = iterations / elapsed;
	}
      printf(".");fflush(stdout);
    }while(elapsed < 4 );
  printf("Approx. Rate: %.02f k/s\n", rate);
  printf("Block Size\t\tEst. Time per Block in seconds\n"
	 "----------\t\t------------------------------\n");

  exp = 0;
  for(i = 3 ; i < 10; i++)
    {
      while(exp++ != i)
	{
	  magnitude *=10;	 
	}
      printf("%10d\t\t%10.02f\n", magnitude, magnitude/rate);
      exp = 0;
      magnitude = 1;
    }
  
  return 0;
}
int
main (int argc, char **argv)
{
  int    i;
  int    lanman = 0;

  if(argc < 2 )usage(argv[0]);

  while ( (i = getopt(argc, argv, "lh")) != EOF){
    switch(i) {
    case 'l': /* algorithm */
      lanman++;
      break;
    case 'h':
    default:
      usage(argv[0]);
    }
  }

  if(lanman)lanman_bench();

  return 0;
}
