#include <stdio.h>
#include <stdlib.h>

void
usage (char *progname)
{
  printf ("USAGE: %s [max password length] [character set size] \n ",
	  progname);
  printf ("Calculates number of total keys possible\n");
  printf ("given the maximum password length and the character set size.\n");
  exit (0);
}
long double
get_ttlkeys (int pwdlength, int charsetsize)
{
  int x, i;
  long double temp;
  long double ttl_keys = 0;

  for (x = 1; x < pwdlength + 1; x++)
    {
      temp = 1.0;
      for (i = x; i > 0; i--)
	{
	  temp *= charsetsize;
	}
      ttl_keys += temp;
    }
  return ttl_keys;
}
int
main (int argc, char **argv)
{
  int pwdlength;
  int charsetsize;

  if (argc != 3)
    usage (argv[0]);
  else
    {
      pwdlength = atoi (argv[1]);
      charsetsize = atoi (argv[2]);
      fprintf (stderr, "%.0Lf\n", get_ttlkeys (pwdlength, charsetsize));
    }
  return 0;
}
