/*****************************************/
/* Stack Shield v0.7                     */
/* by Vendicator 1999-2000               */
/*****************************************/
/* File: shieldg++.c                     */
/* Stack Shield G++ front end            */
/*****************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define PTR_SIZE 4

#define GCC "g++"
#define STACKSHIELD "stackshield"

void cleartemp(int tmpfilesc, char **tmpfilesv);

void cleartemp(int tmpfilesc, char **tmpfilesv) {
  FILE *fileptr;
  int i;

  for (i=0; i < tmpfilesc; i++)
    if (fileptr=fopen(tmpfilesv[i], "r")) {
      fclose(fileptr);
      remove(tmpfilesv[i]);
    }
}

int main(int argc, char **argv) {
  int opt;
  int highlevelfilesc = 0;
  int asmfilesc = 0;
  int headerfilesc = 0;
  int gccoptionsc = 0;
  int tmpfilesc = 0;
  char **highlevelfilesv = NULL;
  char **asmfilesv = NULL;
  char **headerfilesv = NULL;
  char **gccoptionsv = NULL;
  char **tmpfilesv = NULL;
  char cmdline[1024], tmpcmdline[1024];
  char stackshieldopt[1024];
  char outputfile[257];
  char *tmpopt;
  char tmpfilename[257];
  int i;

  stackshieldopt[0]=' ';
  stackshieldopt[1]='\0';
  outputfile[0]=' ';
  outputfile[1]='\0';
  opterr=0;
  while ((opt=getopt(argc, argv, "z:o:")) != EOF) {
    switch (opt) {
      case 'z':
        strncat(stackshieldopt, " -", 1022);
        strncat(stackshieldopt, optarg, 1024-strlen(optarg));
	break;
      case 'o':
        strncpy(outputfile, optarg, 256);
        outputfile[256]='\0';
	break;
    }
  }

  for (i=1; i < argc; i++) {
    if (strstr(argv[i], ".c") || 
      strstr(argv[i], ".cc") || 
      strstr(argv[i], ".cxx") ||
      strstr(argv[i], ".m") ||
      strstr(argv[i], ".i") ||
      strstr(argv[i], ".ii") ||
      strstr(argv[i], ".S") && (strcmp(argv[i], outputfile))) {
      highlevelfilesc++;
      tmpopt=(char *)malloc(strlen(argv[i])+1);
      highlevelfilesv=(char **)realloc(highlevelfilesv,
        highlevelfilesc*PTR_SIZE);
      highlevelfilesv[highlevelfilesc-1]=tmpopt;
      strncpy(tmpopt, argv[i], strlen(argv[i]));
      tmpopt[strlen(argv[i])]='\0';
    }
    else if (strstr(argv[i], ".s") && (strcmp(argv[i], outputfile))) {
      asmfilesc++;
      tmpopt=(char *)malloc(strlen(argv[i])+1);
      asmfilesv=(char **)realloc(asmfilesv, asmfilesc*PTR_SIZE);
      asmfilesv[asmfilesc-1]=tmpopt;
      strncpy(tmpopt, argv[i], strlen(argv[i]));
      tmpopt[strlen(argv[i])]='\0';
    }
    else if (strstr(argv[i], ".h") && (strcmp(argv[i], outputfile))) {
      headerfilesc++;
      tmpopt=(char *)malloc(strlen(argv[i])+1);
      headerfilesv=(char **)realloc(headerfilesv, headerfilesc*PTR_SIZE);
      headerfilesv[headerfilesc-1]=tmpopt;
      strncpy(tmpopt, argv[i], strlen(argv[i]));
      tmpopt[strlen(argv[i])]='\0';
    }
    else {
      if (strcmp(argv[i], outputfile) && (strcmp(argv[i], "-o"))) {
        gccoptionsc++;
        tmpopt=(char *)malloc(strlen(argv[i])+1);
        gccoptionsv=(char **)realloc(gccoptionsv, gccoptionsc*PTR_SIZE);
        gccoptionsv[gccoptionsc-1]=tmpopt;
        strncpy(tmpopt, argv[i], strlen(argv[i]));
        tmpopt[strlen(argv[i])]='\0';
      }
    }
  }
/******************************************
Removed in this beta
  if ((highlevelfilesc == 0) && (asmfilesc == 0) && (headerfilesc == 0)) {
    fprintf(stderr, "Shield G++: No input files\n");
    exit(EXIT_FAILURE);
  }
******************************************/

  cmdline[1023]='\0';
  tmpcmdline[1023]='\0';
  strncpy(cmdline, GCC, 1024);
  for (i=0; i < gccoptionsc; i++) {
    strncat(cmdline, " ", 1024-strlen(cmdline));
    strncat(cmdline, gccoptionsv[i], 1024-strlen(cmdline));
  }
  for (i=0; i < headerfilesc; i++) {
    strncat(cmdline, " ", 1024-strlen(cmdline));
    strncat(cmdline, headerfilesv[i], 1024-strlen(cmdline));
  }
  for(i=0; i < highlevelfilesc; i++) {
    strncpy(tmpcmdline, cmdline, 1024);
    strncat(tmpcmdline, " -S -o ", 1024-strlen(tmpcmdline));
    tmpnam(tmpfilename);
    strncat(tmpfilename, ".s", 257-strlen(tmpfilename)-2);
    strncat(tmpcmdline, tmpfilename, 1024-strlen(tmpcmdline));
    strncat(tmpcmdline, " ", 1024-strlen(tmpcmdline));
    strncat(tmpcmdline, highlevelfilesv[i], 1024-strlen(tmpcmdline));
    if (system(tmpcmdline)) {
      fprintf(stderr, "Shield G++: Cannot compile %s\n", highlevelfilesv[i]);
      cleartemp(tmpfilesc, tmpfilesv);
      exit(EXIT_FAILURE);
    }
    asmfilesc++;
    tmpopt=(char *)malloc(strlen(tmpfilename)+1);
    asmfilesv=(char **)realloc(asmfilesv, asmfilesc*PTR_SIZE);
    asmfilesv[asmfilesc-1]=tmpopt;
    strncpy(tmpopt, tmpfilename, strlen(tmpfilename));
    tmpopt[strlen(tmpfilename)]='\0';
    tmpfilesc++;
    tmpopt=(char *)malloc(strlen(tmpfilename)+1);
    tmpfilesv=(char **)realloc(tmpfilesv, tmpfilesc*PTR_SIZE);
    tmpfilesv[tmpfilesc-1]=tmpopt;
    strncpy(tmpopt, tmpfilename, strlen(tmpfilename));
    tmpopt[strlen(tmpfilename)]='\0';
  }
  for (i=0; i < asmfilesc; i++) {
    tmpnam(tmpfilename);
    strncat(tmpfilename, ".s", 257-strlen(tmpfilename)-2);
    snprintf(tmpcmdline, 1024, "%s%s %s %s", STACKSHIELD, stackshieldopt,
      asmfilesv[i], tmpfilename);
    if (system(tmpcmdline)) {
      fprintf(stderr, "Shield G++: Stack Shield error\n");
      cleartemp(tmpfilesc, tmpfilesv);
      exit(EXIT_FAILURE);
    }
    gccoptionsc++;
    tmpopt=(char *)malloc(strlen(tmpfilename)+1);
    gccoptionsv=(char **)realloc(gccoptionsv, gccoptionsc*PTR_SIZE);
    gccoptionsv[gccoptionsc-1]=tmpopt;
    strncpy(tmpopt, tmpfilename, strlen(tmpfilename));
    tmpopt[strlen(tmpfilename)]='\0';
    tmpfilesc++;
    tmpopt=(char *)malloc(strlen(tmpfilename)+1);
    tmpfilesv=(char **)realloc(tmpfilesv, tmpfilesc*PTR_SIZE);
    tmpfilesv[tmpfilesc-1]=tmpopt;
    strncpy(tmpopt, tmpfilename, strlen(tmpfilename));
    tmpopt[strlen(tmpfilename)]='\0';
  }
  strncpy(cmdline, GCC, 1024);
  for (i=0; i < gccoptionsc; i++) {
    strncat(cmdline, " ", 1024-strlen(cmdline));
    strncat(cmdline, gccoptionsv[i], 1024-strlen(cmdline));
    if (strstr(gccoptionsv[i], "-S")) {
      strncpy(tmpcmdline, "cp ", 1024);
      strncat(tmpcmdline, gccoptionsv[gccoptionsc-1], 1024-strlen(tmpcmdline));
      strncat(tmpcmdline, " ", 1024-strlen(tmpcmdline));
      strncat(tmpcmdline, outputfile, 1024-strlen(tmpcmdline));
      if (system(tmpcmdline)) {
        fprintf(stderr, "Shield G++: Cannot link\n");
        cleartemp(tmpfilesc, tmpfilesv);
        exit(EXIT_FAILURE);
      }
      cleartemp(tmpfilesc, tmpfilesv);
      exit(EXIT_SUCCESS);
    }
  }
  for (i=0; i < headerfilesc; i++) {
    strncat(cmdline, " ", 1024-strlen(cmdline));
    strncat(cmdline, headerfilesv[i], 1024-strlen(cmdline));
  }
  if (outputfile) {
    strncat(cmdline, " -o ", 1024-strlen(cmdline));
    strncat(cmdline, outputfile, 1024-strlen(cmdline));
  }
  if (system(cmdline)) {
    fprintf(stderr, "Shield G++: Cannot link\n");
    cleartemp(tmpfilesc, tmpfilesv);
    exit(EXIT_FAILURE);
  }

  cleartemp(tmpfilesc, tmpfilesv);
  exit(EXIT_SUCCESS);
}

