/*****************************************/
/* Stack Shield 0.7                      */
/* by Vendicator 1999-2000               */
/*****************************************/
/* File: globalretstack.h                */
/* Stack Shield global RET stack include */
/*****************************************/

const char grsheader[] = 
"#-----------------------------------------\n"
".data\n"
".comm retptr,4,4\n"
".comm rettop,4,4\n"
".comm retarray,<BUFFSIZE>,4\n"
"#-----------------------------------------\n";

const char grsprolog[] =
"#-----------------------------------------\n"
"        pushl %eax\n"
"        pushl %edx\n"
"        movl retptr,%eax\n"
"        cmpl %eax,rettop\n"
"        jbe .LSHIELDPROLOG<PROLOGCOUNT>\n"
"        movl 8(%esp),%edx\n"
"        movl %edx,(%eax)\n"
".LSHIELDPROLOG<PROLOGCOUNT>:\n"
"        addl $4,retptr\n"
"        popl %edx\n"
"        popl %eax\n"
"#-----------------------------------------\n";

const char grsepilog[] =
"#-----------------------------------------\n"
"        pushl %eax\n"
"        pushl %edx\n"
"        addl $-4,retptr\n"
"        movl retptr,%eax\n"
"        cmpl %eax,rettop\n"
"        jbe .LSHIELDEPILOG<EPILOGCOUNT>\n"
"        movl (%eax),%edx\n"
"        movl %edx,8(%esp)\n"
".LSHIELDEPILOG<EPILOGCOUNT>:\n"
"        popl %edx\n"
"        popl %eax\n"
"#-----------------------------------------\n";

const char grsmainprolog[] =
"#-----------------------------------------\n"
"        movl $retarray,retptr\n"
"        movl $retarray,rettop\n"
"        addl $<BUFFSIZE>,rettop\n"
"#-----------------------------------------\n";

const char grsdetectattackepilog[] =
"#-----------------------------------------\n"
"        pushl %eax\n"
"        pushl %edx\n"
"        addl $-4,retptr\n"
"        movl retptr,%eax\n"
"        cmpl %eax,rettop\n"
"        jbe .LSHIELDEPILOG<EPILOGCOUNT>\n"
"       movl (%eax),%edx\n"
"       cmpl %edx,8(%esp)\n"
"	je .LSHIELDEPILOG<EPILOGCOUNT>\n"
"	movl $1,%eax\n"
"	movl $-1,%ebx\n"
"	int $0x80\n"
".LSHIELDEPILOG<EPILOGCOUNT>:\n"
"        popl %edx\n"
"        popl %eax\n"
"#-----------------------------------------\n";

const char grsanticrashprolog[] =
"#-----------------------------------------\n"
"        pushl %eax\n"
"        pushl %edx\n"
"	cmpl $0xFFFFFFFF,retptr\n"
"	je .LSHIELDANTICRASHPROLOG<PROLOGCOUNT>\n"
"       movl retptr,%eax\n"
"       cmpl %eax,rettop\n"
"       jbe .LSHIELDPROLOG<PROLOGCOUNT>\n"
"       movl 8(%esp),%edx\n"
"       movl %edx,(%eax)\n"
".LSHIELDPROLOG<PROLOGCOUNT>:\n"
"       addl $4,retptr\n"
".LSHIELDANTICRASHPROLOG<PROLOGCOUNT>:\n"
"        popl %edx\n"
"        popl %eax\n"
"#-----------------------------------------\n";

const char grsanticrashepilog[] =
"#-----------------------------------------\n"
"	cmpl $0xFFFFFFFF,retptr\n"
"	je .LSHIELDEPILOG<EPILOGCOUNT>\n"
"#-----------------------------------------\n";

