#include "dkbfuser.h"

struct user_struct *
malloc_user_struct ()
{
  struct user_struct *tmp;

  tmp = (struct user_struct *) malloc (sizeof (struct user_struct));

  if (tmp == NULL)
    {
      fprintf (stderr, "failed to malloc user_struct\n");
      MPI_Abort (MPI_COMM_WORLD, 1);
    }

  memset (tmp, '\0', sizeof (tmp));

  return tmp;
}
MPI_Datatype *
CommitUserInfo ()
{
  MPI_Datatype       *pUserInfo;
  MPI_Datatype       *lUserInfo;

  struct user_struct masterarray;
  int                base;
  int                x;

  int bl[USERINFO_NBLOCKS] = { USERNAMESIZE,
			       LMHASHSIZE,
			       NTHASHSIZE,
			       LMHASHBSIZE,
			       NTHASHBSIZE,
			       FOOSIZE,
			       BARSIZE,
			       LMPASSWDSIZE,
			       NTPASSWDSIZE,
			       LMRESP_BSIZE,
			       NTRESP_BSIZE,
			       FIRST_HALFSIZE,
			       SECOND_HALFSIZE,
			       LMDONESIZE,
			       NTDONESIZE,
			       PWDUMPVALSIZE,
			       SERVER_CHALLSIZE,
			       ALREADY_PRINTEDSIZE, 
			       UNDER7SIZE,
			       PREVIOUSSIZE,
			       NEXTSIZE};

  MPI_Aint disp[USERINFO_NBLOCKS];

  MPI_Datatype types[USERINFO_NBLOCKS] = { MPI_CHAR,
					   MPI_CHAR,
					   MPI_CHAR,
					   MPI_CHAR,
					   MPI_UNSIGNED_LONG,
					   MPI_CHAR,
					   MPI_CHAR,
					   MPI_CHAR,
					   MPI_CHAR,
					   MPI_CHAR,
					   MPI_CHAR,
					   MPI_CHAR,
					   MPI_CHAR,
					   MPI_INT,
					   MPI_INT,
					   MPI_INT,
					   MPI_CHAR,
					   MPI_INT,
					   MPI_INT,
					   MPI_LONG,
					   MPI_LONG
  };

  lUserInfo = (MPI_Datatype *) malloc (sizeof (MPI_Datatype));

  MPI_Address (&masterarray, disp);
  MPI_Address (&masterarray.lmhash, &disp[1]);
  MPI_Address (&masterarray.nthash, &disp[2]);
  MPI_Address (&masterarray.lmhashb, &disp[3]);
  MPI_Address (&masterarray.nthashb, &disp[4]);
  MPI_Address (&masterarray.foo, &disp[5]);
  MPI_Address (&masterarray.bar, &disp[6]);
  MPI_Address (&masterarray.lmpasswd, &disp[7]);
  MPI_Address (&masterarray.ntpasswd, &disp[8]);
  MPI_Address (&masterarray.lmresp_b, &disp[9]);
  MPI_Address (&masterarray.ntresp_b, &disp[10]);
  MPI_Address (&masterarray.first_half, &disp[11]);
  MPI_Address (&masterarray.second_half, &disp[12]);
  MPI_Address (&masterarray.lmdone, &disp[13]);
  MPI_Address (&masterarray.ntdone, &disp[14]);
  MPI_Address (&masterarray.pwdumpval, &disp[15]);
  MPI_Address (&masterarray.server_chall, &disp[16]);
  MPI_Address (&masterarray.already_printed, &disp[17]);
  MPI_Address (&masterarray.under7, &disp[18]);
  MPI_Address (&masterarray.previous, &disp[19]);
  MPI_Address (&masterarray.next, &disp[20]);


  /*make offsets relative to begining of struct */
  base = disp[0];
  for (x = 0; x < USERINFO_NBLOCKS; x++)
    disp[x] -= base;


  /* define new MPI data type */
  MPI_Type_struct (USERINFO_NBLOCKS, bl, disp, types, lUserInfo);
  MPI_Type_commit (lUserInfo);

  pUserInfo = (MPI_Datatype *) malloc (sizeof (MPI_Datatype));

  if (pUserInfo == NULL)
    {
      printf ("malloc failed in UserInfo commit\n");
      MPI_Abort (MPI_COMM_WORLD, 0);
    }

  pUserInfo = lUserInfo;

  return pUserInfo;
}
