#include "dkbffile.h"

int
fileexists (char *filename)
{
  int   ret = 0;
  FILE  *fp;

  fp = fopen (filename, "r");

  if (fp)
    {
      ret = 1;
      fclose (fp);
    }

  return ret;
}

FILE *
jobfopen (char *jobname, char *basename, char *flags)
{
  char  *temp;
  FILE  *fp;

  temp = (char *) malloc (MAX_WORD * (sizeof (char)));

  if (!temp)
    {
      logger (0, 1, 0, stdout,
	      "Fatal Error:  Could not malloc memory in jobfopen()");
      MPI_Abort (MPI_COMM_WORLD, 0);
    }

  memset (temp, '\0', MAX_WORD);
  sprintf (temp, "%s_%s", jobname, basename);

  if ((fp = fopen (temp, flags)) == NULL)
    {
      logger (0, 1, 0, stdout, "Fatal Error:  Failed to open %s", temp);
      MPI_Abort (MPI_COMM_WORLD, 0);
      free (temp);
    }

  free (temp);

  return fp;
}
/*
int main()
{
  FILE *fp;
  fp = jobfopen("job1", "master.log", "w");
  fprintf(fp, "test");
  fclose(fp);
  return 0;
}
*/
