#ifndef _DKBF_BLOCKQ_H
#define _DKBF_BLOCKQ_H

#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <stdlib.h>

#include "dkbfblock.h"
#include "dkbfconfig.h"
#include "dkbfkeygen.h"


struct blocknode
{
  BLOCK *block;
  int filled;
  struct blocknode *next;
};

typedef struct blocknode BLOCKNODE;

BLOCKNODE *newblocknode ();

BLOCKNODE *add_blocknode (BLOCK s_block, BLOCKNODE * head);

BLOCKNODE *remove_blocknode (long double start, BLOCKNODE * head);

int free_block_list (BLOCKNODE * head);

int print_list (BLOCKNODE * head);

BLOCKNODE * get_next_block (CONFIG * Config, STATUS * jobstatus,
			    BLOCK * s_block, BLOCKNODE * blockq, int *expired);

int get_expired_block (BLOCKNODE * blockq, long maxworkingtime,
		       BLOCKNODE * expiredblock);


#endif
