/*
   MDCrack.c
   MD5 hash collision bruteforce

   *******************************************
   derived from the RSA Data
   Security, Inc. MD5 Message-Digest Algorithm
   *******************************************

   Try every passwords up to 8 chars length.
   Usefull to crack authentication protocols using paswords MD5 hash.
   Use it only to validate a new password choice/something like that 
   and nothing illegal.

   Author: Gregory Duchemin 
   Email : c3rb3r@hotmail.com 
   www : http://mdcrack.multimania.com

   Version 0.1   Date: 21 Feb 2001.
   Version 0.2   Date: 03 Mar 2001.
   Version 0.3   Date: 05 Mar 2001.
   Version 0.4   Date: 07 Mar 2001.
   Version 0.5   Date: 08 Mar 2001.
   Version 0.6   Date: 14 Mar 2001.
*/


#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <sys/timeb.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include "generic.h"



void hashprint(unsigned int *);

unsigned int count;
unsigned int verbosity=0;
unsigned int benchmode=0;
unsigned int duration=0;
unsigned int custom=0;
unsigned int all=0;
unsigned int ender=0;
unsigned int beginer=0;
int counter=0;
time_t elapsed;
short elapsed_u;
char target[33];
int crack();
int crack_end();
int crack_verbose();
char *alfa;
char *test;
char *total;
extern int optind;
extern char *optarg;
extern void Decode(unsigned int *, unsigned char *, int);
extern void Encode(unsigned char *, unsigned int *, int);
time_t start;
unsigned short start_u;
char *begin;
char *end;


void handle()
{
 FILE *des;
 struct timeb *ft;
 unsigned long diff;

 ft=(struct timeb *) malloc(sizeof(struct timeb));
 ftime(ft);
 elapsed=(ft->time)-start;
 elapsed_u=(ft->millitm)-start_u;
 if (!elapsed_u)
  {
   printf("\n**********************************************\nCollision found ! => %s\n", total);  
   printf("\n\nCollision found in less than 1 millisecond\nnot enough for statistics report..sorry.\n\n");
   fflush(stdout);
  }
 else
  {

if (elapsed_u < 0)
	{
	 elapsed_u=1000+elapsed_u;
         if (elapsed>0) elapsed--;
	}

 diff=(elapsed*1000)+elapsed_u;
if (!benchmode)
{
 des=fopen("/tmp/.mdcrack.resume", "w+");
 if (des)
  {
   fprintf(des, "%s %s %d %d %s", target, total, verbosity, custom, alfa+1);
   fclose(des);
  }
 printf("\n\nGenerating resume file /tmp/.mdcrack.resume");
}
if (benchmode)
 printf("\nBenchmark result."); 
 printf("\n###########################################\n%s <-- string \nCollision(s) tested : %u in %u second(s), %u millisec.\nAverage of %u tests/sec.\n\n", total, count, elapsed, elapsed_u, (unsigned int) ((double) (count/diff))*1000);

 fflush(stdout);
}
 exit (0);
}




void usage(void)
{
 printf("\nMDCrack version 0.6\nT00l to bruteforce password MD5 hashes.\n\nUsage: MDCrack [-h] [-v] [-b randomizer] [-e randomizer] [-t secs] [-a] [-s string] [digest] \n-h : (h)elp, this text\n-v : set (v)erbose mode\n-b : string to concatenate (b)efore passwords.\n-e : string to concatenate at passwords (e)nd.\n-t : Benchmark mode (t)imer, compute during secs seconds\n-a : find (a)ll collisions (won't stop to the first found)\n-s : feed a custom charset (s)tring\nNo option at all will force mdcrack to resume a previously stopped session\n\nAuthor: Gregory Duchemin [ c3rb3r@hotmail.com / http://mdcrack.multimania.com ]\n\n*******************************************\nderived from the RSA Data Security Inc.\nMD5 Message-Digest Algorithm\n*******************************************\n\n");
}



int main (argc, argv)
     int argc;
     char *argv[];
{
  int i;
  int found;
  FILE *des1;
  char c;
  char resume[9];
  char value[33];

  bzero(resume, 9);
  bzero(value, 33);
  alfa=(char *)malloc(64);
  strcpy(alfa+1, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
  *alfa='\0';


 if (argc==1) 
  {
   if ((des1=fopen("/tmp/.mdcrack.resume", "r")) == NULL )
    {
     usage();
     printf("\n\nError: No resume file found. \n\n");
     exit(0); 
    }
  fscanf(des1, "%32s %8s %d %d %s", value, resume, &verbosity, &custom, alfa+1);
  printf("\n\n/tmp/.mdcrack.resume file exist !\nresuming last session..... \n       ( hash: %s last try: %s)\n\n", value, resume);
  fflush(stdout); 
  sleep(2);
  if (!(found=crack(value, resume)))
   {
    printf("\nsorry, did not succeed to find at least one collision.\n\n");
    return(1);
   }
  return(0);  
 }


  while(1)
  {
  c=getopt(argc, argv, "hvas:t:b:e:");
  if (c==-1)
	 break;

  switch(c)
  {
      case 't':
      benchmode=1;
      duration=atoi(optarg); 
      break;

      case 'h':
      usage(); 
      exit(0);
      break;

      case 'v':
      verbosity=1;
      break;

      case 'b':
      begin=(char *)malloc(strlen(optarg)+1);
      strcpy(begin, optarg);
      beginer=1;
      break;

      case 'e':
      end=(char *)malloc(strlen(optarg)+1);
      strcpy(end, optarg);
      ender=1;
      break;

      case 'a':
      all=1;
      break;

      case 's':
      custom=1;
      realloc(alfa, strlen(optarg)+2);
      strcpy(alfa+1, optarg); 
      *(alfa)='\0';
      break;

      case '?':
      usage();
      exit(0);
      break;

      default:
      usage();
      break;
  }
  }
  
if (benchmode)
   {
    crack("ffffffffffffffffffffffffffffffff", resume);
    return (0);
   }

if (optind+1<=argc)
 {
   if (strlen(*(argv+optind)) != 32)
    {
      printf("\n\nnot a md5 digest....must have 16 bytes length (32 ascii digits from 0 to F).\n\n");
      return(1);
    }
   if (custom) 
    { 
     printf("\n\nUsing custom string : %s \n\n", alfa+1);
     sleep(2);
    }
   if (verbosity)
    {
     if (!(found=crack_verbose(*(argv+optind), resume)))
      {
      printf("\nsorry, did not succeed to find at least one collision.\n\n");
      return(1);
      }  
     return (0);
    }

 if (!ender)
   {
   if (!(found=crack(*(argv+optind), resume)))
   {
    printf("\nsorry, did not succeed to find at least one collision.\n\n");
    return(1);
   }  
   return(0);
  }
  else
  {
   if (!(found=crack_end(*(argv+optind), resume)))
   {
    printf("\nsorry, did not succeed to find at least one collision.\n\n");
    return(1);
   }  
    return (0);
  }
 }
 else
 {
  usage();
  exit(0);
 }

}



int ascii2bin(copy, conv, mov)
     char *copy;
     char *conv;
     char *mov;
{
  int i,j,k;
  for (i=0;i<32;i+=2)
    {
      j=0;
      while ((conv[j]!=(*copy)) && (j<16)) j++;
      k=0;
      while ((conv[k]!=(*(copy+1))) && (k<16)) k++;
      *mov= (char) ((j<<4) & 0xf0);
      *mov= (*mov)| (char) (k & 0x0f);
      copy+=2;
      mov++;
    }
  return(1);
}


int up2low(input)
     char *input;
{
  int i;
  for (i=0; i<32; i++)
    if ((*(input+i) >= 65) && (*(input+i) <= 70))
        *(input+i)=*(input+i)+32;
  return(1);
}


int crack(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  unsigned int b_offset=0, e_offset=0;
  char *mov;
  MD5_CTX context;
  char digest[16];
  unsigned int digest2[4];
  struct timeb *tp;
  struct timeb *ft;
  unsigned long diff;
 
  ft=(struct timeb *)malloc(sizeof(struct timeb));
  tp=(struct timeb *)malloc(sizeof(struct timeb)); 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;

    if (resume[0])
    {
     for (i=0; i<strlen(resume); i++)
       for (j=1;j<strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (!i)   h=alfa+j;
             if (i==1) g=alfa+j;
             if (i==2) f=alfa+j;
             if (i==3) e=alfa+j;
             if (i==4) d=alfa+j;
             if (i==5) c=alfa+j;
             if (i==6) b=alfa+j;
             if (i==7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  
  

  signal(SIGINT, handle);
  if (benchmode)
    {
     alarm(duration);
     signal(SIGALRM, handle);
    }
  ftime(tp);
  start=tp->time;
  start_u=tp->millitm;

  if (begin) b_offset=strlen(begin);
  if (end) e_offset=strlen(end); 
  test=(char *)malloc(9+b_offset+e_offset);
  if (!test)
   {
     printf("\n\n Malloc error.\n\n");
     exit(0);
   }
  total=test;
  bzero(test, 8+b_offset+e_offset);
  if (begin) 
   {
  strcpy(test, begin);
  test=test+strlen(begin);
   }
  
  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
				  *(context.count)=*(context.count+1)=0;
				  *(context.state)=0x67452301;
				  *(context.state+1)=0xefcdab89;
				  *(context.state+2)=0x98badcfe;
				  *(context.state+3)=0x10325476;
                                  MD5Update (&context, total, strlen(total));
                                  result2=MD5Final(&context);

                                  count++;
				  if ((*digest2==*result2)&&(*(digest2+1)==*(result2+1))&&(*(digest2+2)==*(result2+2))&&(*(digest2+3)==*(result2+3)))
				    {

                               ftime(ft);
                               elapsed=(ft->time)-start;
                               elapsed_u=(ft->millitm)-start_u;
                               if (!elapsed_u)
                                {
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                               printf("\n\nCollision found in less than 1 millisecond\nnot enough for statistics report..sorry.\n\n");
                               fflush(stdout);
                               if (!all)
			         return(1);
                                 }
                               else
                                {
                               if (elapsed_u < 0)
	                         {
	                          elapsed_u=1000+elapsed_u;
                                  if (elapsed>0) elapsed--;
	                         }
                               diff=(elapsed*1000)+elapsed_u;
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  

                              printf("\n\nCollision(s) tested : %u in %u second(s), %u millisec.\nAverage of %u tests/sec.\n\n", count, elapsed, elapsed_u, (unsigned int) ((double) (count/diff))*1000);
                                      fflush(stdout);
                                      if (!all)
				         return(1);
				    }
                                  }
				}
                              h=(char *)MIN;
			    }
                           g=(char *)MIN;
			}
                       f=(char *)MIN;
		    }
                   e=(char *)MIN;
		}
              d=(char *)MIN;
	    }
          c=(char *)MIN;
	}
      b=(char *)MIN;
    }

  return(0);

}



int crack_verbose(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  unsigned int b_offset=0, e_offset=0;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  char *mov;
  MD5_CTX context;
  char digest[16];
  unsigned int digest2[4];
  struct timeb *tp;
  struct timeb *ft;
  unsigned long diff;
 
  ft=(struct timeb *)malloc(sizeof(struct timeb));
  tp=(struct timeb *)malloc(sizeof(struct timeb)); 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;
    if (resume[0])
    {
     for (i=0; i<strlen(resume); i++)
       for (j=0;j<strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (!i)   h=alfa+j;
             if (i==1) g=alfa+j;
             if (i==2) f=alfa+j;
             if (i==3) e=alfa+j;
             if (i==4) d=alfa+j;
             if (i==5) c=alfa+j;
             if (i==6) b=alfa+j;
             if (i==7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  
  

  signal(SIGINT, handle);
  ftime(tp);
  start=tp->time;
  start_u=tp->millitm;

  
  if (begin) b_offset=strlen(begin);
  if (end) e_offset=strlen(end);
  test=(char *)malloc(9+b_offset+e_offset);
  if (!test)
   {
     printf("\n\n Malloc error.\n\n");
     exit(0);
   }

  total=(char *)malloc(9+b_offset+e_offset);
  bzero(test, 8+b_offset+e_offset);
  if (begin) 
  {
  strcpy(test, begin);
  test=test+strlen(begin);
  }



  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
				  *(context.count)=*(context.count+1)=0;
				  *(context.state)=0x67452301;
				  *(context.state+1)=0xefcdab89;
				  *(context.state+2)=0x98badcfe;
				  *(context.state+3)=0x10325476;
                                  strcpy(total, test);
                                  if (end)
                                     strcat(total, end);
                                  MD5Update (&context, total, strlen(total));
                                  result2=MD5Final(&context);
                                  printf("\n%s <-- string.\n",total);
                                  hashprint(result2);
                                  puts(" <-- hash.");  
                                  hashprint(digest2);
                                  puts(" <-- reference.\n\n");
                                  fflush(stdout);
                                  count++;

				  if ((*digest2==*result2)&&(*(digest2+1)==*(result2+1))&&(*(digest2+2)==*(result2+2))&&(*(digest2+3)==*(result2+3)))
				    {

                               ftime(ft);
                               elapsed=(ft->time)-start;
                               elapsed_u=(ft->millitm)-start_u;
                               if (!elapsed_u)
                                {
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                               printf("\n\nCollision found in less than 1 millisecond\nnot enough for statistics report..sorry.\n\n");
                               fflush(stdout);
                               if (!all)
			         return(1);
                                 }
                               else
                                {
                               if (elapsed_u < 0)
	                         {
	                          elapsed_u=1000+elapsed_u;
                                  if (elapsed>0) elapsed--;
	                         }
                               diff=(elapsed*1000)+elapsed_u;
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                               printf("\n\nCollision(s) tested : %u in %u second(s), %u millisec.\nAverage of %u tests/sec.\n\n", count, elapsed, elapsed_u, (unsigned int) ((double) (count/diff))*1000);

                                      fflush(stdout);
                                      if (!all)
				         return(1);
				    }
                                 }
				}
                              h=(char *)MIN;
			    }
                           g=(char *)MIN;
			}
                       f=(char *)MIN;
		    }
                   e=(char *)MIN;
		}
              d=(char *)MIN;
	    }
          c=(char *)MIN;
	}
      b=(char *)MIN;
    }

  return(0);

}


int crack_end(input, resume)
     char *input;
     char *resume;
{
  char conv[]="0123456789abcdef";
  register char *a,*b,*c,*d,*e,*f,*g,*h;
  unsigned int *result2;
  char *copy;
  register int MAX=(unsigned int) alfa+strlen(alfa+1)+1;
  register int MIN=(unsigned int) alfa+1; 
  unsigned char i,j; 
  unsigned int b_offset=0, e_offset=0;
  char *mov;
  MD5_CTX context;
  char digest[16];
  unsigned int digest2[4];
  struct timeb *tp;
  struct timeb *ft;
  unsigned long diff;
 
  ft=(struct timeb *)malloc(sizeof(struct timeb));
  tp=(struct timeb *)malloc(sizeof(struct timeb)); 
  bzero(digest, 16);
  mov=digest;
  copy=input;
  strncpy(target, input, 32);
  
    a=b=c=d=e=f=g=alfa;

    if (resume[0])
    {
     for (i=0; i<strlen(resume); i++)
       for (j=1;j<strlen(alfa+1);j++)
         if (resume[i]==alfa[j])
            { 
             if (!i)   h=alfa+j;
             if (i==1) g=alfa+j;
             if (i==2) f=alfa+j;
             if (i==3) e=alfa+j;
             if (i==4) d=alfa+j;
             if (i==5) c=alfa+j;
             if (i==6) b=alfa+j;
             if (i==7) a=alfa+j;
            }
    }
  else
    h=(char *)MIN;


  up2low(input);
  ascii2bin(copy, conv, mov);
  Decode(digest2, mov, 16);  
  

  signal(SIGINT, handle);
  if (benchmode)
    {
     alarm(duration);
     signal(SIGALRM, handle);
    }
  ftime(tp);
  start=tp->time;
  start_u=tp->millitm;

  if (begin) b_offset=strlen(begin);
  if (end) e_offset=strlen(end); 
  test=(char *)malloc(9+b_offset+e_offset);
  if (!test)
   {
     printf("\n\n Malloc error.\n\n");
     exit(0);
   }
  total=(char *)malloc(9+b_offset+e_offset);
  bzero(test, 8+b_offset+e_offset);
  if (begin) 
   {
  strcpy(test, begin);
  test=test+strlen(begin);
   }
     
  for(;a<(char *)MAX;a++)
    {
       *(test+7)=*a;
      for(;b<(char *)MAX;b++)
	{
	  *(test+6)=*b;
	  for(;c<(char *)MAX;c++)
	    {
	      *(test+5)=*c;
	      for(;d<(char *)MAX;d++)
		{
		  *(test+4)=*d;
		  for(;e<(char *)MAX;e++)
		    {
		      *(test+3)=*e;
		      for(;f<(char *)MAX;f++)
			{
			  *(test+2)=*f;
			  for(;g<(char *)MAX;g++)
			    {
			      *(test+1)=*g;
			      for(;h<(char *)MAX;h++)
				{
				  *test=*h;
				  *(context.count)=*(context.count+1)=0;
				  *(context.state)=0x67452301;
				  *(context.state+1)=0xefcdab89;
				  *(context.state+2)=0x98badcfe;
				  *(context.state+3)=0x10325476;
                                  strcpy(total, test);
                                  strcat(total, end);
                                  MD5Update (&context, total, strlen(total));
                                  result2=MD5Final(&context);

                                  count++;
				  if ((*digest2==*result2)&&(*(digest2+1)==*(result2+1))&&(*(digest2+2)==*(result2+2))&&(*(digest2+3)==*(result2+3)))
				    {

                               ftime(ft);
                               elapsed=(ft->time)-start;
                               elapsed_u=(ft->millitm)-start_u;
                               if (!elapsed_u)
                                {
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  
                               printf("\n\nCollision found in less than 1 millisecond\nnot enough for statistics report..sorry.\n\n");
                               fflush(stdout);
                               if (!all)
			         return(1);
                                 }
                               else
                                {
                               if (elapsed_u < 0)
	                         {
	                          elapsed_u=1000+elapsed_u;
                                  if (elapsed>0) elapsed--;
	                         }
                               diff=(elapsed*1000)+elapsed_u;
		               printf("\n**********************************************\nCollision found ! => %s\n", total);  

                              printf("\n\nCollision(s) tested : %u in %u second(s), %u millisec.\nAverage of %u tests/sec.\n\n", count, elapsed, elapsed_u, (unsigned int) ((double) (count/diff))*1000);
                                      fflush(stdout);
                                      if (!all)
				         return(1);
				    }
                                  }
				}
                              h=(char *)MIN;
			    }
                           g=(char *)MIN;
			}
                       f=(char *)MIN;
		    }
                   e=(char *)MIN;
		}
              d=(char *)MIN;
	    }
          c=(char *)MIN;
	}
      b=(char *)MIN;
    }

  return(0);

}


void hashprint (digest)
unsigned int digest[4];
{
  int i;

  for (i = 0; i < 4; i++)
    printf ("%x", digest[i]);
}
