#include "dkbfrulez.h"

/*
  Maxrepeat_count: the greatest number of times 
  one letter was repeated - not case sensitive;

  Maxdupe_count: the number of letters that were
  used more than once - not case sensitive
*/

/* return 1 to eliminate; 0 to keep; 
   written for speed */
int
EliminateByRule (CONFIG * Config, char *brute)
{
  register int x = 0;
  int          a_profile[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
  int          passfilt_count = 0;
  int          c = 0;
  int          repeat; 
  int          max = 1;
  int          len;
  int          dupes = 0;
  int          flag = 1;
  char         tchar;
  char         tbrute[32] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


  len = strlen (brute); 

  if (len > Config->maxpasswdlen || len < Config->minpasswdlen)
    return 1;

  /* build a profile on the brute string */
  for (x = 0; x < len; x++)
    {
      /* uppercase */
      if (brute[x] >= 0x41 && brute[x] <= 0x5A)
	{
	  a_profile[UPPER]++;
	  /* vowel or consonant; y is a vowel */
	  if (brute[x] == 0x61 || brute[x] == 0x65 || brute[x] == 0x69 ||
	      brute[x] == 0x6F || brute[x] == 0x75 || brute[x] == 0x79 ||
	      brute[x] == 0x41 || brute[x] == 0x45 || brute[x] == 0x49 ||
	      brute[x] == 0x4F || brute[x] == 0x55 || brute[x] == 0x59)
	    a_profile[VOWELS]++;
	  else
	    a_profile[CONSONANTS]++;
	}
      /* lowercase */
      else if (brute[x] >= 0x61 && brute[x] <= 0x7A)
	{
	  a_profile[LOWER]++;
	  /* vowel or consonant; y is a vowel */
	  if (brute[x] == 0x61 || brute[x] == 0x65 || brute[x] == 0x69 ||
	      brute[x] == 0x6F || brute[x] == 0x75 || brute[x] == 0x79 ||
	      brute[x] == 0x41 || brute[x] == 0x45 || brute[x] == 0x49 ||
	      brute[x] == 0x4F || brute[x] == 0x55 || brute[x] == 0x59)
	    a_profile[VOWELS]++;
	  else
	    a_profile[CONSONANTS]++;
	}
      else			/* numeric or special char */
	{
	  if (brute[x] >= 0x30 && brute[x] <= 0x39)
	    {
	      a_profile[NUMERIC]++;
	      continue;
	    }
	  a_profile[SPECCHAR]++;
	}
    }
  /* eliminate if passfilt.dll was used */
  if (Config->passfilt_dll)
    {
      if (len < 6)
	return 1;
      if (a_profile[UPPER] > 0)
	passfilt_count++;
      if (a_profile[LOWER] > 0)
	passfilt_count++;
      if (a_profile[NUMERIC] > 0)
	passfilt_count++;
      if (a_profile[SPECCHAR] > 0)
	passfilt_count++;
      if (passfilt_count < 3)
	return 1;
    }

  if (a_profile[UPPER] > Config->maxuppercase ||
      a_profile[UPPER] < Config->minuppercase)
    return 1;

  if (a_profile[LOWER] > Config->maxlowercase ||
      a_profile[LOWER] < Config->minlowercase)
    return 1;

  if (a_profile[SPECCHAR] > Config->maxspecchar ||
      a_profile[SPECCHAR] < Config->minspecchar)
    return 1;

  if (a_profile[NUMERIC] > Config->maxnumeric ||
      a_profile[NUMERIC] < Config->minnumeric)
    return 1;

  if (a_profile[CONSONANTS] > Config->maxconsonants ||
      a_profile[CONSONANTS] < Config->minconsonants)
    return 1;

  if (a_profile[VOWELS] > Config->maxvowels ||
      a_profile[VOWELS] < Config->minvowels)
    return 1;

  /* compute the max times any one letter was used */
  if (Config->maxrepeat_count != NOMAX)
    {

      for (x = 0; x < len; x++)
	tbrute[x] = _TOLOWER (brute[x]);
      for (x = 0; x < len; x++)
	{
	  repeat = 1;
	  tchar = tbrute[x];
	  for (c = x + 1; c < len; c++)
	    {
	      if (tchar == tbrute[c])
		repeat++;
	    }
	  max = repeat > max ? repeat : max;
	}
      if (Config->maxrepeat_count < max)
	return 1;
    }

  /* compute how many letters are repeated */
  if (Config->maxdupes_count != NOMAX)
    {

      for (x = 0; x < len; x++)
	tbrute[x] = _TOLOWER (brute[x]);

      for (x = 0; x < len; x++)
	{
	  if (tbrute[x] != '\0')
	    {
	      tchar = tbrute[x];
	    }
	  else
	    {
	      continue;
	    }
	  tbrute[x] = '\0';
	  for (c = x + 1; c < len; c++)
	    {
	      if (tbrute[c] == tchar)
		{
		  if (flag)
		    dupes++;
		  tbrute[c] = '\0';
		  flag = 0;
		}
	    }
	  flag = 1;
	}
      if (Config->maxdupes_count < dupes)
	return 1;
    }
  return 0;
}
