#ifndef _DKBF_MASTER_H
#define _DKBF_MASTER_H

#include <mpi.h>
#include <stdio.h>
#include <time.h>
#include <memory.h>
#include <malloc.h>
#include <stdlib.h>

#include "dkbfincludes.h"
#include "dkbfblock.h"
#include "dkbfconfig.h"
#include "dkbfkeygen.h"
#include "dkbflogging.h"
#include "dkbffile.h"
#include "dkbfblock.h"
#include "dkbfblockq.h"
#include "dkbfuser.h"
#include "dkbfgetaccts.h"

int master (CONFIG *Config);
void log_job_time(STATUS *jobstatus, CONFIG *Config, FILE *masterlog);

// Linked list routines from
extern struct user_struct *setup_linked_list (int, FILE * pwlist,
					      FILE * outlist);
extern void free_struct_list (struct user_struct *index);
extern struct user_struct *remove_from_list (struct user_struct *record);

// User account management routines
extern int count_users (struct user_struct *head);
extern struct user_struct *cp_list_to_array (struct user_struct *head,
					 int usercount);
extern struct user_struct *get_struct (char *username,
				       struct user_struct *head);
extern void print_user (struct user_struct *Ustruct, FILE * file);
extern void sync_accounts (struct user_struct *cracked_acct,
			   struct user_struct *tmp_acct);

#endif
