#include "dkbflogging.h"

int
bench (long end, long begin, char *buffer)
{

  long   mytime = 0;
  long   milliseconds = 0;
  long   seconds = 0; 
  long   minutes = 0;
  long   hours = 0;

  memset (buffer, '\0', sizeof (buffer));

  if (end == 0)
    time (&end); /* allows passing of 0 in the "end"*/ 

  mytime = end - begin;

  if (mytime < 0)
    {
      printf ("Recorded Time was a Negative Number\n");
      return 0;
    }
  if (mytime >= 3600)
    {
      hours = mytime / 3600;
      mytime -= 3600 * hours;
    }
  if (mytime >= 60)
    {
      minutes = mytime / 60;
      mytime -= 60 * minutes;
    }
  if (mytime >= 1)
    {
      seconds = mytime / 1;
      mytime -= 1 * seconds;
    }
  milliseconds = mytime;

  sprintf (buffer, "TIME: %02ld:%02ld:%02ld.%03ld",
	   hours, minutes, seconds, milliseconds);

  if (hours > 0)
    strcat (buffer, " hrs");
  else if (minutes > 0)
    strcat (buffer, " mins");
  else if (seconds > 0)
    strcat (buffer, " secs");
  else
    strcat (buffer, " ms");

  return 0;
}
int
timestamp (char *buffer)
{
  char   str_time[256];
  time_t current_time;

  memset (str_time, '\0', sizeof (str_time));
  memset (buffer, '\0', sizeof (buffer));
  time (&current_time);

  strcpy (str_time, ctime (&current_time));
  str_time[24] = '\0';
  sprintf (buffer, "[%s] ", str_time);

  return 0;
}
int
logger (int ConfigLogLevel, int thisStmtIOLevel, int dualoutput,
	FILE * fp, char *format, ...)
{
  va_list args;
  va_list args2;
  char    buffer[256];

  timestamp (buffer);

  if (dualoutput)
    fprintf (stderr, "%s", buffer);

  if (dualoutput)
    {
      va_start (args2, format);
      vfprintf (stderr, format, args2);
      va_end (args2);
    }
  fflush (stderr);

  if (ConfigLogLevel < thisStmtIOLevel)
    return 0;

  fprintf (fp, buffer);
  va_start (args, format);
  vfprintf (fp, format, args);
  va_end (args);
  fflush (fp);
  return 0;
}

/*
int main()
{
  FILE *fp = stdout;
  FILE *out;
  int x = 10;
  char buffer[256];
  timestamp(buffer);
  printf("%s\n", buffer);

  out = fopen("logger.test2", "w");
  logger(int logginglevel, int level, int dualoutput, FILE * fp, char *fmt, ...)
  logger(1, 1, SINGLEOUTPUT, fp, "%s  %s  %s %d \n", 
         "This only", "for", "console", x);
  logger(1, 1, DUALOUTPUT, out, "%s  %s  %s %d \n", 
         "this is for", "both", "f and c", x);
  fclose(out);
  return 0; 
}
*/
