#ifndef _DKBF_CONFIG_H
#define _DKBF_CONFIG_H

#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>
#include <mpi.h>
#include <time.h>
#include <unistd.h>

#include "dkbfincludes.h"
#include "dkbflogging.h"
#include "dkbfblock.h"
#include "dkbffile.h"

#define CONFIG_NBLOCKS          36
#define CONFIG_MAXWORDSIZE      MAX_WORD
#define CONFIG_ONEINTSIZE	1
#define CONFIG_MAXSTRINGSIZE	MAX_STRING
#define CONFIG_ONEDOUBLESIZE	1
#define CONFIG_ONELONGSIZE	1

#define NOMAX       512
#define NOMIN       0

struct config
{
  char          pwlist[MAX_WORD];
  char          masterlog[MAX_WORD];
  char          slavelog[MAX_WORD];
  char          cracklog[MAX_WORD];
  char          jobname[MAX_WORD];	//5
  char          characterset[MAX_STRING];
  char          mustcontain[MAX_STRING];	//7

  int           algorithm;
  int           charsetnum;
  int           charsetlen;
  int           loop;
  int           logginglevel;
  int           pwdump;			//13
  long          blockexpiration;
  long double   blocksize;
  int           slavepriority;
  int           sleepstagger;		//17
  int           passwordfilter;		//18
  int           minuppercase;
  int           maxuppercase;
  int           minlowercase;
  int           maxlowercase;
  int           minpasswdlen;
  int           maxpasswdlen;
  int           minnumeric;		//25
  int           maxnumeric;
  int           minvowels;
  int           maxvowels;
  int           minconsonants;
  int           maxconsonants;
  int           minspecchar;
  int           maxspecchar;		//32
  int           maxrepeat_count;
  int           maxdupes_count;		//34
  int           passfilt_dll;
  int           slavelogging;		//36
};

typedef struct config CONFIG;

struct status
{
  unsigned long *noderates;
  float         percent_done;
  int           size;
  float         ttl_rate;
  long double   ttl_keys;
  long double   first_key;
  long double   last_key;
  long double   keys_done;
  time_t        begin;
  time_t        end;
  time_t        remaining;
  int           slaves;
  int           usercount;
};

typedef struct status STATUS;

/* get opts */
int dkbf_getopts(int argc, char **argv, CONFIG *Config);

/* read the options from the ini file */
int readini (char *inifile, CONFIG * config);

/* verify chosen character set is has 3 of the following:
   upper, lower, numeric, special char, so that it is a 
   passfilt.dll compliant characterset */
int passfilt_compliant(char *characterset);

/* error checking on config options */
int validate_config (CONFIG * Config);

/* check to see if character set has any lowercase letters */
int charset_has_lowercase (CONFIG * Config);

/* count duplicate characters */
int count_dupes(char *brute);

/* commit global *pConfig to an MPI datatype */
MPI_Datatype *CommitConfig ();

/* log job configuration to master log file */
int log_job_configurations (CONFIG * Config, FILE * masterlog,
			    STATUS * jobstatus);

int initialize_status (STATUS * status, CONFIG * Config, int size);

int free_rates (unsigned long *noderates);

int clear_rates (STATUS * status);

int track_keyrate (int node, BLOCK * s_block, STATUS * jobstatus,
		  FILE * masterlog, CONFIG *Config);

int set_first_last_key (STATUS * status, CONFIG *Config);

extern long double get_ttlkeys (CONFIG *Config);
extern long double get_first_key (CONFIG *Config);
extern char *chomp (char *string);
extern int logger (int logginglevel, int level, int dualoutput, FILE * fp, 
		   char *fmt,...);

#endif
