#include <stdio.h>
#include <ctype.h>
#define LINE_SIZE 500
typedef unsigned char      byte;    /* type of 8 bit unsigned quantity */
typedef unsigned short     Bit16u;  /* type of 16 bit unsigned quantity */
typedef unsigned long      Bit32u;  /* type of 32 bit unsigned quantity */
byte fr=0;

byte scan2ascii(byte car)
{
static const byte tbl_fr[255]=
{ ' ',' ','1','2','3','4','5','6',
  '7','8','9','0',')','=',' ',' ',
  'A','Z','E','R','T','Y','U','I',     /* 10 */
  'O','P',' ','$',' ',' ','Q','S',     /* 18 */
  'D','F','G','H','J','K','L','M',     /* 20 */
  '%','',' ','*','W','X','C','V',
  'B','N',',',';',':','/',' ','*',     /* 30 */
  ' ',' ',' ','f','f','f','f','f',     /* F1 a F10 */
  'f','f','f','f','f',' ',' ','7',     /* 40 */
  '8','9','-','4','5','6','+','1',
  '2','3','0','.',' ',' ','>',' '};    /* 50 */

static const byte tbl_us[255]=
{ ' ',' ','1','2','3','4','5','6',
  '7','8','9','0','-','=',' ',' ',
  'Q','W','E','R','T','Y','U','I',     /* 10 */
  'O','P',' ','$',' ',' ','A','S',     /* 18 */
  'D','F','G','H','J','K','L',';',     /* 20 */
  '','`',' ','*','Z','X','C','V',
  'B','N','M',',','.','/','"','*',     /* 30 */
  ' ',' ',' ','f','f','f','f','f',     /* F1 a F10 */
  'f','f','f','f','f',' ',' ','7',     /* 40 */
  '8','9','-','4','5','6','+','1',
  '2','3','0','.',' ',' ','>',' '};    /* 50 */
/* start */
  if (car<0x58)
  {
    if (fr==1)
      return tbl_fr[car];
    else
      return tbl_us[car];
  }
  else
    return ' ';
}

byte ascii2scan(byte car)
{
  int i;
  for(i=0;i<256;i++)
    if(scan2ascii(i)==toupper(car))
      return i;
  return 0;
}

Bit16u do_tosh(Bit16u valcrc, byte car)
{
    register byte ah,al,dh,dl;
    al=(byte)valcrc;
    ah=valcrc>>8;
    ah^=car;
    dl=ah;
    dl<<=4;
    ah^=dl;
    dl=ah;
    dl>>=5;
    dl^=ah;
    dh=ah;
    ah<<=3;
    ah^=al;
    dh>>=4;
    ah^=dh;
    al=dl;
    return (ah<<8)|al;
}

int get_CRC(char *chaine)
{
  Bit16u valcrc=0;
  while(*chaine)
  {
    valcrc=do_tosh(valcrc, ascii2scan(*chaine));
	chaine++;
  }
  if(valcrc==0)
	valcrc++;
  return valcrc;
}

int test_liste(char* nom_wordlist, Bit16u valref)
{
  FILE *f_in;
  char ligne[LINE_SIZE];
  printf("Valref: %04X\n", valref);
  if((f_in=fopen(nom_wordlist,"r"))==NULL)
  {
    printf("\nUnable to open %s", nom_wordlist);
    return 1;
  }
//  while(fgets(ligne, LINE_SIZE, f_in)!=NULL)
  while(!feof(f_in) && (fscanf(f_in, "%s", ligne)!=0))
  {
    if(get_CRC(ligne)==valref)
      printf("\n->%s<-", ligne);
  }
  return fclose(f_in);
}

int main(int argnb, char **argv)
{
  if(argnb<3)
  {
    printf("Usage : brute wordlist password [/f]\n");
    return 1;
  }
  if(argnb>=4)
	fr=(strcmp(argv[3],"/f")==0);
  return test_liste(argv[1], get_CRC((argv[2])));
}
