library msgboxcliplug;


uses
  Windows,
  SysUtils,
  Classes,
  dialogs,
  clientplugin in 'clientplugin.pas',
  cliplugfrm in 'cliplugfrm.pas' {Form1};

procedure OnDisconnectedFromServer() ; stdcall;
begin
   if form1 <> nil then form1.Connected := false;
end;


procedure OnLoggedOnToServer(TargetIP : pchar; TargetPort , LocalPort : integer  ); stdcall;
begin
  if Form1 = nil then Form1 := TForm1.create(nil);
  Form1.ServerIP   := TargetIP;
  Form1.ServerPort := TargetPort;
  Form1.Connected := true;
end;


procedure OnDeactivateClientPlugin(); stdcall ;
begin
  if Form1 <> nil then Form1.hide;
end;


procedure OnActivateClientPlugin(); stdcall ;
begin
  if Form1 = nil then
   begin
     Form1 := TForm1.create(nil);
     form1.Connected := false;
   end;

  Form1.show;
end;


function GetPluginIdent(): pchar ; stdcall ;
begin
  result := 'MSGBX DEMO ID' + #0;
end;

procedure DLLEntryPoint(dwReason : DWord);
begin
  case dwReason of
    DLL_PROCESS_ATTACH:;
    DLL_PROCESS_DETACH:;
    DLL_THREAD_ATTACH: ;
    DLL_THREAD_DETACH: ;
  end;
end;


exports OnLoggedOnToServer , OnDisconnectedFromServer, GetPluginIdent , OnActivateClientPlugin , OnDeactivateClientPlugin;

begin
  DLLProc := @DLLEntryPoint;
  DLLEntryPoint(DLL_PROCESS_ATTACH);
end.
