unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ComCtrls, Spin,registry, ExtCtrls, jpeg,shellapi;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    f1: TSpinEdit;
    f2: TSpinEdit;
    f3: TSpinEdit;
    f4: TSpinEdit;
    f5: TSpinEdit;
    f6: TSpinEdit;
    f7: TSpinEdit;
    f8: TSpinEdit;
    f1l: TSpinEdit;
    f2l: TSpinEdit;
    f3l: TSpinEdit;
    f4l: TSpinEdit;
    f5l: TSpinEdit;
    f8l: TSpinEdit;
    f7l: TSpinEdit;
    f6l: TSpinEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    CheckBox1: TCheckBox;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    Label9: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    CheckBox2: TCheckBox;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    TabSheet3: TTabSheet;
    Image1: TImage;
    Label24: TLabel;
    Label25: TLabel;
    procedure CheckBox1Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure Edit4Change(Sender: TObject);
    procedure Edit5Change(Sender: TObject);
    procedure Edit6Change(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Edit7Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Label24Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  newname,filename:string;

const
  INTERNAL_IRCSRV ='IRCSRV:***************';
  INTERNAL_IRCPRT ='IRCPRT:*****';
  INTERNAL_IRCCHN ='IRCCHN:************************************************************';
  INTERNAL_IRCUSE ='IRCUSE:*';
  INTERNAL_FTPPRT ='FTPPRT:*****';
  INTERNAL_FTPMUS ='FTPMUS:**';
  INTERNAL_FTPUSR ='FTPUSR:***************';
  INTERNAL_FTPPWD ='FTPPWD:***************';

implementation

{$R *.DFM}

procedure REGWRITESTRING(key,name,value:string);
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  reg.WriteString(Key + #0, name, value);
  reg.Free;
end;

function REGREADSTRING(key,name:string):string;
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  REGREADSTRING:=reg.ReadString(key+#0,name,'');
  reg.Free;
end;

procedure REGWRITEINT(key,name:string; value:integer);
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  reg.WriteInteger(key+#0,name,value);
  reg.Free;
end;

function REGREADINT(key,name:string):integer;
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  REGREADINT:=reg.Readinteger(key+#0,name,0);
  reg.Free;
end;

procedure REGDELETEVALUE(key,name:string);
var
  reg  : TRegIniFile;
begin
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE ;
  reg.DeleteKey(key,name);
  reg.Free;
end;

function subst(mainstring,target,replace:string):string;
var
 bf,bf2,bf3,cm:string;
 ct:integer;

begin
 if mainstring=target then begin
  subst:=replace;
  exit;
 end;

 repeat

 cm:=mainstring;

 ct:=pos(target,mainstring);
 if ct=0 then begin
  subst:=mainstring;
  exit;
 end;

 if ct>1 then begin
  bf:=copy(mainstring,1,ct-1);
  bf2:=copy(mainstring,ct+length(target),length(mainstring)-ct+length(target)-1);
  bf3:=bf+replace+bf2;
 end else begin
  bf:='';
  bf2:=copy(mainstring,ct+length(target),length(mainstring)-ct+length(target)-1);
  bf3:=bf+replace+bf2;
 end;
 mainstring:=bf3;
 until cm=bf3;

 subst:=bf3;
end;

function READFIELD(filename:string;ofs,ln:longint):string;
var
 f:file of byte;
 bf:string;
 ct:longint;
 b:byte;

begin
 READFIELD:='FIELD READ ERROR!';
 assign(f,filename); {$I-} reset(f); {$I+} if ioresult<>0 then exit;
 seek(f,ofs);
 bf:='';

 for ct:=1 to ln do begin
  {$I-} read(f,b); {$I+} if ioresult<>0 then exit;
  bf:=bf+chr(b);
 end;

 closefile(f);

 READFIELD:=bf;
end;


procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 if checkbox1.checked then begin
  f1.enabled:=true; f1l.enabled:=true;
  f2.enabled:=true; f2l.enabled:=true;
  f3.enabled:=true; f3l.enabled:=true;
  f4.enabled:=true; f4l.enabled:=true;
  f5.enabled:=true; f5l.enabled:=true;
  f6.enabled:=true; f6l.enabled:=true;
  f7.enabled:=true; f7l.enabled:=true;
  f8.enabled:=true; f8l.enabled:=true;
 end else begin
  f1.enabled:=false; f1l.enabled:=false;
  f2.enabled:=false; f2l.enabled:=false;
  f3.enabled:=false; f3l.enabled:=false;
  f4.enabled:=false; f4l.enabled:=false;
  f5.enabled:=false; f5l.enabled:=false;
  f6.enabled:=false; f6l.enabled:=false;
  f7.enabled:=false; f7l.enabled:=false;
  f8.enabled:=false; f8l.enabled:=false;
 end;

end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
 edit1.maxlength:=f1l.value;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
 edit2.maxlength:=f2l.value;
end;

procedure TForm1.Edit3Change(Sender: TObject);
begin
  edit3.maxlength:=f3l.value;
end;

procedure TForm1.Edit4Change(Sender: TObject);
begin
 edit4.maxlength:=f5l.value;
end;

procedure TForm1.Edit5Change(Sender: TObject);
begin
 edit5.maxlength:=f6l.value;
end;

procedure TForm1.Edit6Change(Sender: TObject);
begin
 edit6.maxlength:=f7l.value;
end;

procedure TForm1.Open1Click(Sender: TObject);
var
 bf:string;

begin
 if not opendialog1.Execute then exit;
 filename:=opendialog1.filename;

 bf:=trim(subst(readfield(filename,f1.value,f1l.value),'*',' ')); if bf<>'' then edit1.text:=bf;
 bf:=trim(subst(readfield(filename,f2.value,f2l.value),'*',' ')); if bf<>'' then edit2.text:=bf;
 bf:=trim(subst(readfield(filename,f3.value,f3l.value),'*',' ')); if bf<>'' then edit3.text:=bf;

 bf:=trim(subst(readfield(filename,f5.value,f5l.value),'*',' ')); if bf<>'' then edit4.text:=bf;
 bf:=trim(subst(readfield(filename,f6.value,f6l.value),'*',' ')); if bf<>'' then edit5.text:=bf;
 bf:=trim(subst(readfield(filename,f7.value,f7l.value),'*',' ')); if bf<>'' then edit6.text:=bf;
 bf:=trim(subst(readfield(filename,f8.value,f8l.value),'*',' ')); if bf<>'' then edit7.text:=bf;

 bf:=trim(subst(readfield(filename,f4.value,f4l.value),'*',' ')); if bf<>'' then if bf<>'1' then checkbox2.checked:=false;

end;

function AddSpaces(instring:string; finallength:word):string;
var
 ct:word;
 bf:string;

begin
 if length(instring)=finallength then begin
  AddSpaces:=instring;
  exit;
 end;

 if length(instring)<finallength then begin
  bf:='';
  for ct:=1 to (finallength-length(instring)) do bf:=bf+' ';
  bf:=instring+bf;
  AddSpaces:=bf;
 end;

 if length(instring)>finallength then begin
  bf:=copy(instring,1,finallength);
  AddSpaces:=bf;
 end;

end;

procedure CopyFile;

var

  FromF, ToF: file;
  NumRead, NumWritten: Integer;
  Buf: array[1..2048] of Char;
begin
    AssignFile(FromF, FileName);
    Reset(FromF, 1);	{ Record size = 1 }
    AssignFile(ToF, newname);	{ Open output file }
    Rewrite(ToF, 1);	{ Record size = 1 }
      repeat
        BlockRead(FromF, Buf, SizeOf(Buf), NumRead);
        BlockWrite(ToF, Buf, NumRead, NumWritten);
      until (NumRead = 0) or (NumWritten <> NumRead);
        CloseFile(FromF);
        CloseFile(ToF);


end;

function SAVECFG:boolean;

var
 infile, outfile:file;
 NumRead, NumWritten: integer;
 Buf: array[1..2048] of Char;
 bf:string;
 ct:integer;

begin with form1 do begin
  savecfg:=false;

  assignfile(infile,filename);  {$I-} reset(infile,1); {$I+} if ioresult<>0 then exit;
  assignfile(outfile,newname);  {$I-} rewrite(outfile,1); {$I+} if ioresult<>0 then exit;

  repeat
   {$I-} BlockRead(infile, Buf, SizeOf(Buf), NumRead);  {$I+} if ioresult<>0 then begin messagedlg('Read error during file copy.',mterror,[mbok],0); exit; end;
   {$I-} BlockWrite(outfile, Buf, NumRead, NumWritten); {$I+} if ioresult<>0 then begin messagedlg('Write error during file copy.',mterror,[mbok],0); exit; end;
  until (NumRead = 0) or (NumWritten <> NumRead);

  closefile(infile);

  bf:=edit1.text; for ct:=1 to length(bf) do buf[ct]:=bf[ct]; {$I-} seek(outfile,f1.value); {$I+}             if ioresult<>0 then begin messagedlg('Seek error. Field 1 probably out of file size.',mterror,[mbok],0); exit; end;
                                                              {$I-} blockwrite(outfile,buf,length(bf)); {$I+} if ioresult<>0 then begin messagedlg('Write error. Field 1 write out of file.',mterror,[mbok],0); exit; end;
  bf:=edit2.text; for ct:=1 to length(bf) do buf[ct]:=bf[ct]; {$I-} seek(outfile,f2.value); {$I+}             if ioresult<>0 then begin messagedlg('Seek error. Field 2 probably out of file size.',mterror,[mbok],0); exit; end;
                                                              {$I-} blockwrite(outfile,buf,length(bf)); {$I+} if ioresult<>0 then begin messagedlg('Write error. Field 2 write out of file.',mterror,[mbok],0); exit; end;
  bf:=edit3.text; for ct:=1 to length(bf) do buf[ct]:=bf[ct]; {$I-} seek(outfile,f3.value); {$I+}             if ioresult<>0 then begin messagedlg('Seek error. Field 3 probably out of file size.',mterror,[mbok],0); exit; end;
                                                              {$I-} blockwrite(outfile,buf,length(bf)); {$I+} if ioresult<>0 then begin messagedlg('Write error. Field 3 write out of file.',mterror,[mbok],0); exit; end;
  bf:=edit4.text; for ct:=1 to length(bf) do buf[ct]:=bf[ct]; {$I-} seek(outfile,f5.value); {$I+}             if ioresult<>0 then begin messagedlg('Seek error. Field 5 probably out of file size.',mterror,[mbok],0); exit; end;
                                                              {$I-} blockwrite(outfile,buf,length(bf)); {$I+} if ioresult<>0 then begin messagedlg('Write error. Field 5 write out of file.',mterror,[mbok],0); exit; end;
  bf:=edit5.text; for ct:=1 to length(bf) do buf[ct]:=bf[ct]; {$I-} seek(outfile,f6.value); {$I+}             if ioresult<>0 then begin messagedlg('Seek error. Field 6 probably out of file size.',mterror,[mbok],0); exit; end;
                                                              {$I-} blockwrite(outfile,buf,length(bf)); {$I+} if ioresult<>0 then begin messagedlg('Write error. Field 6 write out of file.',mterror,[mbok],0); exit; end;
  bf:=edit6.text; for ct:=1 to length(bf) do buf[ct]:=bf[ct]; {$I-} seek(outfile,f7.value); {$I+}             if ioresult<>0 then begin messagedlg('Seek error. Field 7 probably out of file size.',mterror,[mbok],0); exit; end;
                                                              {$I-} blockwrite(outfile,buf,length(bf)); {$I+} if ioresult<>0 then begin messagedlg('Write error. Field 7 write out of file.',mterror,[mbok],0); exit; end;
  bf:=edit7.text; for ct:=1 to length(bf) do buf[ct]:=bf[ct]; {$I-} seek(outfile,f8.value); {$I+}             if ioresult<>0 then begin messagedlg('Seek error. Field 8 probably out of file size.',mterror,[mbok],0); exit; end;
                                                              {$I-} blockwrite(outfile,buf,length(bf)); {$I+} if ioresult<>0 then begin messagedlg('Write error. Field 8 write out of file.',mterror,[mbok],0); exit; end;

  bf:='1'; if not checkbox2.checked then bf:='0';
                  for ct:=1 to length(bf) do buf[ct]:=bf[ct]; {$I-} seek(outfile,f4.value); {$I+}             if ioresult<>0 then begin messagedlg('Seek error. Field 4 probably out of file size.',mterror,[mbok],0); exit; end;
                                                              {$I-} blockwrite(outfile,buf,length(bf)); {$I+} if ioresult<>0 then begin messagedlg('Write error. Field 4 write out of file.',mterror,[mbok],0); exit; end;

  closefile(outfile);
  savecfg:=true;

end;end;


procedure TForm1.Save1Click(Sender: TObject);
begin
 if filename='' then begin messagedlg('Open a file before....',mtwarning,[mbok],0); exit; end;

 if not savedialog1.execute then exit;
 newname:=savedialog1.filename;

 if uppercase(newname)=uppercase(filename) then begin messagedlg('Input and output files cannot be the same!',mterror,[mbok],0); exit; end;

 edit1.text:=addspaces(edit1.text,f1l.value);
 edit2.text:=addspaces(edit2.text,f2l.value);
 edit3.text:=addspaces(edit3.text,f3l.value);
 edit4.text:=addspaces(edit4.text,f5l.value);
 edit5.text:=addspaces(edit5.text,f6l.value);
 edit6.text:=addspaces(edit6.text,f7l.value);
 edit7.text:=addspaces(edit7.text,f8l.value);

 if not savecfg then messagedlg('One some errors writing configuration.',mterror,[mbok],0);

end;


procedure TForm1.Edit7Change(Sender: TObject);
begin
 edit7.maxlength:=f8l.value;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
 f:file of longint;
 vl:longint;

begin
 if fileexists('.\offsets.dat') then begin
  assignfile(f,'.\offsets.dat'); reset(f);

  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; if vl=1 then checkbox1.checked:=true;

  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f1.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f2.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f3.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f4.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f5.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f6.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f7.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f8.value:=vl;

  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f1l.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f2l.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f3l.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f4l.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f5l.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f6l.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f7l.value:=vl;
  {$I-} read(f,vl); {$I+} if ioresult<>0 then exit; f8l.value:=vl;

 closefile(f);
 end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
 f:file of longint;
 vl:longint;

begin

 assignfile(f,'.\offsets.dat'); {$I-} rewrite(f); {$I+} if ioresult<>0 then exit;

 if checkbox1.checked then vl:=1 else vl:=0; write(f,vl);

 vl:=f1.value; write(f,vl);
 vl:=f2.value; write(f,vl);
 vl:=f3.value; write(f,vl);
 vl:=f4.value; write(f,vl);
 vl:=f5.value; write(f,vl);
 vl:=f6.value; write(f,vl);
 vl:=f7.value; write(f,vl);
 vl:=f8.value; write(f,vl);

 vl:=f1l.value; write(f,vl);
 vl:=f2l.value; write(f,vl);
 vl:=f3l.value; write(f,vl);
 vl:=f4l.value; write(f,vl);
 vl:=f5l.value; write(f,vl);
 vl:=f6l.value; write(f,vl);
 vl:=f7l.value; write(f,vl);
 vl:=f8l.value; write(f,vl);

 closefile(f);

end;

procedure TForm1.Label24Click(Sender: TObject);
begin
 shellexecute(0,'open','http://www.whi.cjb.net',nil,nil,0);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
 application.terminate;
end;

end.
