/*------------------------------------------------------------------
 * rxidentd.cmd - adapted from sample code provided by
 * by Patrick Mueller (pmuellr@vnet.ibm.com)
 *
 * This is a *very* basic identd program which satisifies the
 * only IRC server I use that requires identd services. Your
 * milage may vary. I created this because the very fine identd
 * program written by Sophisto (IRC, #os/2) does not run in OS/2 2.1,
 * and because it was an easy fix. I will fix problems as they arise,
 * if I have time. No guarantees it will work for you. This is my
 * gift to the world. Send Sophisto a card encouraging him to build
 * his identd for 2.1 and send Patrick Mueller a card thanking him for
 * RxSock - it is a great extender for REXX.
 *
 * usage: rxidentd userid [ > log.file ]
 *
 *------------------------------------------------------------------
 * Dennis Peterson - (dkp, IRC, #os/2) dpeterso@inetnw.com
 *------------------------------------------------------------------*/

trace off
CRLF = '0d'x'0a'x
parse arg userid .

/*------------------------------------------------------------------
 * choose the port
 *------------------------------------------------------------------*/
port = 113

/*------------------------------------------------------------------
 * initialize socket package
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
   do
      rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
      rc = SockLoadFuncs()
   end

/*------------------------------------------------------------------
 * create the initial socket
 *------------------------------------------------------------------*/
s  = SockSocket("AF_INET","SOCK_STREAM",0)
if (s = -1) then
   do
      say "Error on SockSocket:" errno
      exit
   end

/*------------------------------------------------------------------
 * catch breaks
 *------------------------------------------------------------------*/
signal on halt

/*------------------------------------------------------------------
 * bind socket to port
 *------------------------------------------------------------------*/
server.!family = "AF_INET"
server.!port   = port
server.!addr   = "INADDR_ANY"

rc = SockBind(s,"server.!")
if (rc = -1) then
   do
      say "Error on SockBind:" errno
      exit
   end

/*------------------------------------------------------------------
 * set queue size
 *------------------------------------------------------------------*/
rc = SockListen(s,10)
if (rc = -1) then
   do
      say "Error on SockListen:" errno
      exit
   end


/*------------------------------------------------------------------
 * infinite loop to handle requests ...
 *------------------------------------------------------------------*/
do forever
   say "Waiting for client"

   /*---------------------------------------------------------------
    * accept a connection
    *---------------------------------------------------------------*/
   ns = SockAccept(s,"client.!")
   if (ns = -1) then
      do
         say "Error on SockAccept:" errno
         exit
      end

   /*---------------------------------------------------------------
    * get clients host name
    *---------------------------------------------------------------*/
   if SockGetHostByAddr(client.!addr,"host.!") then
      clientName = host.!name
   else
      clientName = "Unknown"

   say "Accepted client:" client.!addr clientName

   /*---------------------------------------------------------------
    * get peer host name
    *---------------------------------------------------------------*/
   rc = SockGetPeerName(ns,"peer.!")
   if (rc = -1) then
      do
         say "Error on SockGetPeerName:" errno
/*       exit */
      end

   say "PeerName:" peer.!addr

   /*---------------------------------------------------------------
    * get socket host name
    *---------------------------------------------------------------*/
   rc = SockGetSockName(ns,"sock.!")
   if (rc = -1) then
      do
         say "Error on SockGetSockName:" errno
/*       exit */
      end

   say "SockName:" sock.!addr

   /*---------------------------------------------------------------
    * receive data from client
    *---------------------------------------------------------------*/
   rc = SockRecv(ns,"data",1000)
   if (rc = -1) then
      do
         say "Error on SockRecv:" errno
         exit
      end

   say "Received:" data
   parse var data data1 . data2 .
   /*---------------------------------------------------------------
    * send data back
    *---------------------------------------------------------------*/
   data_new = data1 || ' , ' || substr(data2,1,4) || ' : USERID : UNIX : 'userid || crlf
   say data_new

   rc = SockSend(ns,data_new)
   if (rc = -1) then
      do
         say "Error on SockSend:" errno
         exit
      end

   /*---------------------------------------------------------------
    * close the new socket from client
    *---------------------------------------------------------------*/
   rc = SockSoClose(ns)
   ns = ""
   if (rc = -1) then
      do
         say "Error on SockSoClose:" errno
         exit
      end

   say "Closing connection"
   say
end

/*------------------------------------------------------------------
 * handle break by closing sockets
 *------------------------------------------------------------------*/
halt:

say
say "Quitting ..."

rc = SockSoClose(s)

if datatype(ns,"W") then
   rc = SockSoClose(ns)

