/* The SSI cache daemon for SREFAST. */

foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'

  call SysLoadFuncs
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end

parse arg port,basedir,refresh,force_refresh,datdir,tdir,verbose,key_preface,enmadd,servername0,diskfree

if port=" " | basedir=" " then do
   say "This is an SRE-Filter procedure "
   exit
end  /* Do */

if datatype(diskfree)<>'NUM' then  diskfree=10
diskfree=diskfree*1000000

if datatype(REFRESH)<>'NUM' then  refresh=60
if datatype(force_REFRESH)<>'NUM' then  force_refresh=60


ooindx=basedir||'\INITFAST.'||port
datdir=translate(datdir,'\','/')
tdir=strip(translate(tdir,'\','/'),,'\')||'\'
transaction=1000000                             /* arbitratry value */

thd=dostid()
call pmprintf_sref(' SREFAST ssi daemon started on thread 'thd' for server: ' servername0)

afilt2=tdir||'_fstindx.'||port          /* delete old index */
foo=sysfiledelete(afilt2)
thedrive=filespec('d',afilt2)

THEsem='\SEM32\'||enmadd

mysem=thesem||"t"||THD
myqueue="SREF_"||port||'_t'||THD

goserve_ver=server('H')
aa=make_semmi()                 /* create own queue and thread */

/* load version: but might need to wait for a second */
do forever
  if macroquery('SREF_VERSION')<>"" then leave
   call syssleep 3
end

signal on error name tdog
signal on syntax name tdog

call syssleep 2                /* give srefiltr's other threads a chance to catch up */
iter=0

dynlist=" cgi_inc_timefmt date_local date_gmt server_protocol request_method username remote_addr auth_name "
dynlist=dynlist||' http_accept browser referer date_local2 time time_gmt date_gmt2 read_head  '
dynlist=upper(dynlist)

/* create file stamps */
initfilt_file=basedir||"\INITFILT."||port
aa=sysfiletree(initfilt_file,bb,'FT')
initfilt_stamp=space(upper(bb.1))

virtual_file=get_value('VIRTUAL_FILE')
if virtual_file=' ' then virtual_file=0
virtual_stamp=' '
if virtual_file<>0 then do
   aa=sysfiletree(virtual_file,bb,'FT')
  virtual_stamp=space(upper(bb.1))
end

repstrgs_file=get_value('REPSTRGS_FILE')
if repstrgs_file=' '  then repstrgs_file=0
repstrgs_stamp=' '
if repstrgs_file<>0 then do
   aa=sysfiletree(repstrgs_file,bb,'FT')
  repstrgs_stamp=space(upper(bb.1))
end

if stream(ooindx,'c','query exists')="" then   do
   initfast_stamp=' '
end
else do
   aa=sysfiletree(ooindx,bb,'FT')
   initfast_stamp=space(upper(bb.1))
end

DO FOREVER


 makechange=0
 do mm=1 to force_refresh
   iter=iter+1
    if iter=1 then leave                /* do it on first iteration */
    call syssleep refresh
/* check stamps */
     AChAnge=check_stamps(ooindx,initfilt_file,repstrgs_file,virtual_file)
     IF ACHANGE=1 then LEAVE     /* CHANGE DETECTED */
     IF VERBOSE>1 then CALL pmprintf_sref(' SREFAST ssi daemon: no change in configuration files ')
 END


/* IF HERE, THEN REFRESH CONFIGURATION FILE */
/* suppress use of ssis (for now) */
   oo=cvread(afilt2,daindx)
   if oo=1 then do
     daindx.!nossi=1
     oo=cvwrite(afilt2,daindx)
  end
  drop daindx.


/* delete old cache files (and then recreate them */
   lookstar=tdir||'_*.sf1'
   foo=sysfiletree(lookstar,stuff,'FO')
   do mm=1 to stuff.0
      foo=sysfiledelete(stuff.mm)
   end /* do */
   if stuff.0>0 t& verbose>0 then
      call pmprintf_sref('SREFAST ssi daemon:: Deleted ' stuff.0 ' cache files from: 'tdir)

   if verbose>1 then call pmprintf_sref(' SREFAST ssi daemon: checking configuration file ... ')

  oo=get_index(ooindx)

  if oo=0 then do
     call pmprintf_sref(" SREFAST ssi daemon: index " ooindx " not available")
     iterate
  end

  if verbose>1 then call pmprintf_sref(' SREFAST ssi daemon:  Checking ' daindx.0 ' entries ')

/* configuration file is okay, look for ssi entries */
  do mm=1 to daindx.0
     if symbol('DAINDX.'||mm||.'!SSI')<>'VAR' then  iterate
     if daindx.mm.!ssi=0 then iterate
     if symbol('DAINDX.'||mm||.'!NODO')='VAR' then do
         if daindx.mm.!nodo=1 then iterate
     end

/* do this one.  Determine file name */
     ddir=datdir
     dnameonly=0
     if symbol('Daindx.'mm'.!DIR')='VAR' then do
        ddir=strip(upper(daindx.mm.!dir))
        if abbrev(ddir,'HTTP://')=1 then iterate  /* can't do this one */
        if symbol('Daindx.'mm'.!DIR_NAMEONLY')='VAR' then do
              dnameonly=daindx.mm.!dir_nameonly
        end
     end
     afile=fig_afile(ddir,daindx.mm.!sel,dnameonly)

    if pos('*',afile)>0 then iterate
    froot=tdir'_'port||mm
    cshfile=froot||'.SF1'

    host_nickname=' '
    servername=servername0
    if symbol('Daindx.'||mm||.'!HOST')='VAR' then host_nickname=daindx.mm.!host
    if symbol('Daindx.'||mm||.'!SERVER')='VAR' then servername=daindx.mm.!server

    drop eek.


include_list=' '
    status=do_ssi(afile,daindx.mm.!sel,cshfile)
/*call pmprintf_sref(' include list ' include_list)*/
 
    if status=1 then do         /* save as is */

        ibig=length(outbig)
        mwow=strip(word(sysdriveinfo(thedrive),2))
        if (mwow-ibig)<diskfree then do
                call pmprintf_sref(' SREFAST ssi daemon: disk too full ('mwow)
                signal death
        end  /* Do */
        foo=charout(cshfile,outbig,1)
        a=stream(cshfile,'c','close')
        if foo>0 then do
           call pmprintf_sref('SREFAST ssi daemon: Problem writing asis cache file 'cshfile)
           signal death
       end

        daindx.mm.!type='ASIS'
        daindx.mm.!file=cshfile
        aa=sysfiletree(afile,a1,'T')
        daindx.mm.!stamp=upper(space(a1.1))
        if symbol('Daindx.'||mm||.'!TRIGGER')='VAR' then do
              aa=sysfiletree(daindx.mm.!trigger,a1,'T')
              if a1.0>0 then
                 daindx.mm.!trigger=upper(space(a1.1))
              else
                 drop daindx.mm.!trigger
        end
       daindx.mm.!origfile=afile
       if verbose>1 then call pmprintf_sref(' SREFAST ssi daemon:  asis cache of ' daindx.mm.!sel ' to 'cshfile)
    end /* status */

    if status=2  then do    /* dynamic includes in cache file */
        daindx.mm.!type='DYNAMIC'
        daindx.mm.!file=cshfile

        mwow=strip(word(sysdriveinfo(thedrive),2))
        if (mwow-ioutbig)<diskfree then do
                call pmprintf_sref(' SREFAST ssi daemon: disk too full ('mwow)
                signal death
        end  /* Do */
        oo=cvwrite(cshfile,eek)
        aa=sysfiletree(afile,a1,'T')
        daindx.mm.!stamp=upper(space(a1.1))

        if symbol('Daindx.'||mm||.'!TRIGGER')='VAR' then do
              aa=sysfiletree(daindx.mm.!trigger,a1,'T')
              if a1.0>0 then
                 daindx.mm.!trigger=upper(space(a1.1))
              else
                 drop daindx.mm.!trigger
        end

        daindx.mm.!origfile=afile
        if oo=0 then do
              call pmprintf_sref(' SREFAST ssi daemon: Problem writing dynamic cache file ' cshfile)
               signal death
         end  /* Do */
        if verbose>1 then call pmprintf_sref(' SREFAST ssi daemon: dynamic cache of  ' daindx.mm.!sel ' using ' eek.0 ' parts to 'cshfile)
    end  /* Do */

    if status=0 then do        /* status=0 -- don't do it (srefiltr will)*/
          daindx.mm.!type='SKIP'
          if verbose>1 then call pmprintf_sref(' SREFAST ssi daemon: SKIP ' daindx.mm.!sel)
    end

  end   /* looking for ssi entries */

/* write working version of configuration file*/
    itmp=daindx.0
   aoo=fix_daindx()   /* first remove SKIP entries and otherwise bogus entries  */

   daindx.!nossi=0      /* no suppression */
   oo=cvwrite(afilt2,daindx)
   if oo=0 then do
       call pmprintf_sref(' SREFAST ssi daemon: Error writing working index 'afilt2)
       signal death
   end
   if verbose>0 then call pmprintf_sref(" SREFAST ssi daemon: " daindx.0 " of " itmp " entries to working index: " afilt2)

end /* do  forever*/

death:
call pmprintf_sref(' SREFAST ssi daemon: Error, caching stopped ')
foo=sysfiledelete(afilt2)
exit

tdog:
call pmprintf_sref('SREFAST ssi daemon: Error: line 'sigl)
exit


/***********************************/
fig_afile:procedure
parse arg ddir,asel,dnameonly

   ddir=strip(translate(ddir,'\','/'),,'\')||'\'
   addme=strip(translate(asel,'\','/'),,'\')
   if dnameonly=1 then addme=filespec('n',addme)
   afile=ddir||addme  /* the absolute filename of the file to be processed */
return afile


/***************/
/* remove useless entries from daindx */
fix_daindx:procedure expose daindx. datdir verbose                         

il=0
drop doit.
do mm=1 to daindx.0

   if symbol('DAINDX.'||mm||'.!SEL')<>'VAR' then iterate

/* nodos */
   if symbol('DAINDX.'||mm||'.!NODO')='VAR'  then do
        if daindx.mm.!nodo=1 then do
                il=il+1
                oo=cvcopy(daindx.mm,doit.il)
        end
        iterate
    end

/* skip? */
   if symbol('DAINDX.'||mm||'.!TYPE')='VAR'  then do
        if  daindx.mm.!type<>'SKIP' then do
                il=il+1
                oo=cvcopy(daindx.mm,doit.il)
        end
        else do
           if verbose>1 then call pmprintf_sref(' SREFAST ssi daemon: Skipping, can not do SSIs in 'daindx.mm.!sel ' ( ' mm)
       end
       iterate
   end

/* wildcards */
   if pos('*',daindx.mm.!sel)>0 then do         /* wildcards, too hard to check */
          il=il+1
          oo=cvcopy(daindx.mm,doit.il)
          iterate
   end

/*  check for existence of file */
   ddir=datdir
   dnameonly=0
   if symbol('DAINDX.'mm'.!DIR')='VAR' then do
        ddir=strip(upper(daindx.mm.!dir))
        if abbrev(ddir,'HTTP://')=1  then do     /* redirect or wildcard-- keep it */
                il=il+1
                oo=cvcopy(daindx.mm,doit.il)
                iterate
        end
        ddir=strip(translate(ddir,'\','/'),,'\')||'\'
        if symbol('DAINDX.'mm'.!DIR_NAMEONLY')='VAR' then do
              dnameonly=daindx.mm.!dir_nameonly
        end
    end
    afile=fig_afile(ddir,daindx.mm.!sel,dnameonly)

    oug=sysfiletree(afile,ibug)
    if ibug.0>0 then do             /* exists, keep it */
                il=il+1
                oo=cvcopy(daindx.mm,doit.il)
                iterate
     end
     else do
         if verbose>1 then call pmprintf_sref(' SREFAST ssi daemon: Skipping, no matches for 'daindx.mm.!sel' ('afile)
     end  /* Do */
end /* do */
doit.0=il
aa=cvcopy(doit,daindx)
return 0

/***************/

/* -----------Sre-filter Server side include routine -------------- */


do_ssi:procedure expose filter_name key_preface enmadd host_nickname port servername ,
                   transaction ddir goserve_ver outbig verbose eek. dynlist ioutbig basedir include_list
parse arg afile,thesel,cshfile

 crlf='0d0a'x
/* default value for cgi includes */
cgi_inc_errmsg="Error in CGI Include "
cgi_inc_sizefmt="ABBREV"
cgi_inc_timefmt="%c"
bigin=0

bigin=sref_grab_file(afile,30)
if bigin=0 | bigin="" then  return 0

if c2d(right(bigin,1))=26 then
      bigin=left(bigin,length(bigin)-1)

tbigin=translate(bigin)

inctype.1="INTERPRET"  
 inctype.2="OPTION"     /* killer */
 inctype.3="INCLUDE"
 inctype.4="REPLACE"
 inctype.5="SELECT"    /* killer */
 inctype.6='#'
 inctype.7='CACHE'   /* ignored */
 i5=7

if key_preface<>" "  & key_preface<>0 then do
        do mm=1 to 5
           inctype.mm=key_preface||inctype.mm
        end
        inctype.7=key_preface||inctype.7
end

apre=1 ;  apost=1
 headers=get_value('HEADERS')
 footers=get_value('FOOTERS')
 homedir=get_value('HOME_DIR')
 if headers=0 then headers=" "
 if footers=0 then footers=" "
 if headers=" " then apre=0
 if footers=" " then apost=0

/* note that j.i may or may not be in a keyphrase! */
booger=apre+apost
do mm=1 to i5
    if booger>0 then leave
    booger=booger+pos(inctype.mm,tbigin)
end

/* NO include keyphrases  */
if booger = 0 then do
   outbig=bigin
   return 1    /* no ssi's, return as is */
end /* do */

/* add pre or post blocks if they have been specified (typically in initfilt) */
 if apre=1 & astatus=0  & ssino.!no_header=0 then do
     foo=upper(space(strip(headers),0))
     idog=1
     if abbrev(foo,'<BODY')=1 then idog=2
     bigin=sref_insert_block(bigin,'BODY',headers,idog,'<','>')
 end
 if apost=1  & astatus=0 & ssino.!no_footer=0 then do
      bigin=bigf_footer(footers)
 end

/* now start processing  bigin */

/* For flexibility, we process this for each set of "keyphrase delimiters",
where set k=1..K is defined using delim_1.k and delim_2.k (typically set
in initfilt) */

adelim1=get_value('DELIM_1.1')
adelim2=get_value('DELIM_2.1')

if adelim1="" | adelim2="" | adelim1=0 | adelim2=0 then return 0  /* bad initial delimiter -- don't do includes */

outbig=''
yeck=0

do forever                      /* done when done */
   parse var bigin t1 (adelim1) in1 (adelim2) bigin

   outbig=outbig||t1

   if in1="" & bigin="" then leave

/* see if in1 is one of the inctypes (inctypes are aka keywords)*/
  in2=translate(in1)
  in2=translate(in2,' ','=:;')    /* space is the generic seperater */

  aninc=0
                  /*  is first one of our keywords ? */
  do mm=1 to i5
     if abbrev(word(in2,1),inctype.mm)=1 then  do     /* it's the mm'th inc type */
        aninc=mm
        select
          when mm=2 | mm=5  then return 0   /*  option and select are killers */
          when mm=1 then do
               if verbose>2 then call pmprintf_sref(' SREFAST ssi daemon: INTERPRET entry can not be cached')
               return 0 /* interpret is killer  */
          end
          when  mm=3 | mm=4  then  thearg=word(in2,2)
          when mm=6 then do
              foo=pos('#',translate(in1))
              thearg=substr(in1,foo+1)
           end
           when mm=7 then do
               aninc=0           /* ignore CACHE */
           end
           otherwise nop
        end             /* select */
        leave
     end      /*abbrev */
  end         /* mm loop */

/* Not a keyword, or a syntactically bad keyphrase    */
 if aninc=0  then do
       if bigin<>"" then
            t1=adelim1||in1||adelim2  /* leave it be */
       else
            t1=adelim1||in1  /* openended "comment" */
      outbig=outbig||t1
      iterate
  end


/* ------- DO SOME WORK (if here, we have a (possibly) good keyphrase) */
  select
     when aninc=6  then   putme=do_cgi_include(thearg)    /* NCSA stuff */
      when aninc=3  then   putme=line_include(thearg)    /* INCLUDE */
     when aninc=4  then  putme=line_replace(thearg) /* REPLACE */
     otherwise  putme=""        /* possibly a suppressed keyphrase */
  end
if verbose>2 then call pmprintf_sref(left(aninc' 'thearg ' : putme= ' putme,79))
if yeck=1 & verbose>2 then call pmprintf_sref(aninc' yeck is ' thearg)
if yeck=1 then return 0         /* yeck means got a killer */

  if c2d(right(putme,1))=26 then putme=left(putme,length(putme)-1)  /* strip trailing ctl-z */

  bigin=putme||bigin   /* this is the recursive part */
end                     /*of bigin parse loop */


/* we are done. */

if c2d(right(outbig,1))=26 then
      outbig=left(outbig,length(outbig)-1)

IF YECK=1 then RETURN 0         /* can't do it */

ai=pos('<!--=!  ',outbig)
if ai=0 then do
  return 1
end  /* Do */

/* dynamic: break into parts */
iat=0
ioutbig=length(outbig)
do until outbig=""
    parse var outbig p1 '<!--=!' anarg '-->' outbig
    iat=iat+1
    eek.iat.!type=1             /*1 means literal */
    eek.iat=p1
    if anarg=""  then iterate
    iat=iat+1
    parse var anarg v1 v2
    v1=upper(strip(v1))
    if wordpos(v1,dynlist)=0 then do
        eek.iat.!type=1                 /* 1 symbols literal (comment, in this case */
        eek.iat='<!--=!'|| anarg|| '-->'
    end  /* Do */
    else do             /* 2 signals dyamic */
        eek.iat.!type=2
        eek.iat=upper(v1)||' '||v2
    end  /* Do */
end /* do */
eek.0=iat

return 2



/* -----------------------------------------------------------
 Evaluate a cgi-bin (NSCA HTTPD style server side include
 ----------------------------------------------------------- */
do_cgi_include:
parse arg thearg

parse var thearg atype aval

/* valid atypes:
  INCLUDE = Include a file
  ECHO = "replace" with a cgi-bin variable
  FSIZE= Size of a file
  FLASTMOD = Last modification date of a file
  EXEC = killer
*/
tatype=strip(translate(atype))

figit=0
if wordpos(tatype,' INCLUDE FLASTMOD FSIZE ')>0  then do
     parse upper var aval ftype '=' aval
     aval=strip(strip(aval),,'"') ; ftype=strip(ftype) ; figit=0
     if ftype='FILE' then do    /* relative to absolute directory" */
         if usef=1 then do
                return cgi_inc_errmsg
          end
          adr=filespec('d',afile)
          apt=filespec('p',afile)
          aval=adr||apt||aval
          figit=1
     end
end


if tatype="INCLUDE" then do
        putme=line_include(aval,figit)
        if putme=0 | putme="" then putme=cgi_inc_errmsg
        return putme
  end

if (tatype="FSIZE" | tatype="FLASTMOD") then do

    cfile=line_include(aval,'YES',figit,1)
    oy=sysfiletree(cfile,'stuff','FT')
    if stuff.0=0 then   return cgi_inc_errmsg

    parse var stuff.1 adate asize .
    parse var adate yy '/' mo '/' dd '/' hh '/' mm '/' ss
    if ss=' ' then ss='00'
    yip=yy||'/'||mo||'/'||dd
    adatef=dateconv(yip,'O','B')
    atimef=hh||':'||mm||':'||ss


    if tatype="FLASTMOD" then do
       asis_ok=0
       putme=sref_datetime_convert(cgi_inc_timefmt,adatef,atimef)
       return putme
    end

    if tatype="FSIZE" then do
        asis_ok=0
        if translate(cgi_inc_sizefmt)="ABBREV" then do
               if asize>=1000000 then return format(asize/1000000,,0)||'M'
               if asize>=1000 then  return format(asize/1000,,0)||'K'
        end
/* convert to xxx,yyy,zzz */
        il=length(asize)
        if il>3 then do
           oop=""
           do mm=il to 3 by -3
               tt=substr(asize,mm-2,3)
               if mm=il then
                  oop=tt
               else
                 oop=tt||','||oop
           end /* do */
           if mm<>0 then oop=substr(asize,1,mm)||','||oop
           asize=oop
        end
        return asize    /* not abbrev, or < 1000 */
    end

end

if tatype="CONFIG"  then do

      asis_ok=0
      parse var aval t1 '=' t2  ;t1=translate(t1)
      t2a=strip(strip(t2),,'"')

      putme=""
      select
        when t1="ERRMSG" then DO
                cgi_inc_errmsg=t2a
                PUTME=' '
        end
        when t1="TIMEFMT" then    do
              cgi_inc_timefmt=t2a
              PUTME=' <!--=!  cgi_inc_timefmt 't2a' --> '
        end
        when t1="SIZEFMT" then do
              cgi_inc_sizefmt=translate(t2a)
              PUTME='  '
        end
        otherwise nop
      end
      return putme
end

if tatype="ECHO" then do
      parse var aval foo '=' findme ; findme=translate(findme)
      findme=strip(strip(findme),,'"')
      select
         when findme="DOCUMENT_NAME" then do
                putme=afile
         end
         when findme="DOCUMENT_URI" then do
                putme=thesel
         end
         when findme="DATE_LOCAL" then do
               putme='<!--=!  DATE_LOCAL --> '
         end
         when findme="DATE_GMT" then do
               putme='<!--=!  DATE_GMT --> '
         end
         when findme="LAST_MODIFIED" then do
                 eek=sysfiletree(translate(afile,'\','/'),gosh,'FT')
                 parse var gosh.1 adate asize .
                 parse var adate yy '/' mo '/' dd '/' hh '/' mm '/' ss
                 if ss=' ' then ss='00'
                 adatef=dateconv(yy||'/'||mo||'/'||dd,'O','B')
                 atimef=hh||':'||mm||':'||ss
                 putme=sref_datetime_convert(cgi_inc_timefmt,adatef,atimef)
        end     /* last modified */
        when findme="SERVER_SOFTWARE" then do
                 putme=goserve_ver||' '||filter_name
        end
        when findme="SERVER_NAME" then do
                putme=servername
        end
        when findme="GATEWAY_INTERFACE" then do
                putme="CGI/1.1"
        end
        when findme="SERVER_PROTOCOL" then do
                putme='<!--=!  SERVER_PROTOCOL --> '
        end  /* Do */
        when findme="SERVER_PORT" Then do
                putme=port
        end
        when findme="REQUEST_METHOD" then do
               putme='<!--=!  REQUEST_METHOD --> '
        end
        when findme="PATH_INFO" then do
                putme=" Path_info n.a. "
        end
        when findme="PATH_TRANSLATED" Then do
                putme="Path_translated n.a. "
        end
        when findme="SCRIPT_NAME" then do
              putme=thesel
        end
        when findme="QUERY_STRING" then  do
                putme=""  /* query string requests don't get here */
        end
        when findme="REMOTE_HOST" then do
               putme='<!--=!  USERNAME --> '
         end
        when findme="REMOTE_ADDR" then do
               putme='<!--=!  REMOTE_ADDR --> '
        end
        when findme="AUTH_TYPE" then
                putme="Basic Access Authentication Scheme"
        when findme="AUTH_NAME" then
               putme='<!--=!  AUTH_NAME --> '
        when findme="REMOTE_IDENT" then
                putme="Remote_ident n.a. "
        when findme="CONTENT_TYPE" then
                putme="Content_type n.a."
        when findme="CONTENT_LENGTH" then
                putme="Content_length n.a."
        when abbrev(findme,"HTTP_ACCEPT") then
               putme='<!--=! HTTP_ACCEPT -->'
        when abbrev(findme,"HTTP_USER-AGENT") then
               putme='<!--=! BROWSER   --> '
        when abbrev(findme,"HTTP_REFERER") then
               putme='<!--=! REFERER  --> '

        otherwise  putme=cgi_inc_errmsg
     end                /* select */
     return putme
end


if tatype="EXEC"  then do
     YECK=1
END

RETURN 0


/* ----------------------------------------------------------------------- */
/*  Look for INCLUDE  keyphrases
.    If present, pull in lines from INCLUDE file.
.
.   Note: INCLUDE files are subject to further processing
.      -- so BEWARE of recursive TRAPS !
.  Justfile argument used by CGI_INCLUDE routine
*/
/* ----------------------------------------------------------------------- */


line_include:procedure expose yeck ddir enmadd transaction homedir host_nickname ,
                        verbose include_list
parse arg incfil0,absname,justfile
justfile=translate(justfile)

IF POS('~',INCFIL0)>0 then DO   /* TOO MUCH TROUBLE -- GIVE UP */
     YECK=1
     RETURN 0
end  /* Do */

   if absname=1 then do
      incfile=incfil0
   end
   else do
      incfile=sref_do_virtual(ddir,incfil0,enmadd,1,transaction,homedir,host_nickname)
   end

   if justfile=1 then return incfile

   putme=sref_grab_file(incfile,120)
   if putme=0 then do
      yeck=1
      return 0
   end

   include_list=include_list||' '||upper(incfile)

   return putme




/* ----------------------------------------------------------------------- */
/* This will do a REPLACE: on a line.  The currently supported values are
        DATE        todays date
       TIMEGMT     current time (GMT)
       TIME    current time
       CREATION    A message on the creation date & time of the file
       CREATION_DATE Just the creation date
       CREATION_TIME  Just the creation time (use with CREATION_DATE and your own message)
       WEBMASTER  The contents of the WEBMASTER parameter
       REFERER   The referer (from the request header)
      BROWSER   The requesters browser (from the request header)
        CLIENTNAME USERNAME   ABC.DDD.GOV type name, or ip address if n.a.

       INHOUSE.n    n = an integer.  Used for messages to INHOUSE  users only.
       SUPERUSER.n   n = an integer.  Used for messages to Superusers only

       HITS         The nth hit for this file (requires looking at Counter_file
               Also COUNTS, OPTION_HITS.n and OPTION_COUNT.n variants
       WEBMASTER = Webmaster address
       SERVERNAME = Name of server (i.e.; WWW.FOO.ORG)
       SERVER  =    Server software (i.e. GOSERV 2.45)
       FILTER_NAME = The name of this filter (set at the top of this file)

       VARIABLE.varname = Extract value of varname from environment
                If not in environment, see if a built in variable
                (such as SERVERPORT and PRIVSET).
                See srefmon.cmd for examples of environment vars.

       READ_HEAD    Do a READ HEADER VAR PUTME , append <PRE>

      and ...  Check replacestrg_file (static replacements) if no match from above.

/* ----------------------------------------------------------------------- */

*/

line_replace:

parse arg targ
parse upper var targ reparg "." repargn   /* parse out VAR.j types of labels */

issuper=0 ; isin=0;
if wordpos('SUPERUSER',translate(privset))>0  then
    issuper=1
else
   if wordpos('INHOUSE',translate(privset))>0 then
       isin=1

   select

        when reparg="DATE" | reparg="DATE_LOCAL"  then do
               putme='<!--=!  DATE_LOCAL2 --> '
        end
        when reparg="TIME" | reparg="TIMELOCAL" | reparg="TIME_LOCAL" then do
               putme='<!--=!  TIME --> '
        end
        when reparg="TIMEGMT" | reparg="TIME_GMT" then do
               putme='<!--=!  TIME_GMT --> '
        end

       when reparg="DATEGMT" | reparg="DATE_GMT" then do
               putme='<!--=!  DATE_GMT2 --> '
       end

       when reparg="USERNAME" | reparg="USER" | reparg="USER_NAME" ,
             | reparg="CLIENTNAME" | reparg='CLIENT'  then do
               putme='<!--=! USERNAME --> '
       end
       when reparg="FILTER_NAME" | reparg="FILTER_NAME" then
                putme=filter_name

      when reparg="HOME_NAME" | reparg="HOMENAME" then do
               putme=get_value('HOME_NAME')
      end

       when reparg="CREATION" then do           /* a creation-date-time message */
            if usef=1 then do
                 putme='n.a.'
            end
            else do
               eek=sysfiletree(translate(afile,'\','/'),gosh,'F')
               poop=gosh.1
               parse var poop adate atime  .
               adate=dateconv(adate,'u','n')
               putme =' <em> This document last modified at '||atime||', on '||adate|| '. </em>'
            end
        end

       when reparg="CREATION_DATE" then do       /*just the creation date */
           if usef=1 then do
                 putme='n.a.'
            end
            else do
              eek=sysfiletree(translate(afile,'\','/'),gosh,'F')
              poop=gosh.1
              parse var poop adate atime .
              adate=dateconv(adate,'u','n')
              putme =adate
           END
        end

       when reparg="CREATION_TIME" then do              /* just the creation time */
           if usef=1 then do
                 putme='n.a.'
            end
            else do
               eek=sysfiletree(translate(afile,'\','/'),gosh,'F')
               poop=gosh.1
               parse var poop adate atime .
               putme =atime
            END
        end

      when reparg="READ_HEAD" | reparg='HEADER'then do    /* read/display the request header */
               putme='<!--=! READ_HEAD --> '
      end

        when (reparg="INHMESS" | reparg="INHOUSE" )&  isin=1 then do
              yeck=1
        end

        when (reparg="SUPMESS" | reparg="SUPERUSER") & issuper=1 then do
              yeck=1
        end

        when abbrev(reparg,"REFER")=1 then do
               putme='<!--=! REFERER --> '
        end
        when (reparg="USER-AGENT" | reparg="BROWSER" ) THen do
               putme='<!--=! BROWSER --> '
        end
        when (reparg="URL") then do
                servername=servername
                putme=sref_fix_url(thesel,servername,port)
        end

        when wordpos(reparg,'HIT_FILE HITS_FILE COUNT_FILE COUNTS_FILE')>0 then do
             yeck=1
        end

   when reparg="SERVERNAME" | reparg="SERVER_NAME" then  /* servers ip name */
          putme=servername       /* servername set at top of filter */

 when reparg="VARIABLE" then do   /* get a variable defined in this filter program */
     yeck=1
 end
 when reparg="SERVER" then do
          putme=goserve_ver
 end
 when reparg="WEBMASTER" then     do
          putme=get_value('WEBMASTER')
 end
 otherwise do           /* see if in the replacement strings file*/
if verbose>2 then call pmprintf_sref(' checking value of  ' targ)
             putme=get_value(targ)
 end

END    /* select */

return putme            /* return it */


/* ---------------------- */
/* insert footers in a large file */
bigf_footer:procedure expose bigin servername host_nickname enmadd
parse  arg footers
iat=length(bigin)
iaa:
foo=lastpos('/BODY',translate(bigin),iat)
if foo=0 then do
  return bigin
end /* do */

foo2=lastpos('<',bigin,foo)
if foo2=0 then
   return bigin

yow=strip(substr(bigin,foo2+1,foo-(1+foo2)))
if yow=" " then  do
   return insert(footers,bigin,foo2-1)
end

iat=foo2                /* look again */
signal iaa



/* ----------- */
/* get environment value, possibly host specific */
/* ------------ */
get_value: procedure expose enmadd host_nickname
parse arg vname

vname=strip(vname) ; hname=strip(host_nickname)
if hname<>' ' then do
   aval=value(enmadd||vname||'.'||hname,,'os2environment')
   if aval<>' ' Then do
        return aval
   end
end
aval=value(enmadd||vname,,'os2environment')
return aval



/***************/
/* create a personallized queue & semaphore */
make_semmi:procedure expose myqueue mysem
a=rxqueue('s',myqueue)
noq=1
signal on syntax name badq
queue 0
noq=0
badq:
signal off syntax
if noq=1 then do
  foo=rxqueue('c',myqueue)
  if upper(foo)<>upper(myqueue) then
       call pmprintf_sref('SREFAST ssi daemon: wierd queue error ' foo' ' myqueue)
  a=rxqueue('s',myqueue)
end
yyq=queued()
if yyq>100 then do
  if verbose>1 then call pmprintf_sref(' SREFAST ssi daemon: Killing residual queue ' myqueue' ' yyq)
  aa2=rxqueue('d',myqueue)
  aa2A=rxqueue('c',myqueue)
  aa2B=rxqueue('s',myqueue)
  yyq=queued()
end
do mmy=1 to yyq
    pull poo .
end

wow=eventsem_query(mysem)
if wow=-187 then do
   a=eventsem_create(mysem)
   if a=0  then do
       nop
  end
  else do
     call pmprintf_sref(' SREFAST ssi daemon: Could not create semaphore: 'mysem' , error='a)
     dienow=0
     return 0
   end
end
foo=eventsem_reset(MYSEM)
dienow=1
return 1


/******************/
/* read text index file, create daindx
  return 0 if none, otherwise # entries
  Note that daindx might be expanded, if there are * selectors for
  SSI files */
get_index:procedure expose daindx. verbose datdir initfast_stamp initfilt_stamp basedir port initfilt_file
parse arg ooindx

aa=sref_fileread(ooindx,todos,,'E')
if aa=0 then return 0

ddir=datdir
drop doit.
signal on error name badline ; signal on syntax name badline
do kk=1 to todos.0              /* look for errors */
   aline=strip(todos.kk)
   if aline=' ' then iterate
   if abbrev(aline,';')=1 then iterate
   interpret aline                      /* read a doit. entry */
end /* do */
signal off error ; signal off syntax

/* now, expand the *.HTM "ssi" */
i1=0
do mm=1 to doit.0
   if symbol('DOIT.'||mm||'.!SEL')<>'VAR' then iterate  /* bad entry */
   if symbol('DOIT.'||mm||'.!SSI')<>'VAR' then do   /* not an * ssi */
          i1=i1+1
          a=cvcopy(doit.mm,daindx.i1)
          iterate
   end  /* Do */
   astrat=pos('*',doit.mm.!sel)
   if doit.mm.!ssi<>1 |  astrat=0   then do
          i1=i1+1
          a=cvcopy(doit.mm,daindx.i1)
          iterate
  end

/* expand 'em */
    dnameonly=0
    boog=translate(doit.mm.!sel,'\','/')
    boog=delstr(boog,astrat)
    oou=lastpos('\',boog)
    if oou=0 then
        selhead='\'
    else
        selhead=left(boog,oou)
    if symbol('DOIT.'mm'.!DIR')='VAR' then do
        ddir=strip(upper(doit.mm.!dir))
        if abbrev(ddir,'HTTP://')=1 then iterate     /* can't do this one */
        if symbol('DOIT.'mm'.!DIR_NAMEONLY')='VAR' then do
              dnameonly=doit.mm.!dir_nameonly
        end
    end
    ddir=strip(translate(ddir,'\','/'),,'\')
    ldir=length(ddir)+1

    afile=fig_afile(ddir,doit.mm.!sel,dnameonly)

    wow=sysfiletree(afile,fils,'F')
    if fils.0=0 then iterate            /* no matches */
    do ir=1 to fils.0
        i1=i1+1
        bfile=strip(word(fils.ir,5))
        if dnameonly=0 then do
             cfile=substr(bfile,ldir)
        end
        else do
             quse=filespec('n',bfile)
             cfile=selhead||quse
        end
        foo=cvcopy(doit.mm,daindx.i1)
        daindx.i1.!sel=translate(cfile,'/','\')
     end

end /* do */
daindx.0=i1             
if verbose>1 then call pmprintf_sref('SREFAST ssi daemon: read 'todos.0 ' lines, wrote ' daindx.0 ' entries ')


return daindx.mm

badline:
signal off error ; signal off syntax
call pmprintf_sref(' SREFAST ssi daemon: error in  configuration file ('ooindx ') near line 'kk)

return 0


/***************************************/
/* check and change stamps */
check_stamps:procedure expose initfast_stamp initfilt_stamp virtual_stamp repstrgs_stamp VERBOSE
parse arg ooindx,initfilt_file,repstrgs_file,virtual_file

ACHANGE=0

redo=value('sref_fast_redo',0,'os2environment')
if redo=1  then do
  if verbose>1 then call pmprintf_sref(' SREFAST ssi daemon: SREF_FAST_REDO set ')
  achange=1
end

 aa=sysfiletree(ooindx,bb,'FT')
 astamp=space(upper(bb.1))
 if astamp<>initfast_stamp then do
        if verbose>1  then call pmprintf_sref(' SREFAST ssi daemon: Change in INITFAST detected ')
        INITFAST_STAMP=ASTAMP
        achange=1
  end   /* iter > 0 */

 aa=sysfiletree(INITFILT_FILE,bb,'FT')
 astamp=space(upper(bb.1))
 if astamp<>INITFILT_stamp then do
        if verbose>1  then call pmprintf_sref(' SREFAST ssi daemon: Change in INITFILT detected ')
        INITFILT_STAMP=ASTAMP
        achange=1
  end   /* iter > 0 */

 aa=sysfiletree(VIRTUAL_FILE,bb,'FT')
 astamp=space(upper(bb.1))
 if astamp<>VIRTUAL_stamp then do
        if verbose>1  then call pmprintf_sref(' SREFAST ssi daemon: Change in VIRTUAL.IN detected ')
        VIRTUAL_STAMP=ASTAMP
        achange=1
  end   /* iter > 0 */

 aa=sysfiletree(REPSTRGS_FILE,bb,'FT')
 astamp=space(upper(bb.1))
 if astamp<>REPSTRGS_stamp then do
        if verbose>1  then call pmprintf_sref(' SREFAST ssi daemon: Change in REPSTRGS.IN detected ')
        REPSTRGS_STAMP=ASTAMP
        achange=1
  end   /* iter > 0 */


RETURN ACHANGE

