/* ------------------------------------------------- */
/* SREFAST routine */
/* Routine to load main srefilter, and srefast postfilter, into macrospace */
/* ------------------------------------------------- */

load_bigone:

/*--------------   Load REXX libraries ----- */
/* Load up advanced REXX functions */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'

  call SysLoadFuncs
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end

parse arg aport

if aport="" then do
    say " This SRE-Filter procedure is not meant to be run in stand alone mode "
    exit
end

aroutine='SREF_MAIN_'||aport

foo=macrodrop(aroutine)   /* makesure you refresh on first transaction */
aff='SREFILTR.'||aport
say " SREFAST: Loading main SRE-Filter code into macrospace: "aff
foo2=macroadd(aroutine,aff)
if foo2=0 then do
        say " SREFAST error: problem loading sre-filter main program into macrospace "foo2
        'string Server is busy, try again later '
         exit ' '
end

/* load up post filter thing */
aroutine='SREF_FAST_POSTF'
foo=macrodrop(aroutine)   /* makesure you refresh on first transaction */
say " SREFAST: Loading SREFAST postfilter into macrospace "
aff='SREFAST4.CMD'
foo2=macroadd(aroutine,aff)
if foo2=0 then do
        say " SREFAST error: problem loading sre-filter postfilter routine into macrospace "foo2
        exit ' '
end

/* set an environment variable */
call value 'SREF_'||aport||'_SREFAST',1,'os2environment'


return 0



