/* DOPUT -- send a file to a HTTP server, using the PUT verb */
/* Call as:  DOPUT serveraddress url_to_use filename                   */
/* ------------------------------------------------------------------- */
/* This program requires that the RxSock.DLL be in your LIBPATH (it is */
/* usually in your \TCPIP\DLL directory.  It was shipped with the      */
/* August 1994 CSD for the TCP/IP base (UN64092).                      */

call load /* load functions if necessary */

say " Program to test the POST verb "

say " Issue a GET method request to an HTTP server, and display complete response "
parse arg server request .
if server="" then do 
    mehost=get_hostname()
    say " Please enter server address (ENTER= " mehost ": "
    parse pull server
    if server="" then server=mehost
end  /* Do */
if request="" then  do
  say " Please enter url to GET: "
  parse pull request
end

use_Url=request

say " Enter a message string to include in body "
parse pull amessage
amessage=translate(amessage,'+',' ')

crlf    ='0d0a'x                        /* constants */
family  ='AF_INET'
httpport=80

rc=sockgethostbyname(server, "serv.0")  /* get dotaddress of server */
if rc=0 then do; say 'Unable to resolve "'server'"'; exit; end
dotserver=serv.0addr                    /* .. */

gosaddr.0family=family                  /* set up address */
gosaddr.0port  =httpport
gosaddr.0addr  =dotserver

gosock = SockSocket(family, "SOCK_STREAM", "IPPROTO_TCP")


message='POST ' use_url ' HTTP/1.0'crlf
message=message||'Content-type:application/x-www-form-urlencoded'||crlf
message=message||'Content-length:'||length(amessage)||crlf

message=message||crlf||amessage

got=''
rc = SockConnect(gosock,"gosaddr.0")
if rc<0 then do; say 'Unable to connect to "'server'"'; exit; end
rc = SockSend(gosock, message)
say " bytes transfered = " rc " .. waiting for reply .... "

/* Now wait for the response */
do r=1 by 1
  rc = SockRecv(gosock, "response", 1000)
  got=got||response
   say '>'rc'/>' ||length(response)
  if rc<=0 then leave
  end r
rc = SockClose(gosock)

say 'Got' length(got) 'bytes of response'
say " Hit ENTER to see response headers ... "
parse pull ooo
dd=crlf||crlf
parse var got  hd (dd) bd
say "Reponse Headers:"
say hd
say ; say " Hit ENTER to see response body ... "
parse pull ooo

say  bd
exit

/* --- Load the function library, if necessary --- */
load:
if \RxFuncQuery("SockLoadFuncs") then return      /* already there */
call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
call SockLoadFuncs
return


/* get the hostname (aa.bb.cc) for this machine */
get_hostname: procedure
    do queued(); pull .; end                   /* flush */
    address cmd '@hostname'  '| rxqueue'    
    parse pull hostname                        
    return hostname

