/*  */
accescfg:

CHECKIT=0   /* Change this to 0 if you want to enable REMOTE configuration by SUPERUSERS */

/* background color */
USECOLOR='2dd52f'

/* ---------------- DO NOT MODIFY BELOW THIS LINE  ------------------ */

parse arg ddir,tempfile,sel,list,verb,uri,user,basedir,workdir,privset,enmadd,transaction,verbose

list=translate(list, ' ', '+'||'090a0d'x)  /* Whitespace, etc. */

if verb="" then do
   say " This SRE-Filter add-on is NOT meant to be run from the command line."
   say " It can be invoked by using CONFIGUR.HTM "
   exit
end  /* Do */



who2=extract('CLIENTADDR')
saddr2=extract('SERVERADDR')

NO_REM=VALUE('SREF_NO_REMOTE_CONFIG',,'OS2ENVIRONMENT')


select
   when checkit=1 | no_rem> 0 then do

/* only if user = serveraddress !!! */
     if who2<>saddr2 | no_rem=2 then do

        call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>SRE-FILTER  remote configurator disabled </title>"
        call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'"> '

        call lineout tempfile,' <strong> Action not allowed remotely.</strong> <pre>'
        call lineout tempfile,' </body> </html> '
        call lineout tempfile
        'FILE ERASE TYPE text/html NAME' tempfile
        return 'ACCESCFG: action not allowed remotely. '
     end
   end
   otherwise do
      if wordpos('SUPERUSER',privset)=0 then do
       'RESPONSE HTTP/1.0 401 Unauthorized '     /* Set HTTP response line */
        'header add WWW-Authenticate: Basic Realm=<CONFIGURE>'  /* challenge */

        call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
        call lineout tempfile, "<html><head><title>Not authorized </title>"
        call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'"> '


        call lineout tempfile,' <strong> You do not have configuration rights.</strong> <pre>'
        if who2=saddr2 then 
                call lineout tempfile,'<br> <Em> You may want to edit ACCESCFG.CMD </em> '
        call lineout tempfile,' </body> </html> '
        call lineout tempfile
         iia=dosdir(tempfile,'s')

        'FILE ERASE TYPE text/html NAME' tempfile
        return '401 'iia' ACCESCFG: not permitted to configure. '
      end
   end
end

list=strip(list)
select 
   when upper(list)='TODO=SHOW' | upper(list)='TODO=SHOW_HEADER' then
        signal doshow
   when upper(list)='TODO=SET' then
        signal doset
   otherwise
        signal dochange
end  /* select */


/* jump here to show values */
doshow:


accessfile=value(enmadd||'ACCESS_FILE',,'os2environment')
   call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
   call lineout tempfile, "<html><head><title>SRE-Filter: SEL-Specific access control </title>"
   call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'"> '


aa=sref_fileread(accessfile,'lins',,'E')
foo=do_extends(1)

call lineout tempfile, "<h1> SRE-Filter:  SEL-Specific access control  </h1> <p>"
if upper(list)='TODO=SHOW' then
  call lineout tempfile, "<h2> List of "header" comments </h2> <pre> <blockquote>"
else
  call lineout tempfile, "<h3> Brief descripton  </h3> <pre> <blockquote>"

/* show "header comments" */
iat=0
do until iat >= lins.0
   iat=iat+1
   if  abbrev(strip(lins.iat),';')  then do
        foo=strip(lins.iat) ;foo=strip(foo,'l',';')
         call lineout tempfile, foo 
   end  /* Do */
   else do
        leave
   end
end /* do -- iat is the first non header comment line  */
call lineout tempfile, '</blockquote></pre> '

/* view descriptive header only? */
if upper(list)='TODO=SHOW_HEADER' then do
   call lineout tempfile,' <hr> </body></html>'
   call lineout tempfile
   'file erase  type text/html name  ' tempfile
   return ' done '
end  /* Do */



/* read in usernames, etc */
nusers=0
call lineout tempfile, '<hr> <h2> A List of selector specific access controls </h2> '
call lineout tempfile,' Notes: <ul> '
call lineout tempfile,' <li> SEL-specific access controls are stored in: ' accessfile
call lineout tempfile,' <li> <em>Comments are in italics </em> '
call lineout tempfile,' <li> In <b>Candiate SEL:</b> The <strong>*</strong> character is used as a wildcard (for an arbitrarily long string)'
call lineout tempfile, ' <li> Entries with no <strong>Host Nickname</strong> apply to all requests'
call lineout tempfile,' <li> The <strong>Realm</strong> is sent to the client (when responding to UnAuthorized requests),'
call lineout tempfile,'  and as a shorthand for a <EM>set of resource privileges</EM>'
call lineout tempfile,' <li> The <em>optional</em> <strong> Failure File</strong> is used when responding to <code>Unauthorized</code> requests <br>'
call lineout tempfile,' <li> The <em>optional </em> <b> ADV_OPTS</b> (advanced options</u>) is used to specify additional <em>request selector </em> options '
call lineout tempfile,' <LI>In the <STRONG>Resource Privileges</STRONG> list: <menu> <li><STRONG> *</STRONG> :  <em>any privilege will do</em> '
call lineout tempfile,' <LI><STRONG> NO</STRONG> : No accesss (SUPERUSERS and In-House users only!)  </menu> </ul> '
call lineout tempfile,' <table border=1> <th> Host Nickname </th>'
call lineout tempfile,' <th> Candidate SEL or <br> Realm Name </u> </th>'
call lineout tempfile,'  <th> Resource Privileges List </th>'
call lineout tempfile,'  <th> Permissions list ......</th> <th> Realm </th> <th>Failure File  </th><th> Adv_opts File</th> <tr>'

do mm=iat to lins.0
  if lins.mm=' ' then iterate
  stlin=upper(strip(lins.mm))
  if  abbrev(stlin,';')=1 then do
       call lineout tempfile,'<td colspan=5>  <code>     </code> <em>' strip(strip(lins.mm),'l',';') '</em></td> <tr> '
  end
  else do
      if abbrev(stlin,'!REALM')=1  then do
         parse var stlin foo candurl accpriv
         call lineout tempfile,'<td colspan=2>  ......... <em> Realm name: </em> <STRONG> ' candurl '</STRONG> </td>'
         call lineout tempfile,'<td colspan=4>  &nbsp; <STRONG> 'accpriv '</STRONG> </td> <tr>'
      end
      else do
        if pos('// ',lins.mm)>0 then do
           parse var stlin hostname '//' candurl accpriv ',' permissions ',' realm ',' fail_file ',' adv_opts
        end
        else do
           hostname=' .. '
           parse var stlin candurl accpriv ',' permissions ',' realm ',' fail_file ',' adv_opts
        end  /* Do */
       IF ACCPRIV=' ' THEN ACCPRIV='*'
       IF PERMISSIONS=' ' THEN PERMISSIONS='..'
       IF REALM=' ' THEN REALM='..'
       if fail_file=' ' then fail_file='..'
       if adv_opts=' ' then adv_opts='..'
       call lineout tempfile,'<td>   &nbsp; <STRONG>  'hostname '</STRONG> </td>'
       call lineout tempfile,'<td>  &nbsp; <STRONG> ' candurl '</STRONG> </td>'
       call lineout tempfile,'<td>  &nbsp; <STRONG> 'accpriv '</STRONG> </td>'
       call lineout tempfile,'<td>  &nbsp; <STRONG> 'permissions ' </STRONG></td> '
       call lineout tempfile,'<td>  &nbsp; <STRONG> 'realm'  </STRONG></td> '
       call lineout tempfile,'<td>  &nbsp; <STRONG> ' fail_file'  </STRONG> </td> '
       call lineout tempfile,'<td>  &nbsp; <STRONG> ' adv_opts'  </STRONG></td> <tr>'


    end /* do  urls */
  end           /* non comment line */

end /* mm */
call lineout tempfile,' </table>'

call lineout tempfile,'<hr><h3> Definitions of the Permissions </h3>'
foo=show_permissions()



call lineout tempfile,' <hr> Thanks for checking </body></html>'

call lineout tempfile

foo=sref_expire_response(0.05,dosdir(tempfile))
'file erase  type text/html name  ' tempfile
return ' done '



/* jump here if "set values" chosen */
doset:
accessfile=value(enmadd||'access_FILE',,'os2environment')
aa=sref_fileread(accessfile,'lins',,'E')
foo=do_extends(1)

call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
call lineout tempfile, "<html><head><title>SRE-Filter: modify  SEL-specific access controls </title>"
 call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'"> '


/* ignore header stuff */
iat=0
do until iat >= lins.0
   iat=iat+1
   if  abbrev(strip(lins.iat),';') | lins.iat=' ' then iterate
   leave
end /* do -- iat is the first non header comment line  */
call lineout tempfile, "<h1> SRE-Filter: modify <A NAME="top">SEL-specific access controls</A>  </h1> <p>"
call lineout tempfile,' <blockquote> You can modify, remove, or add SEL-specific access controls and realm definitions.'
call lineout tempfile,' <br><em> Questions? <A HREF="#notes">The notes might help.</A> </em> </blockquote> '
call lineout tempfile,' <h2> Modify or remove SEL-specific access controls </h2>'
call lineout tempfile,'  Note that the input fields are wider then the displayed area. '
call lineout tempfile,'<FORM ACTION="/accescfg" METHOD="POST">'
call lineout tempfile,' <table border=1> <th> Host Nickname  <br> (see below  for a <br>listing of <A HREF="#hosts">current hosts</A>) </th>'
call lineout tempfile,' <th> Candidate SEL  <br> (set to blank to  <br> delete the entry)</th>'
call lineout tempfile,'  <th> Resource privileges </th>'
call lineout tempfile,' <th nowrap> Permissions list....</th> '
call lineout tempfile,'  <th nowrap>Realm, <br> Failure File, &amp; Adv_options File</th> <tr>'

nhidden=0 ; mm=0 ; nrealms=0
do mm0=iat to lins.0
    alin=strip(translate(lins.mm0,' ','1a000d0a'x))
    mm=mm+1

/* non comment */
    select
      when  abbrev(alin,';')=1 | alin=' ' then do /* comment */
         nhidden=nhidden+1
         alin=sref_replacestrg(alin,'"','&quot;','ALL')
         hiddens.nhidden='<INPUT TYPE="HIDDEN" name="COMMENT.'||mm||'"  value="'||alin||'" >'
         iterate
       end
       when abbrev(alin,'!REALM') then do       /* realm definition */
          parse var alin foo1 realmname accprivs
          nrealms=nrealms+1
          realmvs.therealmname.nrealms=realmname
          realmvs.theaccprivs.nrealms=accprivs
          realmvs.themm.nrealms=mm
          iterate
       end
       when pos('// ',alin)>0 then do   /* host specific entry */
             parse var alin hostname '//' candurl accprivs ',' permlist ',' realm ',' fail_file ',' adv_opts
       end
       otherwise do                     /* generic entry */
             hostname='  '
             parse var alin  candurl accprivs ',' permlist ',' realm ',' fail_file ',' adv_opts
       end
     end  /* Do */

     call lineout tempfile,'<td> <EM>Host nickname:</EM> <br> <INPUT TYPE="text" NAME="hostname.'||mm||'"'
     call lineout tempfile,'value="'hostname'" SIZE=8 MAXLENGTH=95> </td> '
     call lineout tempfile,'<td> <EM>Candidate SEL:</EM> <br> <INPUT TYPE="text" NAME="candurl.'||mm||'"'
     call lineout tempfile,'value="'candurl'" SIZE=20 MAXLENGTH=95> </td> '
     call lineout tempfile,'<td> <EM>Resource privileges:</EM> <br> <INPUT TYPE="text" NAME="accprivs.'||mm||'"'
     call lineout tempfile,'value="'accprivs'" SIZE=40 MAXLENGTH=95> </td> '
 
     cacheok=0  ;      NO_SSI=0  ;     NO_SSP=0 ;no_code=0
     ADELETE=0 ;     APUT=0
     NO_VIRTUAL=0 ;     NO_ALIAS=0  ;     NO_POSTFILTER=0
     no_htaccess=0

     IF wordpos('CACHE',upper(permlist))>0 then            CACHEOK=1
     if wordpos('NO_SSI',upper(permlist))>0 then            NO_SSI=1
     if wordpos('NO_SSP',upper(permlist))>0 then            NO_SSP=1
     if wordpos('NO_CODE',upper(permlist))>0 then            NO_CODE=1
     if wordpos('DELETE',upper(permlist))>0 then            ADELETE=1
     if wordpos('APUT',upper(permlist))>0 then              APUT=1
     if wordpos('NO_HTACCESS',upper(permlist))>0 then         NO_htaccess=1
     if wordpos('NO_VIRTUAL',upper(permlist))>0 then         NO_VIRTUAL=1
     if wordpos('NO_ALIAS',upper(permlist))>0 then          NO_ALIAS=1
     if wordpos('NO_POSTFILTER',upper(permlist))>0 then      NO_POSTFILTER=1

/*say mm cacheok no_ssi no_code no_ssp adelete aput no_virtual no_alias no_postfilter no_htaccess */

    call lineout tempfile,' <td>'
    a=MAKECHECK('Cache?','CACHE',MM,CACHEOK)
    call lineout tempfile,' <br>'
    a=makecheck('No SSI? ', 'NO_SSI',mm,no_ssi)
    call lineout tempfile,' <br>'
    a=makecheck('No SSP ', 'NO_SSP',mm,no_ssp)
    call lineout tempfile,' <br>'
    a=makecheck('No CODE ', 'NO_CODE',mm,no_code)
    call lineout tempfile,' <br>'
    a=makecheck('DELETE?   ', 'DELETE',mm,adelete)
    call lineout tempfile,' <br>'
    a=makecheck('PUT? ', 'PUT',mm,aput)
    call lineout tempfile,' <br> '
    a=makecheck('No HTACCESS?  ', 'NO_HTACCESS',mm,no_htaccess)
    call lineout tempfile,' <br>'
    a=makecheck('No Virtual?  ', 'NO_VIRTUAL',mm,no_virtual)
    call lineout tempfile,' <br>' 
    a=makecheck('No Alias? ', 'NO_ALIAS',mm,no_alias)
    call lineout tempfile,' <br>'
    a=makecheck('No Postfilter? ', 'NO_POSTFILTER',mm,no_postfilter)
    call lineout tempfile,' </td>'

     realm=strip(realm); fail_file=strip(fail_file) ;adv_opts=strip(adv_opts)
     call lineout tempfile,'<td> <em>Realm: </em><br> <INPUT TYPE="text" NAME="realm.'||mm||'"'
     call lineout tempfile,'value="'realm'" SIZE=8 MAXLENGTH=95>   '
     call lineout tempfile,'<br> <em>Failure File: </em><br> <INPUT TYPE="text" NAME="fail_file.'||mm||'"'
     call lineout tempfile,'value="'fail_file'" SIZE=8 MAXLENGTH=95> <br> '
     call lineout tempfile,'<br> <em>Adv_opts File: </em><br> <INPUT TYPE="text" NAME="adv_opts.'||mm||'"'
     call lineout tempfile,'value="'adv_opts'" SIZE=8 MAXLENGTH=35> <br>'

     call lineout tempfile,' </td> '

     if mm0<lins.0 then do
           call lineout tempfile,'<tr>' ; call lineout tempfile,' '
     end
end
call lineout tempfile,' </table>' ; call lineout tempfile,' '

if nrealms>0 then do
  call lineout tempfile,' '; call lineout tempfile,'<p><h2> Modify/delete Realms </h2>'
  call lineout tempfile,' <table border=1> '
  call lineout tempfile,' <th> Realm name <br> (set to blank to   delete <br> the entry)</th>'
  call lineout tempfile,'  <th> Realm-specific resource privileges list </th> <tr>'
  do jh=1 to nrealms
     call lineout tempfile,'<td> <EM>Realm name:</EM> <br> <INPUT TYPE="text" NAME="realmname.'||realmvs.themm.jh||'"'
     call lineout tempfile,'value="'realmvs.therealmname.jh'" SIZE=8 MAXLENGTH=95> </td> '
     call lineout tempfile,'<td> <EM>Resource privileges:</EM> <br> <INPUT TYPE="text" NAME="accprivs.'||realmvs.themm.jh||'"'
     call lineout tempfile,'value="'realmvs.theaccprivs.jh'" SIZE=40 MAXLENGTH=95> </td> '
     if jh<nrealms then do
       call lineout tempfile,'<tr>' ; call lineout tempfile,' '
     end
 end /* do jh */
 call lineout tempfile,'</table>' ; call lineout tempfile,' '
end

/* --- allow user to enter a few new names */
call lineout tempfile,' </table>  <hr width=40%> <h2> Add new SEL-specific access controls </h2> '
mm0=mm
call lineout tempfile,' <table border=1> <th> Host Nickname  </th>'
call lineout tempfile,' <th> Candidate SEL  </th>'
call lineout tempfile,'  <th> Resource privileges </th>'
call lineout tempfile,' <th nowrap>Permissions list .....</th> '
call lineout tempfile,'  <th nowrap>Realm  <br> Failure File <br> &amp; Adv_opts</th> <tr>'

do mm=mm0+1 to mm0+3
     call lineout tempfile,'<td> <EM>Host nickname:</EM> <br> <INPUT TYPE="text" NAME="hostname.'||mm||'"'
     call lineout tempfile,'value=" " SIZE=8 MAXLENGTH=95> </td> '
     call lineout tempfile,'<td> <EM>Candidate SEL:</EM> <br> <INPUT TYPE="text" NAME="candurl.'||mm||'"'
     call lineout tempfile,'value=" " SIZE=20 MAXLENGTH=95> </td> '
     call lineout tempfile,'<td> <EM>Resource privileges:</EM> <br> <INPUT TYPE="text" NAME="'accprivs.||mm||'"'
     call lineout tempfile,'value=" " SIZE=40 MAXLENGTH=95> </td> '
    call lineout tempfile,' <td>'
    a=MAKECHECK('Cache?','CACHE',MM,0)
    call lineout tempfile,' <br>'
    a=makecheck('No SSI?  ', 'NO_SSI',mm,0)
    call lineout tempfile,' <br>'
    a=makecheck('No SSP? ', 'NO_SSP',mm,0)
    call lineout tempfile,' <br>'
    a=makecheck('No CODE? ', 'NO_CODE',mm,0)
    call lineout tempfile,' <br>'
    a=makecheck('DELETE?  ', 'DELETE',mm,0)
    call lineout tempfile,' <br>'
    a=makecheck('PUT? ', 'PUT',mm,0)
    call lineout tempfile,' <br>'
     a=makecheck('No HTACCESS?  ', 'NO_HTACCESS',mm,0)
     call lineout tempfile,' <br>'
    a=makecheck('No Virtual?  ', 'NO_VIRTUAL',mm,0)
    call lineout tempfile,' <br>' 
    a=makecheck('No Alias? ', 'NO_ALIAS',mm,0)
    call lineout tempfile,' <br>'
    a=makecheck('No Postfilter? ', 'NO_POSTFILTER',mm,0)
    call lineout tempfile,' </td>'

     call lineout tempfile,'<td> <em>Realm: </em><br> <INPUT TYPE="text" NAME="realm.'||mm||'"'
     call lineout tempfile,'value=" " SIZE=8 MAXLENGTH=95> <br>'

     call lineout tempfile,'<em>Failure File: </em><br> <INPUT TYPE="text" NAME="fail_file.'||mm||'"'
     call lineout tempfile,'value=" " SIZE=8 MAXLENGTH=95>'

     call lineout tempfile,'<em>Adv_opts File: </em><br> <INPUT TYPE="text" NAME="adv_opts.'||mm||'"'
     call lineout tempfile,'value=" " SIZE=8 MAXLENGTH=95>'

     call lineout tempfile,' </td>'

     if mm<mm0+3 then call lineout tempfile,' <tr> '
end
call lineout tempfile,'</table> <p>'

call lineout tempfile,' <h3> Define a new realm </h3> '
mm0=mm0+4
call lineout tempfile,' <u><EM>Realm name:</EM></u>  <INPUT TYPE="text" NAME="realmname.'||mm0||'"'
call lineout tempfile,'value=" " SIZE=8 MAXLENGTH=95>  <br>  '
call lineout tempfile,' <u><EM>Realm-specific resource privileges:</EM></u>  '
call lineout tempfile,' <INPUT TYPE="text" NAME="accprivs.'||mm0||'"'
call lineout tempfile,'value=" " SIZE=40 MAXLENGTH=95>  '



/* ----- add comments information */

do jj=1 to nhidden
   call lineout tempfile,hiddens.jj
end /* do */
call lineout tempfile,' <input type="hidden" name="entries" value="'||mm0||'"> <p> '
call lineout tempfile,' <p><input type="submit"> <input type="reset"> </form> '


call lineout tempfile,' <hr> <h3> <A NAME="notes">Notes</A> </h3> <ul>'
call lineout tempfile,' <li> SEL-specific privileges are stored in: 'accessfile

call lineout tempfile,'<li> There are two types of <b>resource privileges </b>:'
call lineout tempfile,'<dl><dt>ONE_OF (the default type).'
call lineout tempfile,'<dd> The client must have "one of" the  ONE_OF privileges.'
call lineout tempfile,'<dt> MUST_HAVE (start with the &amp; character)'
call lineout tempfile,'<dd> The client "must have" <b>all</b> the MUST_HAVE privileges.'
call lineout tempfile,'</dl>'
call lineout tempfile,' Note: if only one privilege is specified, these two types are equivalent.<p>'
call lineout tempfile,' <LI>There are two special ONE_OF privileges: <menu> <li> <STRONG>*</STRONG> :  <em>any privilege will do</em> '
call lineout tempfile,' <LI> <STRONG>NO</STRONG> : No access allowed (SUPERUSERS and INHOUSE user only!) </menu>'
call lineout tempfile,' <li> Do you want to view a  more complete description of '
call lineout tempfile,' <a href="/accescfg?TODO=SHOW_HEADER"> SEL-specific access controls </a>?'
call lineout tempfile,' <li> To add more entries, just rerun this several times <br> or edit ' accessfile
call lineout tempfile,' <li> <em>Comments are NOT displayed </em>  <li> Case is ignored '
call lineout tempfile,' <li> Use a<strong>* </strong> in the <em>candidate SEL </em> as a wildcard character</em>'
call lineout tempfile,'<pre> <em>Discussion of match precedence and wildcarding</em>:'
call lineout tempfile,'   If a <em>request selector </em> can match several <em>candidate SELs</em>...'
call lineout tempfile,'     1) Exact matches take precedence'
call lineout tempfile,'     2) The  <em>wildcard matching candidate SEL </em> with the "longest portion before the *"'
call lineout tempfile,'        is used.'
call lineout tempfile,'     Thus, if the <em> request selector is </em> FOOD/FRUIT/ORANGES.HTM'
call lineout tempfile,'     then the  following would match (with diminishing precedence, '
call lineout tempfile,'     the first being chosen before last):'
call lineout tempfile,'               FOOD/FRUIT/ORANGES.HTM  (the exact match)'
call lineout tempfile,'               FOOD/FRUIT/*'
call lineout tempfile,'               FOOD/*'
call lineout tempfile,' </pre><li> Definitions of the permissions:'
call show_permissions

call lineout tempfile, ' <li> Entries with no <strong>host nickname</strong> will apply to all requests'
call lineout tempfile,' <li> If specified (and if <var>ACCESS_FAIL_FILE</var>  &lt; &gt; 0): the <em>failure file</em> is sent '
call lineout tempfile,'   if the client does not have access privileges.'
call lineout tempfile,' <li> The ADV_OPTS file (the <u>advanced options file</u>) should be relative to the GoServe working directory "'
call lineout tempfile,'</ul> <br>'

call lineout tempfile,' <h3> A list of the<A NAME="hosts"> current hosts</A> </h3>  <blockquote> '

ii=value(enmadd||'HOSTS.0',,'os2environment')
if ii>0 then do
call lineout tempfile,' <table> <th> IP address </th> <th> Host Nickname </th> <th> Data Directory </th> <tr> '
do ll=1 to ii
   wow=value(enmadd||'HOSTS.'||ll,,'os2environment')
   parse var wow ip ',' hn ',' hdir
   call lineout tempfile,' <td> ' ip  '</td> <td> ' hn ' </td> <td> ' hdir '</td> <tr> '
end /* do */
call lineout tempfile,' </table> </blockquote>'
end
else do
  call lineout tempfile,' No HOSTS have been defined   </blockquote>'
end
call lineout tempfile,' <p> <A HREF="#top">Return to the top of this form.</A>'
call lineout tempfile,'</body></html>'
call lineout tempfile

foo=sref_expire_response(0.05,dosdir(tempfile))
'file erase  type text/html name  ' tempfile
return ' done '



/* jump here to recrod changes */
dochange:
parse upper var list foo 'ENTRIES=' nentries '&' .
do ii1=1 to nentries
   fillme.ii1.0=0
end /* do */

do until list=""
   parse var list aa '&' list
   parse upper var aa avar '.' aind '=' aval
   aval=packur(aval)
   if abbrev(avar,'ENTRIES=')=1 then iterate
   wow=fillme.aind.0+1
   fillme.aind.0=wow
   fillme.aind.wow.var=avar ; fillme.aind.wow.val=aval
   select
      when avar="COMMENT" then do
          fillme.aind.type='COMMENT'
          parse  var aa foo '=' aval
          fillme.aind.wow.val=packur(aval)
      end
      when avar="CANDURL" then fillme.aind.type='URL'
      when avar="REALMNAME" then fillme.aind.type='REALM'
      
      otherwise nop
   end
end /* do */

accessfile=value(enmadd||'ACCESS_FILE',,'os2environment')
aa=sref_fileread(accessfile,'lins',,'E')
foo=do_extends(1)

/* pull "header comments" */
iat=0
do until iat >= lins.0
   iat=iat+1
   if  abbrev(strip(lins.iat),';')  then do
       newlines.iat=lins.iat
   end  /* Do */
   else do
        leave
   end
end /* do -- iat is the first non header comment line  */
iat=iat-1

do uu=1 to nentries
   select
      when fillme.uu.type='COMMENT' then do
          iat=iat+1
          newlines.iat=fillme.uu.1.val
      end
      when fillme.uu.type='REALM'  then do
          isname=' ' ; ispriv=' ' ;
          do uu2=1 to fillme.uu.0
             chk1=fillme.uu.uu2.var
             if chk1='REALMNAME' then
                isname=fillme.uu.uu2.val
             if chk1='ACCPRIVS' then
                ispriv=fillme.uu.uu2.val
          end
          if isname<>' ' then do
              iat=iat+1
              newlines.iat='!REALM '||isname||' '||ispriv
          end
      end

      when fillme.uu.type='URL' then do
          candurl=' ' ; permlist=' ' ; ishost=' ' ; isrealm=' ' ; ispriv=' '
          isfailfile=' '; isadv_opts=' '
          do uu2=1 to fillme.uu.0
             chk1=fillme.uu.uu2.var
             vvv=fillme.uu.uu2.val
             select
                when chk1='CANDURL' then candurl=vvv
                when chk1='ACCPRIVS' then ispriv=vvv
                when chk1='REALM' then isrealm=vvv
                when chk1='FAIL_FILE' then isfailfile=vvv
                when chk1='HOSTNAME' then ishost=vvv
                when chk1="ADV_OPTS" then isadv_opts=vvv
                otherwise  permlist=permlist' ' chk1
             end
          end
          if candurl<>' ' then do
              iat=iat+1
              newlines.iat=''
              if ishost<>' ' then
                  newlines.iat=ishost||'// '
              newlines.iat=newlines.iat||candurl' 'ispriv ' , ' permlist ' , ' isrealm ' , ' isfailfile ',' isadv_opts
          end
      end
      otherwise do
            nop
      end  /* Do */

  end                   /* select over type */
end                     /* do over entries */

/* save to access_file.. but rename access_file first */
foo=lastpos('.',accessfile)
if foo=0 then
   acf1=accessfile||'.'
else
   acf1=left(accessfile,foo)
do hi=1 to 999
   try1=acf1||hi
   if stream(acf1||hi,'c','query exists')='' then leave
end /* do */
foo=dosrename(accessfile,try1)
newlines.0=iat
foo=filewrite(accessfile,newlines,'R')


call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 3.0//EN">'
call lineout tempfile, "<html><head><titLE> SRE-Filter: Changed SEL-specific access controls </title>"
 call lineout tempfile, '</head><body  bgcolor="#'||usecolor||'"> '

call lineout tempfile,' <h2> SEL-specific access controls have been changed </h2>'
call lineout tempfile,' The SEL-specific access controls have been saved to: ' accessfile
call lineout tempfile,' <p> The old version of 'accessfile' has been moved to ' try1
call lineout tempfile,' </body> </html> '
call lineout tempfile

foo=value('SREF_REDO',1,'os2environment')

foo=sref_expire_response(0.05,dosdir(tempfile))
'FILE ERASE TYPE text/html NAME' tempfile
return 'done change '


MAKECHECK:PROCEDURE expose tempfile
  PARSE ARG message, ANAME, MM ,ISIT
  FOO=' <INPUT TYPE="CHECKBOX" NAME="'||ANAME||'.'||MM||'"'
  if isit=1 then
      foo=foo||' VALUE=1 checked> '||message
  else
      foo=foo||'VALUE=1 >'||message
  foo=foo
  call lineout tempfile,foo
  return 1

/************/
/* Redo ulist, by treating lines starting with , as continuation lines */
do_extends:procedure expose lins.

if lins.0=0 then return
isnew=1
tmps.1=lins.1
do mm=2 to lins.0
   ali=strip(lins.mm)
   if abbrev(ali,',')=0 then do
        isnew=isnew+1
        tmps.isnew=lins.mm
    end
    else do
        tmps.isnew=tmps.isnew||substr(ali,2)
    end
end
do mm=1 to isnew
    lins.mm=tmps.mm
end
lins.0=isnew
return 0


/* display permissions definitions */
show_permissions:procedure expose tempfile
call lineout tempfile,' <pre>'
call lineout tempfile,'          NO_SSI : NO_SSI means "no server side include allowed for this '
call lineout tempfile,'                   selector (SEL) (or a "path" of selectors, if a * appears).  '
call lineout tempfile,'          NO_SSP : NO_SSP means "no server side processing allowed for this selector".'
call lineout tempfile,'                    (this is rarely used)'
call lineout tempfile,'          NO_CODE: NO_CODE means "do not process SELECT or INTERPRET CODE '
call lineout tempfile,'                   ssi keyphrases". It is a subset of NO_SSP (and is ignored if'
call lineout tempfile,'                   a NO_SSP is present).'
call lineout tempfile,'          CACHE:   If present, then ALWAYS cache this selector (given GoServes'
call lineout tempfile,'                    caching is turned on).'
call lineout tempfile,'                   Typically, if logon controls or access controls are in place,'
call lineout tempfile,'                   then no caching is permittted.  Use of CACHE allows one'
call lineout tempfile,'                   to override this general rule for certain files'
call lineout tempfile,'                   (such as sets of commonly used .GIF files).'
call lineout tempfile,'             PUT : Allow PUT method requests to "copy information to" this selector.'
call lineout tempfile,'           DELETE: Allow DELETE method request to "delete" this selector.'
call lineout tempfile,'      NO_HTACCESS: HTACCESS files will not be used for this selector'
call lineout tempfile,'         NO_ALIAS: Aliasing will NOT be done on this selector'
call lineout tempfile,'       NO_VIRTUAL: Virtual directory lookup will NOT be done on this selector'
call lineout tempfile,'                   NOTE: server side includes and server side processing'
call lineout tempfile,'                        (including CGI-BIN scripts) ignore this directive.'
call lineout tempfile,'                        Thus, NO_VIRTUAL should NOT be used as a security'
call lineout tempfile,'                        tool.'
call lineout tempfile,'     NO_POSTFILTER: Post-filter processing and file recording will NOT'
call lineout tempfile,'                         be done on this selector </pre>'
return 0

