/* modify the srefast configuration file */


parse arg  ddir, tempfile, reqstrg,list0,verb ,uri,user, ,
          basedir ,workdir,privset,enmadd,transaction,verbose, ,
         servername,host_nickname,homedir

if verb="" then do
    say " This SRE-Filter configurator is NOT meant to be run from the command line! "
   exit
end  /* Do */
/* chekc for needed_privs: superuser */

NO_REM=VALUE('SREF_NO_REMOTE_CONFIG',,'OS2ENVIRONMENT')


if wordpos('SUPERUSER',upper(privset))=0 | no_rem=2 then do
    'header add WWW-Authenticate: Basic Realm=<SREFAST>'  /* challenge */
     foo=sref_response('unauth', "You do not have configuration rights ",tempfile,servername)
     return foo
end

port=extract('serverport')
optslist=' '
list=translate(list0,' ','+')

do until list=""
   parse var list a1 '&' list
   parse var a1 avar '=' aval ; avar=upper(avar)
   optslist=optslist||' '||avar
   aa='!'||avar
   opts.aa=aval
end /* do */


/* which configuration header ? */

select
  when wordpos('ADDONE',optslist)>0 then  call do_addone  /* add to list */
  when wordpos('REMOVEONE',optslist)>0  then call do_removeone
  when wordpos('REMOVETWO',optslist)>0  then call do_removetwo
  when wordpos('VIEWCONFIG0',optslist)>0  then call do_viewconfig0
  when wordpos('VIEWCONFIG',optslist)>0 then call do_viewconfig
  when wordpos('REFRESH',optslist)>0 then call do_refresh

  otherwise
     string ' Bad option sent to SREFAST ' optslist
end

return 0

/*****************************/
/*  remove an entry, step2 */
do_removetwo:

foo=get_initfast('Removing an Entry')
if foo=0 then return 0
igoo0=doit.0
igoo=0
do mm=1 to doit.0
   aa='V_'||mm
   if wordpos(aa,optslist)>0 then iterate  /* remove this one */
   igoo=igoo+1
   coo=cvcopy(doit.mm,sidx.igoo)
end /* do */
sidx.0=igoo

call lineout tempfile,'<html><head><title>SREFAST: Removing  Entries </title></head>'
call lineout tempfile,'<BODY><H2>Removing entries from the SREFAST configuration file </h2> '

foo=write_cfg(cfgfile)
if foo=0 then
   call lineout tempfile,' <br> <b> Error writing entries (after deletion) </b>'
else
   call lineout tempfile, '<p>' igoo ' of ' igoo0 ' entries retained in SREFAST configuration file '
call lineout tempfile,'</body></html>'
call lineout tempfile
'FILE ERASE type text/html name ' tempfile
 return 0


/*****************************/
/*  remove an entry */
do_removeone:

foo=get_initfast('Remove Entry')
if foo=0 then return 0

call lineout tempfile,'<html><head><title>SREFAST: Remove Entry </title></head>'
call lineout tempfile,'<BODY><H2>Remove an entry from the SREFAST configuration file </h2> '
call lineout tempfile,'<FORM ACTION="/srefast3" METHOD="POST">'
call lineout tempfile,'<input type="hidden" name="REMOVETWO" value=1>'
call lineout tempfile,' Select entries to remove: <ol>'

do ii=1 to doit.0
   call lineout tempfile,'<LI> '
   if  symbol('doit.'||ii||'.!NODO')="VAR" & doit.ii.!nodo=1 then
        call lineout tempfile,' <U>NODO : </u> '
    call lineout tempfile,'<INPUT TYPE="CHECKBOX" NAME="V_'||ii'" VALUE=1> '

   call lineout tempfile,doit.ii.!sel
   if  symbol('doit.'||ii||'.!NODO')="VAR" & doit.ii.!nodo=1 then
        call lineout tempfile,' <U>NODO : </u> '
   if  symbol('doit.'||ii||'.!SERVER')="VAR" then  do
        if doit.ii.!server<>' ' then call lineout tempfile,' <em> (for server <u>: 'doit.ii.!server '</u>) </em> '
    end
end /* do */

call lineout tempfile,'</ol><INPUT TYPE="submit" VALUE="Submit"></form></body></html>'
call lineout tempfile
foo=stream(tempfile,'c','close')
'FILE ERASE type text/html name ' tempfile
return 0

/*****************************/
/*  show working configuration file */
do_viewconfig:

temp_dir=get_value("TEMPDATA_DIR")
temp_dir=strip(TEMP_DIR,'t','\')||'\'

isfast=get_value('SREFAST')

if isfast<>1 then do
    ' STRING SREFAST is not currently in use; working configuration file is not in use '
   return 0
end  /* Do */


idxfile=temp_dir||'_FSTINDX.'||port

if stream(idxfile,'c','query exists')='' then do
   'STRING SREFAST working configuration file (' idxfile ') is not available. Try again in a minute. '
   return 0
end

foo=cvread(idxfile,sidx)
if foo=0 then  do
   'STRING SREFAST configuration file (' idxfile ') was empty '
   return 0
end

oo= write_cfg(tempfile,1)
oo=stream(tempfile,'c','close')
'FILE ERASE TYPE text/html name ' tempfile

return 0

/*****************************/
/*  show configuration file */
do_viewconfig0:

foo=get_initfast('View Configuration')
if foo=0 then return 0
drop sidx.
ff=cvcopy(doit,sidx)
oo= write_cfg(tempfile,1,1)
oo=stream(tempfile,'c','close')
'FILE ERASE TYPE text/html name ' tempfile

return 0

/*****************************/
/*  add an entry */
do_addone:

  dolist='SEL NODO DIR DIR_NAMEONLY HOST SERVER TRIGGER  USERS PWDS  MIME NOCACHE NORECORD SSI '

   cfgfile=basedir||'\INITFAST.'||port
   if stream(cfgfile,'c','query exists')=' ' then do
      doit.0=0
   end  /* Do */
   else do
       foo=get_initfast('Add an Entry',1)
       if foo=0 then  doit.0=0
  end /* do */

  ido=doit.0+1
  if wordpos('ENTRYNUM',optslist)>0 then do
       ient=strip(packur(opts.!entrynum))
      select
         when datatype(ient)<>'NUM' then ient=ido
         when ient<1 then ient=ido
         when ient>ido then ient=ido
         otherwise nop
       end
  end  /* Do */
  if ient<ido then do   /* insert in da middle */
     foo=cvcopy(doit,tmpx)
     drop doit.
     do mm=1 to ient-1
         foo=cvcopy(tmpx.mm,doit.mm)
     end /* do */
     do mm=ient to ido
         mm2=mm+1
         foo=cvcopy(tmpx.mm,doit.mm2)
     end /* do */
  end  /* Do */

  doit.0=ido
  do m1=1 to words(dolist)
      aw=strip(word(dolist,m1))
      if wordpos(aw,optslist)=0 then iterate
      amm='!'||aw
      if aw="MIME" & upper(opts.amm)="OTHER" then  opts.amm=opts.!mime2

      opts.amm=packur(opts.amm)
      if opts.amm=' ' then iterate
      doit.ient.amm=packur(opts.amm)

  end /* do */

  if symbol('DOIT.'||ient||'.!SEL')<>'VAR' | doit.ient.!sel="" then do
          string ' Error:  no SEL specified '
          return 0
     end

/* check special cases*/
if wordpos('USERS',optslist)>0 then do
     if wordpos('PWDS',optslist)=0  then do
          string ' Error: ' words(users)' USERS specified with no PWDS '
          return 0
     end
     if words(doit.ient.!users)<>words(doit.ient.!pwds) then do
           string 'Error: ' words(doit.ient.!users) ' USERS, but ' words(doit.ient.!pwds) ' PWDS '
          return 0
     end
end

call lineout tempfile,'<html><head><title>SREFAST: Adding  Entry </title></head>'
call lineout tempfile,'<BODY><H2>Adding an entry to the SREFAST configuration file </h2> '

foo=cvcopy(doit,sidx)
oo=write_cfg(cfgfile)
if oo=0 then
    call lineout tempfile,'<br> Error writing SREFAST configuration file: 'cfgfile
else
   call lineout tempfile,' <p> <b>' doit.ient.!sel ' </B> added to SREFAST index file  as entry # ' ient

call lineout tempfile,'</body></html>'
call lineout tempfile
'FILE ERASE type text/html name ' tempfile
 return 0


/******************/
/* save results to srefstcf.80 file */
write_cfg:procedure expose sidx. port tempfile enmadd
parse arg aout,notascfg,isorig

nossi=sidx.!nossi
drop sidx.!nossi
oo=cvtails(sidx,yeeks)

do ii=1 to yeeks.0
     parse var yeeks.ii  ik '.' pook
     oog.ii=left(ik,8)||'.'||pook
end /* do */

oog.0=yeeks.0
boop=arraysort(oog,,,1,5,'A','N',9,,'A')
if boop<>1 then return 0

if notascfg<>1 then do
   idd=lastpos('.',aout)
   idd2=aout
   if idd>0 then   idd2=delstr(aout,idd)
   aoutbak=dostempname(idd2||'.b??')
   foo=dosrename(aout,aoutbak)
   call lineout tempfile, ' <br> Prior version saved as : <tt> ' aoutbak '</tt>'
   call lineout aout,'; Configuration for SREFAST: '||date('n')||' '||time('n')
   call lineout aout,'; Use SREFAST.HTM to modify this, or read SREFAST.DOC for details.'

   do mm=1 to oog.0
      aw=space(strip(oog.mm),0)
      if aw='0.' then aw='0'
      if datatype(sidx.aw)='NUM'  then
         call lineout aout, 'DOIT.'||aw||'='|| sidx.aw
      else
         call lineout aout,'DOIT.'||aw||'="'|| sidx.aw|| '"'
   end /* do */
   call lineout tempfile, ' <br> ' oog.0 ' lines written to: <tt> ' aout '</tt>'

end
else do                 /* write as a report, not as an "interpretable" file */
  if isorig<>1 then do
     call lineout aout,'<html><head><title>SREFAST: Display Entries </title></head>'
     call lineout aout,' <body>'
    call lineout aout,' <h2> SREFAST: Usage Stats and Working Configuration File </h2>'

  /* some stats */
   iscsh=value(enmadd||'SREF_FAST_CACHE',,'os2environment')
   ismain=value(enmadd||'SREF_FAST_MAIN',,'os2environment')
   isfast=value(enmadd||'SREF_FAST_FAST',,'os2environment')
   if iscsh=' ' then iscsh=0
   if ismain=' ' then ismain=0
   if isfast=' ' then isfast=0
   itot=max(iscsh+ismain+isfast,1)

   biscsh=value(enmadd||'SREF_FAST_BYTES_CACHE',,'os2environment')
   bismain=value(enmadd||'SREF_FAST_BYTES_MAIN',,'os2environment')
   bisfast=value(enmadd||'SREF_FAST_BYTES_FAST',,'os2environment')
   if biscsh=' ' then biscsh=0
   if bismain=' ' then bismain=0
   if bisfast=' ' then bisfast=0
   bitot=max(biscsh+bismain+bisfast,1)


   pctcsh=format(100*iscsh/itot,4,2) ; pctfast=format(100*isfast/itot,4,2)
   pctmain=format(100*ismain/itot,4,2)

   bpctcsh=format(100*biscsh/bitot,4,2) ; bpctfast=format(100*bisfast/bitot,4,2)
   bpctmain=format(100*bismain/bitot,4,2)
   select
      when bitot>1000 & bitot<2000000 then
         bitot=format(bitot/1000,4,0)||'K'
      when bitot>= 2000000 then
          bitot=format(bitot/1000000,7,1)||'M'
      otherwise nop
   end
 
   call lineout tempfile,' <h3> Some Usage Statistics </h3>'
   call lineout tempfile,' # SREFAST transactions (bytes)=' itot ' (' bitot ')<br>'
   call lineout tempfile,' % transactions from GoServe cache: ' pctcsh ' (' bpctcsh ') <br>'
   call lineout tempfile,' % transactions from INITFAST entries: ' pctfast '(' bpctfast ')  <br>'
   call lineout tempfile,' % transactions from main filter: ' pctmain '(' bpctmain ')  <p>'
 
  call lineout aout,'<h3>' sidx.0 ' entries in SREFAST configuration file </h3>'
  call lineout aout,' This is the <i>working </i> configuration file; as produced from INITFAST'
  if nossi=1 then    call lineout aout, ',<em> it is currently being updated </em>'
  call lineout aout,'<p> Note that the <tt>FILE, ORIGFILE, STAMP, and TYPE </tt> fields are created by SREFAST. <p>'




  end
  else do
     call lineout aout,'<html><head><title>SREFAST: Display Entries </title></head>'
     call lineout aout,' <body><h3>' sidx.0 ' entries in SREFAST configuration file </h3>'
  end  /* Do */
  call lineout aout,' <oL> '
  ido=0
  do mm=1 to oog.0
      aw=space(strip(oog.mm),0)
      if aw='0.' then iterate
      parse upper var aw anum '.!' atype
      if anum<>ido then do
          if ido>0 then call lineout aout,'  </menu>'
          call lineout aout,'<li> <B> ' sidx.anum.!sel '</b>'
          call lineout aout,'   <menu>'
          ido=anum
      end
      if  atype="SEL" then iterate
      ali=sidx.aw
      call lineout aout,'       <li> ' atype ': <tt> ' ali ' </tt> '
  end /* do */
  call lineout aout,'</menu></oL> </BODY></HTML> '
  call lineout aout
end  /* Do */
return 1



/* ----------- */
/* get environment value, possibly host specific */
/* ------------ */
get_value: procedure expose enmadd host_nickname
parse arg vname

vname=strip(vname) ; hname=strip(host_nickname)
if hname<>' ' then do
   aval=value(enmadd||vname||'.'||hname,,'os2environment')
   if aval<>' ' Then do
        return aval
   end
end
aval=value(enmadd||vname,,'os2environment')
return aval

/**********/
/* read initfast into doit */
get_initfast:procedure expose port doit. basedir tempfile cfgfile
parse arg amess,nowrite
cfgfile=basedir||'\INITFAST.'||port

aa=0
if stream(cfgfile,'c','query exists')<>""  then aa=sref_fileread(cfgfile,todos,,'E')
if aa=0 then do
    if nowrite=1 then return 0
   call lineout tempfile,'<html><head><title>SREFAST: No Configuration File </title></head>'
   call lineout tempfile,'<BODY><H2>SREFAST ' amess ' error: Missing configuation file </h2> '
   call lineout tempfile,' The required configuration file,' cfgfile', is not available '
   call lineout tempfile,'</body></html>'
   call lineout tempfile
   'FILE ERASE type text/html name ' tempfile
   return 0
end

drop doit.
signal on error name badline ; signal on syntax name badline
ierr=1
do kk=1 to todos.0              /* look for errors */
   aline=strip(todos.kk)
   if aline=' ' then iterate
   if abbrev(aline,';')=1 then iterate
   interpret aline
end /* do */

ierr=0
badline:
signal off error ; signal off syntax
if ierr=1 then do
   if nowrite=1 then return 0
   call lineout tempfile,'<html><head><title>SREFAST: Bad  Entry </title></head>'
   call lineout tempfile,'<BODY><H2>SREFAST ' amess ' error:  Bad entry  </h2> '
   call lineout tempfile,' There is a bad entry in the configuration file,'cfgfile,' near line 'kk)
   call lineout tempfile,'</body></html>'
   call lineout tempfile
   'FILE ERASE type text/html name ' tempfile
   return 0
end

return 1


/**********/
do_refresh:
 cfgfile=basedir||'\INITFAST.'||port
 foo=value('SREF_FAST_REDO',1,'os2environment')  /* srefast shoud also redo */
 call lineout tempfile,'<html><head><title>SREFAST: Index Refresh </title></head>'
 call lineout tempfile,'<BODY><H2>SREFAST Index Refresh </h2> '
 call lineout tempfile,' The SREFAST index will be refreshed in a minute or two'
 call lineout tempfile,'<BR><em> The SREFAST index is generated from the 'cfgfile  ' configuration file.'
 call lineout tempfile,'</body></html>'
 call lineout tempfile
 'FILE ERASE type text/html name ' tempfile
 return 0


